/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.iIMPrincipal;
import com.sun.im.provider.AccessControlItem;
import com.sun.im.provider.AccessControlList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;

public class AccessControlListImpl
implements AccessControlList {
    private int _defaultAccess = 2;
    private LinkedList _items = new LinkedList();
    private Iterator _iter = null;

    protected AccessControlListImpl() {
    }

    protected AccessControlListImpl(int defaultAccess) {
        this._defaultAccess = defaultAccess;
    }

    protected AccessControlListImpl(DestinationAccessControlList dacl) {
        this.init(dacl);
    }

    protected void init(DestinationAccessControlList dacl) {
        this._defaultAccess = dacl.getDefault();
        Enumeration e = dacl.entries();
        while (e.hasMoreElements()) {
            iIMPrincipal p = (iIMPrincipal)e.nextElement();
            this.addPrincipal(p, dacl.getAccess(p));
        }
        this._iter = this._items.iterator();
    }

    protected void addPrincipal(iIMPrincipal p, int access) {
        AccessControlItem aci = new AccessControlItem();
        aci.subjectUID = p.getUID();
        if (!this._items.contains(aci)) {
            aci.access = access;
            aci.subjectDistinguishedName = p.getDistinguishedName();
            this._items.add(aci);
        }
    }

    protected void removePrincipal(iIMPrincipal p) {
        AccessControlItem aci = new AccessControlItem();
        aci.subjectUID = p.getUID();
        this._items.remove(aci);
    }

    public int getDefaultAccess() {
        return this._defaultAccess;
    }

    public Enumeration getAccessControlItems() {
        return new ACLEnumeration();
    }

    public void print() {
        Enumeration e = this.getAccessControlItems();
        while (e.hasMoreElements()) {
            AccessControlItem aci = (AccessControlItem)e.nextElement();
            System.out.println("    " + aci.subjectUID + " <" + aci.subjectDistinguishedName + ">: " + aci.access + "\r\n");
        }
    }

    class ACLEnumeration
    implements Enumeration {
        Iterator i = null;

        public ACLEnumeration() {
            if (AccessControlListImpl.this._items != null) {
                this.i = AccessControlListImpl.this._items.iterator();
            }
        }

        public Object nextElement() {
            return this.i.next();
        }

        public boolean hasMoreElements() {
            if (this.i == null) {
                return false;
            }
            return this.i.hasNext();
        }
    }
}

