/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.QueueMsg;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.server.JMSCalendarMessageListener;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSUser;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSTodo;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;

class CalendarMessageListener
implements MessageListener {
    String _subject = "calendar.alarm";
    iIMQueue _originator = new iIMQueue("calendar_server", NMS.getName());
    Topic _topic;
    boolean _isTodo = false;
    JMSCalendarMessageListener fac;

    public CalendarMessageListener(JMSCalendarMessageListener factory, String topic, String param) {
        this.fac = factory;
        StringTokenizer st = new StringTokenizer(param, "&");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int i = s.indexOf(61);
            if (i <= 0) continue;
            String key = s.substring(0, i);
            if (key.equals("originator")) {
                this._originator = new iIMQueue(s.substring(i + 1), NMS.getName());
            }
            if (!key.equals("eventtype")) continue;
            this._subject = s.substring(i + 1);
            if (!this._subject.endsWith(".todo")) continue;
            this._isTodo = true;
        }
    }

    public void onMessage(javax.jms.Message msg) {
        block13: {
            if (msg == null) {
                this.fac.connectionClosed();
                return;
            }
            TextMessage tMsg = (TextMessage)msg;
            try {
                String calid;
                String type;
                boolean isTodo = this._isTodo;
                if (!isTodo && (type = msg.getStringProperty("comptype")) != null && type.equalsIgnoreCase("todo")) {
                    isTodo = true;
                }
                if ((calid = msg.getStringProperty("calid")) == null) break block13;
                String uid = calid;
                int colon = calid.indexOf(58);
                if (colon > 0) {
                    uid = calid.substring(0, colon);
                }
                String domain = NMS.getName();
                int at = uid.lastIndexOf(64);
                if (at > 0) {
                    domain = uid.substring(at + 1);
                    uid = uid.substring(0, at);
                }
                iIMQueue q = new iIMQueue(uid, domain);
                NMSUser u = null;
                try {
                    u = NMS.getRealm().getUser(q.getUID());
                }
                catch (Exception e) {
                    u = null;
                }
                if (u == null) {
                    Log.out.warning("CalendarReminder: User " + q.getUID() + " Does not exist.");
                    return;
                }
                QueueMsg m = new QueueMsg();
                m.addTo((Destination)q);
                m.setFrom((Destination)this._originator);
                String subject = this._subject;
                if (isTodo) {
                    if (!subject.endsWith(".todo")) {
                        subject = subject + ".todo";
                    }
                } else if (!subject.endsWith(".event")) {
                    subject = subject + ".event";
                }
                m.setSubject(subject);
                String content = this.getTextCalendarContent(tMsg.getText(), isTodo);
                m.setBody((Object)content);
                m.setContentType("text/calendar");
                u.send((Message)m);
                Log.out.debug("CalendarReminder: message sent to " + q.getUID());
            }
            catch (JMSException e) {
                Log.out.printStackTrace((Exception)((Object)e));
            }
        }
    }

    private String getTextCalendarContent(String text, boolean todo) {
        try {
            int i = text.indexOf("<?xml");
            if (i >= 0 && i < 12) {
                StringReader strReader = new StringReader(text);
                TimeZone tz = TimeZone.getDefault();
                if (todo) {
                    VTodo c = SOCSTodo.parse((Reader)strReader, (TimeZone)tz);
                    if (c != null) {
                        return c.toRFC2445();
                    }
                } else {
                    VEvent c = SOCSEvent.parse((Reader)strReader, (TimeZone)tz);
                    if (c != null) {
                        return c.toRFC2445();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        return text;
    }
}

