/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.BooleanAcl;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.PlatformUtil;
import com.sun.im.xmpp.RosterDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Properties;
import org.xml.sax.SAXException;

public class FileUserSettings
extends UserSettings {
    static final String USERDIR = "user";
    static final String USERPROP_FILENAME = "user.properties";
    static final String USERACL_FILENAME = "user.acl";
    static final String ROSTER_FILENAME = "roster.xml";
    static final String CONFERENCE_ROSTER_FILENAME = "conf_roster.xml";
    static final String NEWS_ROSTER_FILENAME = "news_roster.xml";
    static final String HASHSIZE = "iim_server.userdir_hash";
    private static int hashSize;
    static File rootUserDir;
    static DecimalFormat df;

    public static File getUserRootDir(iIMUser u, boolean create) {
        String dir = u.getName();
        String newdir = u.getUID();
        dir = dir.toLowerCase();
        newdir = newdir.toLowerCase();
        int added = dir.hashCode();
        added = Math.abs(added) % hashSize;
        String subdir = df.format(added);
        if (!u.getServer().equalsIgnoreCase(NMS.getName())) {
            dir = newdir;
        }
        File ret = new File(rootUserDir, subdir);
        ret = new File(ret, dir);
        if (create && !ret.exists()) {
            ret.mkdirs();
        }
        if (!ret.exists()) {
            return null;
        }
        if (!ret.isDirectory()) {
            return null;
        }
        return ret;
    }

    protected Properties getUserProperties(iIMUser u) throws IOException {
        Properties p = new Properties();
        File dir = FileUserSettings.getUserRootDir(u, true);
        if (dir != null) {
            File f = new File(dir, USERPROP_FILENAME);
            if (f.exists()) {
                FileInputStream is = new FileInputStream(f);
                p.load(is);
                is.close();
            }
        } else {
            Log.out.debug("Failed to open user directory ");
        }
        return p;
    }

    protected void saveUserProperties(Properties newProps, iIMUser u, boolean merge) throws IOException, Exception {
        Properties p = newProps;
        if (merge) {
            p = this.mergeProperties(this.getUserProperties(u), newProps);
        }
        File f = new File(FileUserSettings.getUserRootDir(u, true), USERPROP_FILENAME);
        File tmpfile = PlatformUtil.getTempFile(f);
        FileOutputStream os = new FileOutputStream(tmpfile);
        p.store(os, u.getDisplayName());
        os.close();
        if (!PlatformUtil.renameTempFile(tmpfile, f)) {
            throw new Exception("Failed to rename " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath());
        }
    }

    protected BooleanAccessControlList getPresenceACL(iIMUser user) throws Exception {
        File f;
        File dir = FileUserSettings.getUserRootDir(user, false);
        if (dir != null && (f = new File(dir, USERACL_FILENAME)).exists()) {
            return BooleanAcl.get(f);
        }
        return null;
    }

    protected void savePresenceACL(iIMUser user, BooleanAccessControlList l) throws IOException {
        File dir = FileUserSettings.getUserRootDir(user, true);
        File f = new File(dir, USERACL_FILENAME);
        BooleanAcl.set(f, l);
    }

    protected RosterDocument getRoster(iIMUser user) throws Exception {
        return this.getRoster(user, ROSTER_FILENAME);
    }

    protected void saveRoster(iIMUser user, RosterDocument roster) throws Exception {
        this.saveRoster(user, roster, ROSTER_FILENAME);
    }

    protected RosterDocument getConferenceRoster(iIMUser user) throws Exception {
        return this.getRoster(user, CONFERENCE_ROSTER_FILENAME);
    }

    protected void saveConferenceRoster(iIMUser user, RosterDocument roster) throws Exception {
        this.saveRoster(user, roster, CONFERENCE_ROSTER_FILENAME);
    }

    protected RosterDocument getNewsRoster(iIMUser user) throws Exception {
        return this.getRoster(user, NEWS_ROSTER_FILENAME);
    }

    protected void saveNewsRoster(iIMUser user, RosterDocument roster) throws Exception {
        this.saveRoster(user, roster, NEWS_ROSTER_FILENAME);
    }

    private RosterDocument getRoster(iIMUser user, String filename) throws Exception {
        File dir = FileUserSettings.getUserRootDir(user, true);
        if (dir != null) {
            RosterDocument doc;
            File f = new File(dir, filename);
            if (!f.exists()) {
                return new RosterDocument();
            }
            FileInputStream is = new FileInputStream(f);
            try {
                doc = new RosterDocument((InputStream)is);
            }
            catch (SAXException spe) {
                Log.out.printStackTrace(spe);
                Log.out.error("Removing corrupted roster file: " + f.getAbsolutePath());
                doc = new RosterDocument();
            }
            is.close();
            return doc;
        }
        Log.out.debug("Failed to open user directory ");
        return null;
    }

    private void saveRoster(iIMUser user, RosterDocument roster, String filename) throws Exception {
        File f = new File(FileUserSettings.getUserRootDir(user, true), filename);
        File tmpfile = PlatformUtil.getTempFile(f);
        FileOutputStream os = new FileOutputStream(tmpfile);
        roster.write((OutputStream)os);
        os.close();
        if (!PlatformUtil.renameTempFile(tmpfile, f)) {
            throw new Exception("Failed to rename " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath());
        }
    }

    static {
        rootUserDir = null;
        df = new DecimalFormat("0000");
        ServerConfig sc = ServerConfig.getServerConfig();
        String hash = sc.getSetting(HASHSIZE, "251");
        try {
            hashSize = Integer.parseInt(hash);
        }
        catch (Exception e) {
            hashSize = 251;
        }
        rootUserDir = new File(NMS.getDBDir(), USERDIR);
        if (!rootUserDir.isDirectory() && !rootUserDir.mkdirs()) {
            Log.out.error("Unable to create User Dir :" + rootUserDir.toString());
        }
    }
}

