/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.JMSManager;
import com.iplanet.im.server.Log;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

class JMSSubscriber {
    Topic _topic;
    TopicConnection _tc;
    TopicSession _topicSession;
    TopicSubscriber _ts;
    MessageListener _listener;
    Thread _retryThread = null;
    String _originator;
    String _key;
    String _type;
    String _sTopic;
    boolean _shutdown = false;

    public JMSSubscriber(TopicConnection tc, String topic, MessageListener listener) throws Exception {
        this._listener = listener;
        this._tc = tc;
        this._sTopic = topic;
    }

    private void createTopicSubscriber() throws JMSException {
        this._topicSession = this._tc.createTopicSession(false, 1);
        this._topic = this._topicSession.createTopic(this._sTopic);
        this._ts = this._topicSession.createSubscriber(this._topic);
    }

    public void start() throws JMSException {
        this._shutdown = false;
        Log.out.info("Starting JMS subscriber " + this._sTopic);
        try {
            this.createTopicSubscriber();
            this._ts.setMessageListener(this._listener);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.warning("Failed to start JMS Subscriber");
            this._retryThread = new Thread(new RetryLater());
            this._retryThread.start();
        }
    }

    public void close() {
        Log.out.info("Stopping JMS subscriber " + this._sTopic);
        this._shutdown = true;
        try {
            if (this._retryThread != null) {
                this._retryThread.join();
            }
            if (this._ts != null) {
                this._ts.close();
                this._ts = null;
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
    }

    class RetryLater
    implements Runnable {
        RetryLater() {
        }

        public void run() {
            while (!JMSSubscriber.this._shutdown) {
                try {
                    JMSSubscriber.this.createTopicSubscriber();
                    JMSSubscriber.this._ts.setMessageListener(JMSSubscriber.this._listener);
                    JMSSubscriber.this._retryThread = null;
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(JMSManager.RETRY_PERIOD);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

