/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSConnection;
import com.iplanet.im.server.NMSMultiSocket;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

class MultiplexSocketManager
implements Runnable {
    private static final byte CMD_NEW = 1;
    private static final byte CMD_CLOSE = 2;
    private static final byte CMD_DATA = 3;
    private static final byte CMD_HELLO = 4;
    private static final byte CMD_BYE = 5;
    private NMS nms;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private Hashtable connections = new Hashtable();
    static Worker _worker;

    MultiplexSocketManager(Socket socket, NMS nms) {
        this.nms = nms;
        this.socket = socket;
        try {
            this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception e) {
            Log.out.error("Cannot open multiplex socket streams");
        }
    }

    public boolean sendCommand(Integer id, CommandData cd) {
        if (this.socket == null) {
            return false;
        }
        NMSMultiSocket connection = (NMSMultiSocket)this.connections.get(id);
        if (connection != null) {
            try {
                ByteArrayOutputStream objectBaos = new ByteArrayOutputStream(2048);
                ObjectOutputStream obos = new ObjectOutputStream(objectBaos);
                obos.writeObject(cd);
                obos.close();
                obos = null;
                ByteArrayOutputStream dataBaos = new ByteArrayOutputStream(2048);
                DataOutputStream data = new DataOutputStream(dataBaos);
                data.writeByte(3);
                data.writeInt(id);
                data.writeInt(objectBaos.size() + 4);
                data.writeInt(objectBaos.size());
                objectBaos.writeTo(data);
                MultiplexSocketManager multiplexSocketManager = this;
                synchronized (multiplexSocketManager) {
                    dataBaos.writeTo(this.os);
                    this.os.flush();
                }
                return true;
            }
            catch (Exception e) {
                Log.out.error("Error writing to multiplex server : " + e);
                return false;
            }
        }
        Log.out.info("MultiplexManager#" + this.hashCode() + " Sending to a non existant multiplex channel " + id);
        return false;
    }

    public void close(Integer id) {
        NMSMultiSocket connection = (NMSMultiSocket)this.connections.remove(id);
        if (connection != null) {
            block7: {
                try {
                    if (this.socket == null) break block7;
                    MultiplexSocketManager multiplexSocketManager = this;
                    synchronized (multiplexSocketManager) {
                        this.os.writeByte(2);
                        this.os.writeInt(id);
                        this.os.flush();
                    }
                }
                catch (Exception e) {
                    Log.out.error("MultiplexManager#" + this.hashCode() + " error closing channel " + id + " : " + e.toString());
                }
            }
            this.connections.remove(id);
            Log.out.debug("MultiplexManager#" + this.hashCode() + " channel " + id + " terminated.");
            connection.onClose();
        } else {
            Log.out.info("MultiplexManager#" + this.hashCode() + " Trying to close non existant channel " + id);
        }
    }

    public void sendHello() {
        block5: {
            try {
                if (this.socket == null) break block5;
                MultiplexSocketManager multiplexSocketManager = this;
                synchronized (multiplexSocketManager) {
                    this.os.writeByte(4);
                    this.os.writeByte(3);
                    this.os.writeByte(0);
                    this.os.flush();
                }
            }
            catch (Exception e) {
                Log.out.error("MultiplexManager#" + this.hashCode() + " error sending HELLO: " + e.toString());
            }
        }
    }

    public void sendBye() {
        block5: {
            try {
                if (this.socket == null) break block5;
                MultiplexSocketManager multiplexSocketManager = this;
                synchronized (multiplexSocketManager) {
                    this.os.writeByte(5);
                    this.os.flush();
                }
            }
            catch (Exception e) {
                Log.out.error("MultiplexManager#" + this.hashCode() + " error sending BYE");
            }
        }
    }

    public void run() {
        boolean error = false;
        block21: while (this.nms.isRunning() && !error) {
            byte cmd;
            try {
                cmd = this.is.readByte();
            }
            catch (Exception e) {
                Log.out.error("MultiplexManager#" + this.hashCode() + " read error " + e);
                break;
            }
            switch (cmd) {
                case 1: {
                    int id;
                    byte[] b = new byte[4];
                    try {
                        id = this.is.readInt();
                        b[0] = this.is.readByte();
                        b[1] = this.is.readByte();
                        b[2] = this.is.readByte();
                        b[3] = this.is.readByte();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.out.error("MultiplexManager#" + this.hashCode() + " Error reading NEW: " + e);
                        break;
                    }
                    Integer ID = new Integer(id);
                    NMSMultiSocket connection = (NMSMultiSocket)this.connections.get(ID);
                    if (connection == null) {
                        StringBuffer buff = new StringBuffer();
                        int i = 0;
                        while (i < b.length) {
                            if (i > 0) {
                                buff.append(".");
                            }
                            buff.append(b[i] & 0xFF);
                            ++i;
                        }
                        NMSMultiSocket ms = new NMSMultiSocket(this, ID, buff.toString());
                        this.connections.put(ID, ms);
                        Log.out.debug("MultiplexManager#" + this.hashCode() + " New channel " + id);
                        InputRunner r = new InputRunner(ms, true);
                        _worker.addRunnable(r, true);
                        break;
                    }
                    Log.out.error("MultiplexManager#" + this.hashCode() + " duplicate channel id " + id);
                    this.close(ID);
                    break;
                }
                case 2: {
                    int id;
                    try {
                        id = this.is.readInt();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.out.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        break;
                    }
                    Integer ID = new Integer(id);
                    NMSMultiSocket connection = (NMSMultiSocket)this.connections.get(ID);
                    if (connection != null) {
                        this.connections.remove(ID);
                        Log.out.debug("MultiplexManager#" + this.hashCode() + " channel " + ID + " closed.");
                        InputRunner r = new InputRunner(connection, false);
                        _worker.addRunnable(r);
                        break;
                    }
                    Log.out.info("MultiplexManager#" + this.hashCode() + " received CLOSE for non existant channel " + id);
                    break;
                }
                case 3: {
                    int id;
                    try {
                        id = this.is.readInt();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.out.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        break;
                    }
                    Integer ID = new Integer(id);
                    NMSMultiSocket connection = (NMSMultiSocket)this.connections.get(ID);
                    int len = 0;
                    try {
                        len = this.is.readInt();
                        if (connection != null) {
                            byte[] ba = new byte[len];
                            int read = 0;
                            while (read < len) {
                                int ret = this.is.read(ba, read, len - read);
                                if (ret == -1) {
                                    Log.out.error("MultiplexManager#" + this.hashCode() + " EOF reached while reading command data");
                                    break;
                                }
                                read += ret;
                            }
                            connection.addBuffer(ba, len);
                            InputRunner r = new InputRunner(connection);
                            _worker.addRunnable(r);
                            break;
                        }
                        Log.out.info("MultiplexManager#" + this.hashCode() + " DATA received for non existant channel " + id + " - skipping " + len + " bytes.");
                        int skipped = this.is.skipBytes(len);
                        Log.out.info("MultiplexManager#" + this.hashCode() + " " + skipped + "/" + len + " bytes skipped for non-existant channel " + id);
                        if (len <= skipped) continue block21;
                        Log.out.error("MultiplexManager#" + this.hashCode() + " skipped less than required: " + skipped + "/");
                    }
                    catch (Exception e) {
                        Log.out.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        error = true;
                    }
                    continue block21;
                }
                case 4: {
                    try {
                        byte major = this.is.readByte();
                        byte minor = this.is.readByte();
                        Log.out.info("MultiplexManager#" + this.hashCode() + " HELLO using " + major + "." + minor + " protocol");
                    }
                    catch (Exception e) {
                        error = true;
                        Log.out.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        break;
                    }
                    this.sendHello();
                    break;
                }
                case 5: {
                    Log.out.notice("MultiplexManager#" + this.hashCode() + " closing");
                    error = true;
                    break;
                }
                default: {
                    Log.out.error("MultiplexManager#" + this.hashCode() + " Unknown Command " + cmd);
                    error = true;
                }
            }
        }
        this.sendBye();
        try {
            this.socket.close();
            this.socket = null;
            this.os.close();
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration e = this.connections.elements();
        while (e.hasMoreElements()) {
            NMSMultiSocket ms = (NMSMultiSocket)e.nextElement();
            ms.onClose();
        }
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        int maxthreads = Integer.parseInt(sc.getSetting("iim_server.maxthreads", "50"));
        _worker = new Worker(4, maxthreads);
    }

    class InputRunner
    implements Runnable {
        NMSMultiSocket s;
        byte cmd;

        InputRunner(NMSMultiSocket s) {
            this.s = s;
            this.cmd = (byte)3;
        }

        InputRunner(NMSMultiSocket s, boolean bNew) {
            this.s = s;
            this.cmd = bNew ? (byte)1 : (byte)2;
        }

        public void run() {
            switch (this.cmd) {
                case 1: {
                    NMSConnection n = new NMSConnection(MultiplexSocketManager.this.nms, this.s);
                    MultiplexSocketManager.this.nms.addUnknownConnection(n);
                    Log.out.info("Added New connection on multiplex");
                    break;
                }
                case 2: {
                    this.s.onClose();
                    break;
                }
                case 3: {
                    this.s.onData();
                }
            }
        }
    }
}

