/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.ConnectionEvent;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.ConnectionStatusListener;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.MessageStatusEvent;
import com.iplanet.im.net.MsgStatusListener;
import com.iplanet.im.net.NetIOException;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.SSLConnectionFactory;
import com.iplanet.im.net.TopicMsg;
import com.iplanet.im.net.UserEvent;
import com.iplanet.im.net.UserStatusListener;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.server.ApprovalCallback;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSConnection;
import com.iplanet.im.server.NMSUser;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.UserLogListener;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.TimeoutException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

class OutServerConnection
implements Runnable,
MsgStatusListener,
UserStatusListener,
ConnectionStatusListener {
    private String host;
    private String username;
    private String password;
    private String domain;
    private boolean useSSL;
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    private ConnectionFactory cf;
    private Hashtable listenersHT = new Hashtable();
    boolean running = true;

    public void msgStatusChange(MessageStatusEvent e) {
        iIMQueue q = (iIMQueue)e.getSourceMessage().args[0];
        if (q.getLocation().equalsIgnoreCase(NMS.getName())) {
            Realm r = NMS.getRealm();
            try {
                NMSUser u = r.getUser(q.getUID(), false);
                if (u.isLoggedOn()) {
                    u.send(e.getSourceMessage());
                }
            }
            catch (Exception err) {
                Log.out.error(this.res.getString("msg_status_unknown") + err.toString());
            }
        } else {
            Log.out.error(this.res.getString("msg_status_wrong"));
        }
    }

    public synchronized void addUserListener(UserLogListener l, String uid) {
        Vector<UserLogListener> listeners = (Vector<UserLogListener>)this.listenersHT.get(uid);
        if (listeners == null) {
            listeners = new Vector<UserLogListener>();
            this.listenersHT.put(uid, listeners);
        }
        if (listeners.contains(l)) {
            return;
        }
        listeners.addElement(l);
    }

    private synchronized void removeUserListener(UserLogListener l, String uid) {
        Vector listeners = (Vector)this.listenersHT.get(uid);
        if (listeners == null) {
            Log.out.debug("Error cannot find listener to remove");
            return;
        }
        listeners.removeElement(l);
    }

    public void userStatusChange(UserEvent e) {
        Vector tl;
        Vector listeners = (Vector)this.listenersHT.get(e.getUID());
        if (listeners == null) {
            Log.out.debug("never did a watch for" + e.getUID());
            return;
        }
        OutServerConnection outServerConnection = this;
        synchronized (outServerConnection) {
            tl = (Vector)listeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            NMSConnection listener = (NMSConnection)tl.elementAt(i);
            if (!listener.sendCommand(e.getSourceMessage())) {
                this.removeUserListener(listener, e.getUID());
            }
            ++i;
        }
    }

    OutServerConnection(String host, String username, String password, boolean useSSL, String domain) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.domain = domain;
        Thread t = new Thread(this);
        t.start();
    }

    public String getName() {
        if (this.cf != null) {
            return this.cf.getServerName();
        }
        return null;
    }

    public boolean isConnected() {
        if (this.cf != null) {
            return this.cf.isConnected();
        }
        return false;
    }

    public CommandData sendCommand(CommandData cd) {
        return this.sendCommand(cd, null);
    }

    public CommandData sendCommand(CommandData cd, NMSConnection conn) {
        CommandData reply2;
        if (!this.isConnected()) {
            CommandData reply2 = Command.createReply((int)cd.command, (int)-1, (String)this.res.getString("Server_is_not"));
            return reply2;
        }
        try {
            switch (cd.command) {
                case 201: {
                    if (conn != null) {
                        Destination d = (Destination)cd.args[0];
                        Connection c = this.cf.findConnection(d);
                        if (c == null) {
                            c = this.cf.createConnection(d);
                        }
                        c.addChangeListener((MessageListener)conn);
                        Log.out.debug("Relaying start to destination " + d.getUID() + " on behalf of " + conn.getUser().getUID());
                        reply2 = this.cf.sendCommand(cd);
                        break;
                    }
                    reply2 = this.cf.sendCommand(cd);
                    break;
                }
                case 202: {
                    if (conn != null) {
                        Destination d = (Destination)cd.args[0];
                        Connection c = this.cf.findConnection(d);
                        if (c != null) {
                            c.removeChangeListener((MessageListener)conn);
                            if (!c.hasChangeListener()) {
                                this.cf.removeConnection(d);
                            }
                        }
                        reply2 = this.cf.sendCommand(cd);
                        break;
                    }
                    reply2 = this.cf.sendCommand(cd);
                    break;
                }
                case 203: {
                    Message m;
                    if (conn != null && ((m = (Message)cd.args[0]) instanceof RoomMsg || m instanceof TopicMsg)) {
                        Log.out.debug("Relaying remote destination message to local subscribers");
                        this.cf.addServerMsg(m, (MessageListener)conn);
                    }
                    reply2 = this.cf.sendCommand(cd);
                    break;
                }
                default: {
                    reply2 = this.cf.sendCommand(cd);
                    break;
                }
            }
        }
        catch (NetIOException nioe) {
            reply2 = Command.createReply((int)cd.command, (int)-1, (String)nioe.getMessage());
            this._close();
        }
        catch (TimeoutException toe) {
            reply2 = Command.createReply((int)cd.command, (int)-1, (String)toe.getMessage());
            this._close();
        }
        catch (CollaborationException e) {
            reply2 = Command.createReply((int)cd.command, (int)-1, (String)e.getMessage());
        }
        return reply2;
    }

    public void run() {
        while (this.running) {
            if (this.cf != null && !this.cf.isConnected()) {
                this.cf.close();
                this.cf = null;
            }
            if (this.cf == null) {
                Properties sp = new Properties();
                ((Hashtable)sp).put("net.server", "true");
                ((Hashtable)sp).put("net.nms", this.host);
                ((Hashtable)sp).put("net.user", this.username + "@" + this.domain);
                ((Hashtable)sp).put("net.password", this.password);
                ((Hashtable)sp).put("net.pinginterval", new Integer(120000));
                try {
                    if (this.useSSL) {
                        Log.out.info("Connection to outbound server using SSL : " + this.host);
                        SSLConnectionFactory sslcf = new SSLConnectionFactory(sp);
                        this.cf = sslcf;
                        int port = 9909;
                        String shost = this.host;
                        int n = this.host.indexOf(58);
                        if (n != -1) {
                            String sport = this.host.substring(n + 1);
                            port = Integer.parseInt(sport);
                            shost = this.host.substring(0, n);
                        }
                        try {
                            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(".");
                            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
                        }
                        catch (KeyDatabaseException kdbe) {
                            Log.out.info("Couldn't open the key database");
                            throw kdbe;
                        }
                        catch (CertDatabaseException cdbe) {
                            Log.out.info("Couldn't open the key database");
                            throw cdbe;
                        }
                        catch (AlreadyInitializedException aie) {
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        SSLSocket socket = new SSLSocket(shost, port, null, 0, (SSLCertificateApprovalCallback)ApprovalCallback.getInstance(), null);
                        sslcf.connect((Socket)socket);
                    } else {
                        Log.out.info("Connection to outbound server using plain socket : " + this.host);
                        this.cf = new ConnectionFactory(sp);
                        this.cf.connect();
                    }
                    this.cf.addConnectionStatusListener((ConnectionStatusListener)this);
                    this.cf.addMsgStatusListener((MsgStatusListener)this);
                    this.cf.addUserStatusListener((UserStatusListener)this);
                    this.cf.login();
                    Log.out.notice("OutServerConnection#" + this.hashCode() + " authenticated to outbound server " + this.cf.getServerName());
                    this._reissueWatches();
                }
                catch (Exception e) {
                    Log.out.printStackTrace(e);
                    try {
                        if (this.cf != null) {
                            this.cf.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cf = null;
                    Log.out.error("OutServerConnection#" + this.hashCode() + " Failed to connect to " + this.host + ": " + e.toString());
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        this.running = false;
        this._close();
    }

    private synchronized void _reissueWatches() {
        Enumeration e = this.listenersHT.keys();
        while (e.hasMoreElements()) {
            Vector tl;
            String id = (String)e.nextElement();
            Vector listeners = (Vector)this.listenersHT.get(id);
            if (listeners == null) continue;
            OutServerConnection outServerConnection = this;
            synchronized (outServerConnection) {
                tl = (Vector)listeners.clone();
            }
            int size = tl.size();
            if (size == 0) continue;
            iIMQueue[] newq = new iIMQueue[1];
            String name = StringUtility.getLocalPartFromAddress(id);
            String server = StringUtility.getDomainFromAddress(id, this.getName());
            newq[0] = new iIMQueue(name, server);
            CommandData nc = Command.create((int)210, (Object)newq, (Object)new Boolean(true));
            int i = 0;
            while (i < size) {
                String reason;
                Integer prevStatus;
                Integer curStatus;
                NMSConnection listener = (NMSConnection)tl.elementAt(i);
                nc.user = listener.getUser();
                CommandData reply = this.sendCommand(nc);
                if (Command.getReplyCode((CommandData)reply) < 0) {
                    curStatus = new Integer(-1);
                    prevStatus = new Integer(-1);
                    reason = "";
                } else {
                    Integer[] replyio = (Integer[])Command.getReplyArg1((CommandData)reply);
                    String[] replyreason = (String[])Command.getReplyArg2((CommandData)reply);
                    Integer[] replyprevStatus = (Integer[])Command.getReplyArg3((CommandData)reply);
                    curStatus = replyio[0];
                    prevStatus = replyprevStatus[0];
                    reason = replyreason[0];
                }
                CommandData cmd = Command.create((int)103, (Object)id, (Object)curStatus, (Object)reason, (Object)prevStatus);
                listener.sendCommand(cmd);
                ++i;
            }
        }
    }

    private synchronized void _close() {
        if (this.cf != null) {
            this.cf.close();
            Enumeration e = this.listenersHT.keys();
            while (e.hasMoreElements()) {
                Vector tl;
                String id = (String)e.nextElement();
                Vector listeners = (Vector)this.listenersHT.get(id);
                if (listeners == null) continue;
                OutServerConnection outServerConnection = this;
                synchronized (outServerConnection) {
                    tl = (Vector)listeners.clone();
                }
                int size = tl.size();
                if (size == 0) continue;
                int status = 2;
                int prevStatus = 2;
                String reason = "";
                CommandData cmd = Command.create((int)103, (Object)id, (Object)new Integer(status), (Object)reason, (Object)new Integer(prevStatus));
                int i = 0;
                while (i < size) {
                    NMSConnection listener = (NMSConnection)tl.elementAt(i);
                    if (!listener.sendCommand(cmd)) {
                        this.removeUserListener(listener, id);
                    }
                    ++i;
                }
            }
        }
        this.cf = null;
    }

    public void connectionLost(ConnectionEvent e) {
        this._close();
    }

    public void updateAvailable(ConnectionEvent e) {
    }
}

