/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CertificateVerify;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class ComSunX509TrustManager
implements X509TrustManager {
    private static KeyStore ks = null;
    private static TrustManagerFactory tmFactory = null;
    TrustManager[] m_trustManagers = null;
    CertificateVerify ci;
    SSLContext ctx;

    public ComSunX509TrustManager(CertificateVerify ci) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, KeyManagementException, IOException, CertificateException {
        if (tmFactory == null) {
            ComSunX509TrustManager.init();
        }
        this.ci = ci;
        this.m_trustManagers = tmFactory.getTrustManagers();
        this.ctx = SSLContext.getInstance((String)"SSLv3");
        TrustManager[] a_tm = new TrustManager[]{this};
        this.ctx.init(null, a_tm, null);
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        int i = 0;
        while (i < this.m_trustManagers.length) {
            X509TrustManager tm = (X509TrustManager)this.m_trustManagers[i];
            if (tm.isClientTrusted(chain)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] chain) {
        int i = 0;
        while (i < this.m_trustManagers.length) {
            X509TrustManager tm = (X509TrustManager)this.m_trustManagers[i];
            if (tm.isServerTrusted(chain)) {
                return true;
            }
            ++i;
        }
        if (this.ci == null) {
            return false;
        }
        return this.ci.doYouTrustCertificate(chain);
    }

    public X509Certificate[] getAcceptedIssuers() {
        int i = 0;
        while (i < this.m_trustManagers.length) {
            if (this.m_trustManagers[i] instanceof X509TrustManager) {
                return ((X509TrustManager)this.m_trustManagers[i]).getAcceptedIssuers();
            }
            ++i;
        }
        return null;
    }

    public SSLSocketFactory getSocketFactory() throws IOException {
        return this.ctx.getSocketFactory();
    }

    private static void init() throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException {
        String libdir = System.getProperty("java.home");
        libdir = libdir + File.separator;
        libdir = libdir + "lib";
        libdir = libdir + File.separator;
        libdir = libdir + "security";
        File f = new File(libdir = libdir + File.separator, "nlcacerts");
        if (!f.exists() && !(f = new File(libdir, "cacerts")).exists()) {
            f = null;
        }
        ks = null;
        if (f == null) {
            ks = null;
        } else {
            ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(f), null);
        }
        tmFactory = TrustManagerFactory.getInstance((String)"SunX509");
        tmFactory.init(ks);
    }

    public static SSLServerSocketFactory getServerSocketFactory(KeyStore ks, String passphrase) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        char[] c = passphrase.toCharArray();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)"SunX509");
        kmf.init(ks, c);
        SSLContext ctx = SSLContext.getInstance((String)"TLS");
        ctx.init(kmf.getKeyManagers(), null, null);
        return ctx.getServerSocketFactory();
    }
}

