/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import java.util.Hashtable;

public abstract class Command {
    public static final int PING = 10;
    public static final int REPLY = 100;
    public static final int MSGADDED = 101;
    public static final int MSGDELED = 102;
    public static final int USERSTATUS = 103;
    public static final int MSGSTATUS = 104;
    public static final int ROOMUSERSTATUS = 105;
    public static final int HELLO = 106;
    public static final int UPDATEAVAIL = 107;
    public static final int BYE = 108;
    public static final int AUTH = 200;
    public static final int START = 201;
    public static final int STOP = 202;
    public static final int ADDMSG = 203;
    public static final int DELMSG = 204;
    public static final int SAVESETTINGS = 205;
    public static final int ADDTOPIC = 206;
    public static final int REMOVETOPIC = 207;
    public static final int GETUSERS = 208;
    public static final int GETGROUPS = 209;
    public static final int WATCH = 210;
    public static final int MARKREAD = 211;
    public static final int ADDROOM = 212;
    public static final int REMOVEROOM = 213;
    public static final int GETACL = 214;
    public static final int SETACL = 215;
    public static final int CHECKACL = 216;
    public static final int GETROOMS = 217;
    public static final int GETTOPICS = 218;
    public static final int GETQUEUES = 219;
    public static final int GETSERVERS = 220;
    public static final int GETSETTINGS = 221;
    public static final int ISMEMBEROF = 222;
    public static final int SETUSERSTATUS = 224;
    public static final int GETGROUPFROMID = 225;
    public static final int USERSEARCH = 226;
    public static final int SAVEDESTPROPS = 227;
    public static final int ARCHIVE = 228;
    public static final int GETANYFROMID = 229;
    public static final int SAVEATTRIBUTES = 230;
    public static final int SUBSCRIBE = 231;
    public static final int UNSUBSCRIBE = 232;
    public static final int SENDGROUPS = 301;
    private static Hashtable ht = new Hashtable();

    public static CommandData create(int command) {
        CommandData data = new CommandData();
        data.command = command;
        return data;
    }

    public static CommandData create(int command, Object arg1) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = new Object[1];
        data.args[0] = arg1;
        return data;
    }

    public static CommandData create(int command, Object arg1, Object arg2) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = new Object[2];
        data.args[0] = arg1;
        data.args[1] = arg2;
        return data;
    }

    public static CommandData create(int command, Object arg1, Object arg2, Object arg3) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = new Object[3];
        data.args[0] = arg1;
        data.args[1] = arg2;
        data.args[2] = arg3;
        return data;
    }

    public static CommandData create(int command, Object arg1, Object arg2, Object arg3, Object arg4) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = new Object[4];
        data.args[0] = arg1;
        data.args[1] = arg2;
        data.args[2] = arg3;
        data.args[3] = arg4;
        return data;
    }

    public static CommandData create(int command, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = new Object[5];
        data.args[0] = arg1;
        data.args[1] = arg2;
        data.args[2] = arg3;
        data.args[3] = arg4;
        data.args[4] = arg5;
        return data;
    }

    public static CommandData createReply(int repliedCommand, int returnCode, String response) {
        CommandData data = new CommandData();
        data.command = 100;
        data.args = new Object[3];
        data.args[0] = new Integer(repliedCommand);
        data.args[1] = new Integer(returnCode);
        data.args[2] = response;
        return data;
    }

    public static CommandData createReply(int repliedCommand, int returnCode, String response, Object arg1) {
        CommandData data = new CommandData();
        data.command = 100;
        data.args = new Object[4];
        data.args[0] = new Integer(repliedCommand);
        data.args[1] = new Integer(returnCode);
        data.args[2] = response;
        data.args[3] = arg1;
        return data;
    }

    public static CommandData createReply(int repliedCommand, int returnCode, String response, Object arg1, Object arg2) {
        CommandData data = new CommandData();
        data.command = 100;
        data.args = new Object[5];
        data.args[0] = new Integer(repliedCommand);
        data.args[1] = new Integer(returnCode);
        data.args[2] = response;
        data.args[3] = arg1;
        data.args[4] = arg2;
        return data;
    }

    public static CommandData createReply(int repliedCommand, int returnCode, String response, Object arg1, Object arg2, Object arg3) {
        CommandData data = new CommandData();
        data.command = 100;
        data.args = new Object[6];
        data.args[0] = new Integer(repliedCommand);
        data.args[1] = new Integer(returnCode);
        data.args[2] = response;
        data.args[3] = arg1;
        data.args[4] = arg2;
        data.args[5] = arg3;
        return data;
    }

    public static boolean checkReplyCommand(int repliedCommand, CommandData cd) {
        Integer i = (Integer)cd.args[0];
        return i == repliedCommand;
    }

    public static int getReplyCode(CommandData cd) {
        Integer i = (Integer)cd.args[1];
        return i;
    }

    public static String getReplyString(CommandData cd) {
        return (String)cd.args[2];
    }

    public static Object getReplyArg1(CommandData cd) {
        return cd.args[3];
    }

    public static Object getReplyArg2(CommandData cd) {
        return cd.args[4];
    }

    public static Object getReplyArg3(CommandData cd) {
        return cd.args[5];
    }

    public static CommandData create(int command, Object[] args) {
        CommandData data = new CommandData();
        data.command = command;
        data.args = args;
        return data;
    }

    public static String toString(CommandData data) {
        return Command.toString(data.command);
    }

    public static String toString(int command) {
        String s = (String)ht.get(new Integer(command));
        if (s == null) {
            s = "unknown command";
        }
        return "command: " + s;
    }

    static {
        ht.put(new Integer(10), "Ping");
        ht.put(new Integer(106), "Hello");
        ht.put(new Integer(100), "Reply");
        ht.put(new Integer(101), "Msg Added");
        ht.put(new Integer(102), "Msg Deled");
        ht.put(new Integer(103), "User Status");
        ht.put(new Integer(104), "Message Status");
        ht.put(new Integer(105), "Room User Status");
        ht.put(new Integer(200), "Auth");
        ht.put(new Integer(201), "Start");
        ht.put(new Integer(202), "Stop");
        ht.put(new Integer(203), "Add Msg");
        ht.put(new Integer(204), "Del Msg");
        ht.put(new Integer(205), "Save Settings");
        ht.put(new Integer(206), "Add Topic");
        ht.put(new Integer(207), "Remove Topic");
        ht.put(new Integer(209), "Get Groups");
        ht.put(new Integer(208), "Get Users");
        ht.put(new Integer(210), "Watch");
        ht.put(new Integer(211), "Mark as Read");
        ht.put(new Integer(212), "Add Room");
        ht.put(new Integer(213), "Remove Room");
        ht.put(new Integer(214), "Get ACL");
        ht.put(new Integer(215), "Set ACL");
        ht.put(new Integer(216), "Check ACL");
        ht.put(new Integer(218), "Get Topics");
        ht.put(new Integer(217), "Get Rooms");
        ht.put(new Integer(219), "Get Queues");
        ht.put(new Integer(220), "Get Servers");
        ht.put(new Integer(221), "Get Settings");
        ht.put(new Integer(301), "Groups");
        ht.put(new Integer(224), "Set User Status");
        ht.put(new Integer(222), "Is Member of");
        ht.put(new Integer(225), "Get Group");
        ht.put(new Integer(226), "User Search");
        ht.put(new Integer(227), "Save Destination Properties");
        ht.put(new Integer(228), "Archive Message");
        ht.put(new Integer(230), "Save Attributes");
        ht.put(new Integer(231), "Subscribe");
        ht.put(new Integer(232), "Unsubscribe");
    }
}

