/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CertificateVerify;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JavaxX509TrustManager
implements X509TrustManager {
    private static KeyStore ks = null;
    private static TrustManagerFactory tmFactory = null;
    TrustManager[] m_trustManagers = null;
    CertificateVerify ci;
    SSLContext ctx;

    public JavaxX509TrustManager(CertificateVerify ci) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, KeyManagementException, IOException, CertificateException {
        if (tmFactory == null) {
            JavaxX509TrustManager.init();
        }
        this.ci = ci;
        this.m_trustManagers = tmFactory.getTrustManagers();
        this.ctx = SSLContext.getInstance("SSLv3");
        TrustManager[] a_tm = new TrustManager[]{this};
        this.ctx.init(null, a_tm, null);
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException, IllegalArgumentException {
        Exception failure = null;
        for (int i = 0; i < this.m_trustManagers.length; ++i) {
            X509TrustManager tm = (X509TrustManager)this.m_trustManagers[i];
            try {
                tm.checkClientTrusted(chain, authType);
                return;
            }
            catch (Exception e) {
                failure = e;
                continue;
            }
        }
        if (failure != null) {
            if (failure instanceof CertificateException) {
                throw (CertificateException)failure;
            }
            throw (IllegalArgumentException)failure;
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException, IllegalArgumentException {
        Exception failure = null;
        for (int i = 0; i < this.m_trustManagers.length; ++i) {
            X509TrustManager tm = (X509TrustManager)this.m_trustManagers[i];
            try {
                tm.checkServerTrusted(chain, authType);
                return;
            }
            catch (Exception e) {
                failure = e;
                continue;
            }
        }
        if (this.ci == null) {
            if (failure != null) {
                if (failure instanceof CertificateException) {
                    throw (CertificateException)failure;
                }
                throw (IllegalArgumentException)failure;
            }
        } else if (!this.ci.doYouTrustCertificate(chain)) {
            throw new CertificateException("Rejected");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        for (int i = 0; i < this.m_trustManagers.length; ++i) {
            if (!(this.m_trustManagers[i] instanceof X509TrustManager)) continue;
            return ((X509TrustManager)this.m_trustManagers[i]).getAcceptedIssuers();
        }
        return null;
    }

    public SSLSocketFactory getSocketFactory() throws IOException {
        return this.ctx.getSocketFactory();
    }

    private static void init() throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException {
        String libdir = System.getProperty("java.home");
        libdir = libdir + File.separator;
        libdir = libdir + "lib";
        libdir = libdir + File.separator;
        libdir = libdir + "security";
        File f = new File(libdir = libdir + File.separator, "nlcacerts");
        if (!f.exists() && !(f = new File(libdir, "cacerts")).exists()) {
            f = null;
        }
        ks = null;
        if (f == null) {
            ks = null;
        } else {
            ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(f), null);
        }
        tmFactory = TrustManagerFactory.getInstance("SunX509");
        tmFactory.init(ks);
    }

    public static SSLServerSocketFactory getServerSocketFactory(KeyStore ks, String passphrase) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        char[] c = passphrase.toCharArray();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, c);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf.getKeyManagers(), null, null);
        return ctx.getServerSocketFactory();
    }
}

