/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import java.util.Properties;

public abstract class ICalendar {
    protected CalendarStore store;
    protected String calId;
    public static final int VEVENT = 1;
    public static final int VTODO = 2;
    public static final int VFREEBUSY = 4;
    public static final int VALL = 7;
    public static final String METHOD_PUBLISH = "PUBLISH";
    public static final String METHOD_REQUEST = "REQUEST";
    public static final String METHOD_REPLY = "REPLY";
    public static final String METHOD_ADD = "ADD";
    public static final String METHOD_CANCEL = "CANCEL";
    public static final String METHOD_REFRESH = "REFRESH";
    public static final String METHOD_COUNTER = "COUNTER";
    public static final String METHOD_DECLINECOUNTER = "DECLINECOUNTER";

    protected ICalendar(CalendarStore calendarStore, String string) {
        this.store = calendarStore;
        this.calId = string;
    }

    public String getCalID() {
        return this.calId;
    }

    public CalendarStore getStore() {
        return this.store;
    }

    public abstract String getProductId();

    public abstract void setProductId(String var1);

    public abstract String getVersion();

    public abstract String getMethod();

    public abstract void setMethod(String var1);

    public abstract String getCalScale();

    public abstract void setCalScale(String var1);

    public abstract String getTimeZone() throws CalendarException;

    public abstract void setTimeZone(String var1) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(int var1) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(DateTime var1, int var2) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(DateTime var1, Duration var2, int var3) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(DateTime var1, DateTime var2, int var3) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(String var1, int var2) throws CalendarException;

    public abstract CalendarComponent[] fetchComponents(String var1, String var2, String var3, int var4) throws CalendarException;

    public abstract Properties getCalProps() throws CalendarException;

    public abstract void setCalProps(Properties var1) throws CalendarException;

    protected abstract void addEvent(VEvent var1, boolean var2) throws CalendarException;

    protected abstract void addTodo(VTodo var1, boolean var2) throws CalendarException;

    public void add(CalendarComponent calendarComponent) throws CalendarException {
        if (calendarComponent instanceof VEvent) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string);
            this.addEvent((VEvent)calendarComponent, bl);
        } else if (calendarComponent instanceof VTodo) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string);
            this.addTodo((VTodo)calendarComponent, bl);
        }
    }

    protected abstract void modifyEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    protected abstract void modifyTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public void modify(CalendarComponent calendarComponent, String string) throws CalendarException {
        if (calendarComponent instanceof VEvent) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string2 = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string2);
            this.modifyEvent((VEvent)calendarComponent, string, bl);
        } else if (calendarComponent instanceof VTodo) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string3 = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string3);
            this.modifyTodo((VTodo)calendarComponent, string, bl);
        }
    }

    protected abstract void deleteEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    protected abstract void deleteTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public void delete(CalendarComponent calendarComponent, String string) throws CalendarException {
        if (calendarComponent instanceof VEvent) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string2 = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string2);
            this.deleteEvent((VEvent)calendarComponent, string, bl);
        } else if (calendarComponent instanceof VTodo) {
            CalendarSession calendarSession = this.getStore().getSession();
            String string3 = calendarSession.getProperty("cal.event.changenotify", "false");
            Boolean bl = new Boolean(string3);
            this.deleteTodo((VTodo)calendarComponent, string, bl);
        }
    }

    public void update() {
    }

    public abstract String toRFC2445();

    public abstract String toString();

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (n < cArray.length - 1 && cArray[n] == '\r' && cArray[n + 1] == '\n') {
                stringBuffer.append("\\r\\n");
            } else if (cArray[n] == '\n') {
                stringBuffer.append("\\r\\n");
            } else if (cArray[n] == '\r') {
                stringBuffer.append("\\r\\n");
            } else if (cArray[n] == '\n') {
                stringBuffer.append("\\:");
            } else if (cArray[n] == '\n') {
                stringBuffer.append("\\;");
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

