/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusy;
import com.sun.comclient.calendar.PropertiesException;
import java.util.Calendar;

public class VFreeBusy
extends CalendarComponent {
    public static final String FREEBUSY = "FREEBUSY";
    public static final String DTEND = "DTEND";
    private boolean hasDuration = false;
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public VFreeBusy(DateTime dateTime, DateTime dateTime2, FreeBusy[] freeBusyArray) throws IllegalArgumentException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setProperty(DTEND, dateTime2);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = false;
        this.removeProperty("DURATION");
    }

    public VFreeBusy(DateTime dateTime, Duration duration, FreeBusy[] freeBusyArray) throws IllegalArgumentException, PropertiesException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setDuration(duration);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = true;
        this.removeProperty(DTEND);
    }

    public VFreeBusy(VFreeBusy vFreeBusy) throws IllegalArgumentException, PropertiesException {
        FreeBusy[] freeBusyArray;
        FreeBusy[] freeBusyArray2;
        if (null == vFreeBusy) {
            throw new IllegalArgumentException("input given for \"vfreebusy\" argument was found to be null");
        }
        this.setStart((DateTime)((Calendar)vFreeBusy.getStart()).clone());
        this.hasDuration = vFreeBusy.hasDuration();
        if (this.hasDuration) {
            freeBusyArray2 = vFreeBusy.getDuration();
            freeBusyArray = new Duration(freeBusyArray2.toRFC2445());
            this.setDuration((Duration)freeBusyArray);
            this.removeProperty(DTEND);
        } else {
            this.setProperty(DTEND, ((Calendar)vFreeBusy.getEnd()).clone());
            this.removeProperty("DURATION");
        }
        freeBusyArray2 = vFreeBusy.getFreeBusy();
        freeBusyArray = new FreeBusy[freeBusyArray2.length];
        int n = 0;
        while (n < freeBusyArray2.length) {
            freeBusyArray[n] = (FreeBusy)freeBusyArray2[n].clone();
            ++n;
        }
        this.setProperty(FREEBUSY, freeBusyArray);
    }

    public Object clone() {
        try {
            return new VFreeBusy(this);
        }
        catch (PropertiesException propertiesException) {
            return null;
        }
    }

    private String calendarComponentToRFC2445() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Attendee[] attendeeArray;
        String string = new String("");
        if (null != this.getID()) {
            string = string + "\nUID:" + this.getID();
        }
        if (null != this.getUrl()) {
            string = string + "\nURL:" + this.getUrl();
        }
        if (null != this.getStamp()) {
            string = string + "\nDTSTAMP:" + this.getStamp().toISOString();
        }
        if (null != this.getOrganizer()) {
            string = string + "\n" + this.getOrganizer().toRFC2445();
        }
        if (null != (attendeeArray = this.getAttendees())) {
            int n = 0;
            while (n < attendeeArray.length) {
                string = string + "\n" + attendeeArray[n].toRFC2445();
                ++n;
            }
        }
        if (null != (stringArray3 = this.getComments())) {
            int n = 0;
            while (n < stringArray3.length) {
                string = string + "\nCOMMENT:" + stringArray3[n];
                ++n;
            }
        }
        if (null != (stringArray2 = this.getContacts())) {
            int n = 0;
            while (n < stringArray2.length) {
                string = string + "\nCONTACT:" + stringArray2[n];
                ++n;
            }
        }
        if (null != (stringArray = this.getRequestStatus())) {
            int n = 0;
            while (n < stringArray.length) {
                string = string + "\nRSTATUS:" + stringArray[n];
                ++n;
            }
        }
        return string;
    }

    private String freeBusyToRFC2445(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        int n = 0;
        while (n < freeBusyArray.length) {
            string = string + "\n" + freeBusyArray[n].toRFC2445();
            ++n;
        }
        return string;
    }

    private String freeBusyToString(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        int n = 0;
        while (n < freeBusyArray.length) {
            string = string + ";\n" + freeBusyArray[n].toString();
            ++n;
        }
        return string;
    }

    public String toRFC2445() {
        return "BEGIN:VFREEBUSY\nDTSTART:" + this.getStart().toISOString() + (this.hasDuration() ? "\n" + this.getDuration().toRFC2445() : "\nDTEND:" + this.getEnd().toISOString()) + this.freeBusyToRFC2445(this.getFreeBusy()) + this.calendarComponentToRFC2445() + "\nEND:VFREEBUSY";
    }

    public String toString() {
        return "VFreeBusy[start=" + this.getStart().toISOString() + "; hasDuration=" + this.hasDuration() + "; end=" + (null == this.getEnd() ? null : this.getEnd().toISOString()) + "; duration=" + (null == this.getDuration() ? null : this.getDuration().toRFC2445().substring(rfcDurationPrefixLength)) + this.freeBusyToString(this.getFreeBusy()) + ";\n" + super.toString() + "\n]";
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty(DTEND);
    }

    public FreeBusy[] getFreeBusy() {
        return (FreeBusy[])this.getProperty(FREEBUSY);
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }
}

