/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api.test;

import com.iplanet.im.client.api.test.NoSuchConferenceException;
import com.iplanet.im.client.api.test.iIMCLIConference;
import com.iplanet.im.client.api.test.iimtalk;
import com.sun.im.service.ConferenceEvent;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.NewsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class iIMCLINewsChannel
extends iIMCLIConference
implements NewsChannelListener {
    int _messageIdCount = 0;
    Hashtable _messageIdToNumber = new Hashtable();
    Hashtable _numberToMessageId = new Hashtable();
    Hashtable _messages;

    public iIMCLINewsChannel(String uid, NewsSession s, String name, boolean subscribe) throws Exception {
        super(uid, name);
        this._conf = subscribe ? s.getNewsChannel(name, (NewsChannelListener)this) : s.getNewsChannel(name, null);
        if (this._conf == null) {
            throw new NoSuchConferenceException("news channel " + name + " does not exist");
        }
        this._messages = new Hashtable();
        this._private = false;
        System.out.println("Got news channel " + this._conf.getDestination());
    }

    public iIMCLINewsChannel(String uid, NewsSession s, String name, int accessLevel) throws Exception {
        super(uid, name);
        this._private = false;
        this._conf = s.newNewsChannel(name, (NewsChannelListener)this, accessLevel);
        this._messages = new Hashtable();
        System.out.println("Created news channel " + this._conf.getDestination());
    }

    public void onMessageAdded(Message message) {
        super.onMessageAdded(message);
        String msgId = message.getMessageId();
        this._messages.put(msgId, message);
        if (this._messageIdToNumber.get(msgId) == null) {
            this._messageIdToNumber.put(msgId, Integer.toString(this._messageIdCount));
            this._numberToMessageId.put(Integer.toString(this._messageIdCount), msgId);
            ++this._messageIdCount;
        }
    }

    public void onEvent(ConferenceEvent event) {
        ConferenceEventHelper ch = null;
        try {
            ch = new ConferenceEventHelper(event.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList tuples = (ArrayList)ch.getTuples();
        int i = 0;
        while (i < tuples.size()) {
            ConferenceEventTuple t = (ConferenceEventTuple)tuples.get(i);
            System.out.println("Destination  " + t.destination + " status " + t.status);
            ++i;
        }
    }

    public void onMessageRemoved(String messageId) {
        System.out.println("[" + this._uid + ":" + this._name + "] message removed -- ");
        this._messages.remove(messageId);
    }

    public void onMessageModified(String messageId, Message message) {
        System.out.println("[" + this._uid + ":" + this._name + "] message modified -- ");
        this._messages.put(messageId, message);
    }

    public void listMessages() throws Exception {
        if (this._messages.size() == 0) {
            Thread.sleep(400L);
        }
        Collection c = this._messages.values();
        System.out.println("*** Start message list for news channel " + this._name);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            System.out.println("id: " + this._messageIdToNumber.get(m.getMessageId()));
            iimtalk.printMessage(m);
        }
        System.out.println("*** End message list for news channel " + this._name);
    }
}

