/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.util.i18n.StringManager;

class Localizer {
    private static StringManager localStrings;

    private Localizer() {
    }

    static String getValue(ExceptionType exceptionType) {
        String string = exceptionType.getString();
        if (localStrings == null) {
            return string;
        }
        try {
            return localStrings.getStringWithDefault(string, string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String getValue(ExceptionType exceptionType, String string) {
        return Localizer.getValue(exceptionType, new Object[]{string});
    }

    static String getValue(ExceptionType exceptionType, int n) {
        return Localizer.getValue(exceptionType, new Object[]{new Integer(n)});
    }

    static String getValue(ExceptionType exceptionType, Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return Localizer.getValue(exceptionType);
        }
        String string = exceptionType.getString();
        if (localStrings == null) {
            return string;
        }
        try {
            return localStrings.getStringWithDefault(string, string, objectArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static {
        try {
            localStrings = StringManager.getManager(Localizer.class.getPackage().getName());
        }
        catch (Exception exception) {
            localStrings = null;
        }
    }
}

