/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.realm.file;

import com.iplanet.ias.security.auth.realm.IASRealm;
import com.iplanet.ias.security.auth.realm.file.FileRealmUser;
import com.iplanet.ias.security.util.IASSecurityException;
import com.iplanet.ias.security.util.SSHA;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public final class FileRealm
extends IASRealm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    private static final String FIELD_SEP = ";";
    private static final String GROUP_SEP = ",";
    private static final String COMMENT = "#";
    public static final String MISC_VALID_CHARS = "_-.";
    private static final int SALT_SIZE = 8;
    private HashMap userTable;
    private Vector groups;
    private boolean constructed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileRealm(String string) throws BadRealmException, NoSuchRealmException {
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            try {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).write("\n".getBytes());
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                String string2 = sm.getString("filerealm.noaccess", exception.toString());
                throw new BadRealmException(string2);
            }
        }
        this.constructed = true;
        object = new Properties();
        ((Properties)object).setProperty(PARAM_KEYFILE, string);
        ((Properties)object).setProperty("jaas-context", "ignore");
        this.init((Properties)object);
    }

    public FileRealm() {
    }

    protected void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String string = properties.getProperty(PARAM_KEYFILE);
        if (string == null) {
            String string2 = sm.getString("filerealm.nofile");
            throw new BadRealmException(string2);
        }
        this.setProperty(PARAM_KEYFILE, string);
        String string3 = properties.getProperty("jaas-context");
        if (string3 == null) {
            String string4 = sm.getString("filerealm.nomodule");
            throw new BadRealmException(string4);
        }
        this.setProperty("jaas-context", string3);
        _logger.fine("FileRealm : file=" + string);
        _logger.fine("FileRealm : jaas-context=" + string3);
        this.loadKeyFile();
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getUserNames() throws BadRealmException {
        return new Vector(this.userTable.keySet()).elements();
    }

    public User getUser(String string) throws NoSuchUserException {
        FileRealmUser fileRealmUser = (FileRealmUser)this.userTable.get(string);
        if (fileRealmUser == null) {
            String string2 = sm.getString("filerealm.nouser", string);
            throw new NoSuchUserException(string2);
        }
        return fileRealmUser;
    }

    public Enumeration getGroupNames() throws BadRealmException {
        return this.groups.elements();
    }

    public Enumeration getGroupNames(String string) throws NoSuchUserException {
        FileRealmUser fileRealmUser = (FileRealmUser)this.userTable.get(string);
        if (fileRealmUser == null) {
            String string2 = sm.getString("filerealm.nouser", string);
            throw new NoSuchUserException(string2);
        }
        String[] stringArray = fileRealmUser.getGroups();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.elements();
    }

    public void refresh() throws BadRealmException {
        _logger.fine("Reloading file realm data.");
        FileRealm fileRealm = new FileRealm();
        Properties properties = new Properties();
        properties.setProperty(PARAM_KEYFILE, this.getProperty(PARAM_KEYFILE));
        try {
            fileRealm.init(properties);
            Realm.updateInstance(fileRealm, this.getName());
        }
        catch (Exception exception) {
            throw new BadRealmException(exception.toString());
        }
    }

    public String[] authenticate(String string, String string2) {
        FileRealmUser fileRealmUser = (FileRealmUser)this.userTable.get(string);
        if (fileRealmUser == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("No such user: [" + string + "]");
            }
            return null;
        }
        boolean bl = false;
        try {
            bl = SSHA.verify(fileRealmUser.getSalt(), fileRealmUser.getHash(), string2.getBytes());
        }
        catch (Exception exception) {
            _logger.fine("File authentication failed: " + exception.toString());
            return null;
        }
        if (!bl) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("File authentication failed for: [" + string + "]");
            }
            return null;
        }
        return fileRealmUser.getGroups();
    }

    private static boolean isValid(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || MISC_VALID_CHARS.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static void validateUserName(String string) throws IASSecurityException {
        if (string == null || string.length() == 0) {
            String string2 = sm.getString("filerealm.noname");
            throw new IASSecurityException(string2);
        }
        if (!FileRealm.isValid(string)) {
            String string3 = sm.getString("filerealm.badname", string);
            throw new IASSecurityException(string3);
        }
        if (!string.equals(string.trim())) {
            String string4 = sm.getString("filerealm.badspaces", string);
            throw new IASSecurityException(string4);
        }
    }

    public static void validatePassword(String string) throws IASSecurityException {
        if (string == null) {
            String string2 = sm.getString("filerealm.emptypwd");
            throw new IASSecurityException(string2);
        }
        if (!string.equals(string.trim())) {
            String string3 = sm.getString("filerealm.badspacespwd");
            throw new IASSecurityException(string3);
        }
    }

    public static void validateGroupName(String string) throws IASSecurityException {
        if (string == null || string.length() == 0) {
            String string2 = sm.getString("filerealm.nogroup");
            throw new IASSecurityException(string2);
        }
        if (!FileRealm.isValid(string)) {
            String string3 = sm.getString("filerealm.badchars", string);
            throw new IASSecurityException(string3);
        }
        if (!string.equals(string.trim())) {
            String string4 = sm.getString("filerealm.badspaces", string);
            throw new IASSecurityException(string4);
        }
    }

    public static void validateGroupList(String[] stringArray) throws IASSecurityException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            FileRealm.validateGroupName(stringArray[i]);
        }
    }

    public void addUser(String string, String string2, String[] stringArray) throws BadRealmException, IASSecurityException {
        FileRealm.validateUserName(string);
        FileRealm.validatePassword(string2);
        FileRealm.validateGroupList(stringArray);
        if (this.userTable.containsKey(string)) {
            String string3 = sm.getString("filerealm.dupuser", string);
            throw new BadRealmException(string3);
        }
        this.addGroupNames(stringArray);
        FileRealmUser fileRealmUser = FileRealm.createNewUser(string, string2, stringArray);
        this.userTable.put(string, fileRealmUser);
    }

    public void removeUser(String string) throws NoSuchUserException {
        if (!this.userTable.containsKey(string)) {
            String string2 = sm.getString("filerealm.nouser", string);
            throw new NoSuchUserException(string2);
        }
        this.userTable.remove(string);
    }

    public void updateUser(String string, String string2, String[] stringArray) throws NoSuchUserException, BadRealmException, IASSecurityException {
        this.updateUser(string, string, string2, stringArray);
    }

    public void updateUser(String string, String string2, String string3, String[] stringArray) throws NoSuchUserException, BadRealmException, IASSecurityException {
        FileRealm.validateUserName(string);
        if (!this.userTable.containsKey(string)) {
            String string4 = sm.getString("filerealm.nouser", string);
            throw new NoSuchUserException(string4);
        }
        FileRealm.validateUserName(string2);
        FileRealm.validateGroupList(stringArray);
        if (string3 != null) {
            FileRealm.validatePassword(string3);
        }
        if (!string.equals(string2) && this.userTable.containsKey(string2)) {
            String string5 = sm.getString("filerealm.dupuser", string);
            throw new BadRealmException(string5);
        }
        FileRealmUser fileRealmUser = (FileRealmUser)this.userTable.get(string);
        if (!$assertionsDisabled && fileRealmUser == null) {
            throw new AssertionError();
        }
        FileRealmUser fileRealmUser2 = new FileRealmUser(string2);
        this.addGroupNames(stringArray);
        fileRealmUser2.setGroups(stringArray);
        if (string3 == null) {
            fileRealmUser2.setSalt(fileRealmUser.getSalt());
            fileRealmUser2.setHash(fileRealmUser.getHash());
        } else {
            FileRealm.setPassword(fileRealmUser2, string3);
        }
        this.userTable.remove(string);
        this.userTable.put(string2, fileRealmUser2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyFile(String string) throws IOException {
        _logger.log(Level.INFO, "filerealm.write", string);
        Class clazz = FileRealm.class;
        synchronized (clazz) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                Iterator iterator = this.userTable.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    FileRealmUser fileRealmUser = (FileRealmUser)this.userTable.get(string2);
                    String string3 = FileRealm.encodeUser(string2, fileRealmUser);
                    fileOutputStream.write(string3.getBytes());
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                _logger.log(Level.WARNING, "filerealm.writeerror", iOException);
                throw iOException;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "filerealm.writeerror", exception);
                String string4 = sm.getString("filerealm.badwrite", exception.toString());
                throw new IOException(string4);
            }
        }
        _logger.fine("Done writing " + string);
    }

    private void addGroupNames(String[] stringArray) throws IASSecurityException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.groups.contains(stringArray[i])) continue;
            this.groups.add(stringArray[i]);
        }
    }

    private void loadKeyFile() throws BadRealmException {
        String string = this.getProperty(PARAM_KEYFILE);
        _logger.fine("Reading file realm: " + string);
        this.userTable = new HashMap();
        HashSet hashSet = new HashSet();
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready()) {
                object = bufferedReader.readLine();
                if (((String)object).startsWith(COMMENT) || ((String)object).indexOf(FIELD_SEP) <= 0) continue;
                FileRealmUser fileRealmUser = FileRealm.decodeUser((String)object, hashSet);
                this.userTable.put(fileRealmUser.getName(), fileRealmUser);
            }
            bufferedReader.close();
            this.groups = new Vector(hashSet.size());
            object = hashSet.iterator();
            while (object.hasNext()) {
                this.groups.add(object.next());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "filerealm.readerror", exception);
            throw new BadRealmException(exception.toString());
        }
    }

    private static String encodeUser(String string, FileRealmUser fileRealmUser) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var3_3 = null;
        stringBuffer.append(string);
        stringBuffer.append(FIELD_SEP);
        String string2 = SSHA.encode(fileRealmUser.getSalt(), fileRealmUser.getHash());
        stringBuffer.append(string2);
        stringBuffer.append(FIELD_SEP);
        String[] stringArray = fileRealmUser.getGroups();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(GROUP_SEP);
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static FileRealmUser decodeUser(String string, HashSet hashSet) throws IASSecurityException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_SEP);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            String string5 = sm.getString("filerealm.syntaxerror", string);
            throw new IASSecurityException(string5);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        byte[] byArray = new byte[20];
        byte[] byArray2 = SSHA.decode(string3, byArray);
        FileRealmUser fileRealmUser = new FileRealmUser(string2);
        fileRealmUser.setHash(byArray);
        fileRealmUser.setSalt(byArray2);
        Vector<String> vector = new Vector<String>();
        if (string4 != null) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, GROUP_SEP);
            while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken();
                vector.add(string6);
                hashSet.add(string6);
            }
        }
        fileRealmUser.setGroups(vector);
        return fileRealmUser;
    }

    private static FileRealmUser createNewUser(String string, String string2, String[] stringArray) throws IASSecurityException {
        FileRealmUser fileRealmUser = new FileRealmUser(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        fileRealmUser.setGroups(stringArray);
        FileRealm.setPassword(fileRealmUser, string2);
        return fileRealmUser;
    }

    private static void setPassword(FileRealmUser fileRealmUser, String string) throws IASSecurityException {
        if (!$assertionsDisabled && fileRealmUser == null) {
            throw new AssertionError();
        }
        byte[] byArray = string.getBytes();
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[8];
        secureRandom.nextBytes(byArray2);
        fileRealmUser.setSalt(byArray2);
        byte[] byArray3 = SSHA.compute(byArray2, byArray);
        fileRealmUser.setHash(byArray3);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            FileRealm.help();
        }
        try {
            if ("-c".equals(stringArray[0])) {
                String[] stringArray2 = new String[]{};
                if (stringArray.length > 3) {
                    stringArray2 = new String[stringArray.length - 3];
                    for (int i = 3; i < stringArray.length; ++i) {
                        stringArray2[i - 3] = stringArray[i];
                    }
                }
                FileRealmUser fileRealmUser = FileRealm.createNewUser(stringArray[1], stringArray[2], stringArray2);
                String string = FileRealm.encodeUser(stringArray[1], fileRealmUser);
                System.out.println(string);
                FileRealmUser fileRealmUser2 = FileRealm.decodeUser(string, new HashSet());
                System.out.println("verifies: " + SSHA.verify(fileRealmUser2.getSalt(), fileRealmUser2.getHash(), stringArray[2].getBytes()));
            } else if ("-v".equals(stringArray[0])) {
                FileRealmUser fileRealmUser = FileRealm.decodeUser(stringArray[2], new HashSet());
                System.out.println("user: " + fileRealmUser.getName());
                System.out.println("verifies: " + SSHA.verify(fileRealmUser.getSalt(), fileRealmUser.getHash(), stringArray[1].getBytes()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static void help() {
        System.out.println("FileRealm -c <name> <pwd> [group]*");
        System.out.println("FileRealm -v <pwd> `output of -c`");
        System.exit(1);
    }

    static {
        $assertionsDisabled = !FileRealm.class.desiredAssertionStatus();
    }
}

