/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.loader.ClassLoaderUtils;
import com.iplanet.ias.security.Audit;
import com.iplanet.ias.security.RealmConfig;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.server.logging.ServerLogManager;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationServer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static PrintStream ostream = System.out;
    public static PrintStream estream = System.err;
    static String[][] servicesByName = new String[][]{{"Naming Service", "com.sun.web.naming.NamingService"}, {"Resource Management Service", "com.sun.web.resource.ResourceManager"}, {"Servlet/JSP Service", "com.iplanet.ias.web.WebContainerLifecycle"}};
    private static ServerContext context = null;
    private ArrayList services = new ArrayList();
    private ClassLoader commonClassLoader;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        Object object;
        context = serverContext;
        ServerLogManager.reInitializeServerLoggers();
        this.printStartupInfo();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InstanceEnvironment instanceEnvironment = context.getInstanceEnvironment();
        try {
            object = instanceEnvironment.getLibClassesPath();
            String string = instanceEnvironment.getLibPath();
            this.commonClassLoader = ClassLoaderUtils.getClassLoader(new File[]{new File((String)object)}, new File[]{new File(string)}, classLoader);
            if (this.commonClassLoader == null) {
                this.commonClassLoader = classLoader;
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "server.ioexception", iOException);
            this.commonClassLoader = classLoader;
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "server.exception", throwable);
            this.commonClassLoader = classLoader;
        }
        if (context instanceof ServerContextImpl) {
            object = (ServerContextImpl)context;
            ((ServerContextImpl)object).setCommonClassLoader(this.commonClassLoader);
            ((ServerContextImpl)object).setLifecycleParentClassLoader(this.commonClassLoader);
        }
        object = this.commonClassLoader;
        AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object){
            private final /* synthetic */ ClassLoader val$commonCL;
            {
                this.val$commonCL = classLoader;
            }

            public Object run() {
                Thread.currentThread().setContextClassLoader(this.val$commonCL);
                return null;
            }
        });
        this.instantiateRuntimeServices();
        this.loadStartupClasses((ClassLoader)object);
        for (int i = 0; i < this.services.size(); ++i) {
            Object e = this.services.get(i);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onInitialization(serverContext);
        }
        RealmConfig.createRealms();
        Audit.init();
    }

    private void loadStartupClasses(ClassLoader classLoader) {
        ResourceBundle resourceBundle = _logger.getResourceBundle();
        String string = System.getProperty("com.sun.web.startupClasses");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            try {
                Class.forName(string2, false, classLoader);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "loaded startup class " + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = resourceBundle.getString("server.load_exception");
                Object[] objectArray = new Object[]{string2, classNotFoundException.toString()};
                string3 = MessageFormat.format(string3, objectArray);
                _logger.log(Level.WARNING, string3);
            }
        }
    }

    private void instantiateRuntimeServices() {
        for (int i = 0; i < servicesByName.length; ++i) {
            try {
                String[] stringArray = servicesByName[i];
                Class<?> clazz = Class.forName(stringArray[1]);
                Object obj = clazz.newInstance();
                this.services.add(obj);
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "server.exception", exception);
            }
        }
    }

    public void onStartup() throws ServerLifecycleException {
        for (int i = 0; i < this.services.size(); ++i) {
            Object e = this.services.get(i);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onStartup(context);
        }
    }

    public void onReady() throws ServerLifecycleException {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ApplicationServer.this.commonClassLoader);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new ServerLifecycleException(exception);
        }
        for (int i = 0; i < this.services.size(); ++i) {
            Object e = this.services.get(i);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onReady(context);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            Object e = this.services.get(i - 1);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onShutdown();
        }
    }

    public void onTermination() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            Object e = this.services.get(i - 1);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onTermination();
        }
        this.services = null;
    }

    public static ServerContext getServerContext() {
        return context;
    }

    private void printStartupInfo() {
        _logger.log(Level.INFO, "j2eerunner.printstartinfo", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")});
    }
}

