/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JWhich {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] classpath = null;
    private String classpathArg = null;
    private String classname = null;
    private String jarClassname = null;
    private boolean doReflect = false;
    private boolean doExhaustive = true;
    private boolean debug_ = false;
    private String result = new String();

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            JWhich.usage();
            return;
        }
        boolean bl = false;
        if (stringArray[0].toLowerCase().equals("-classpath")) {
            if (stringArray.length != 3) {
                JWhich.usage();
                return;
            }
            JWhich jWhich = new JWhich(stringArray[2], stringArray[1]);
        } else {
            JWhich jWhich = new JWhich(stringArray[0]);
        }
    }

    public JWhich(String string, String string2) {
        this.classpathArg = string2;
        this.ctor(string);
    }

    public JWhich(String string) {
        this.ctor(string);
    }

    public String getResult() {
        return this.result;
    }

    private void ctor(String string) {
        this.classname = string;
        this.initClasspath();
        this.fixClassname();
        String[] stringArray = this.findClass();
        this.pr("");
        if (stringArray == null || stringArray.length <= 0) {
            this.pr("Can't find class");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.pr(string + " located in " + stringArray[i]);
        }
    }

    private static void usage() {
        System.out.println("Usage:  java  " + JWhich.class.getName() + " [-classpath a_classpath] classname");
    }

    private void initClasspath() {
        String string = this.classpathArg == null ? System.getProperty("java.class.path") : this.classpathArg;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        int n = stringTokenizer.countTokens();
        this.classpath = new String[n];
        this.debug("" + n + " tokens.");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.debug(string2);
            this.classpath[n2] = string2;
            ++n2;
        }
    }

    private void fixClassname() {
        this.debug("old classname: " + this.classname);
        this.jarClassname = this.classname;
        this.classname = this.classname.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            this.classname = this.classname.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            this.classname = this.classname.replace('\\', File.separatorChar);
        }
        this.jarClassname = this.jarClassname.replace('.', '/');
        this.jarClassname = this.jarClassname.replace('\\', '/');
        this.classname = this.classname + ".class";
        this.jarClassname = this.jarClassname + ".class";
        this.debug("new classname: " + this.classname);
        this.debug("new jarClassname: " + this.jarClassname);
    }

    private String[] findClass() {
        String[] stringArray;
        int n;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (n = 0; n < this.classpath.length; ++n) {
            stringArray = this.classpath[n];
            if (!this.findClass((String)stringArray)) continue;
            arrayList.add(stringArray);
            this.debug("FOUND IT:  " + (String)stringArray);
        }
        n = arrayList.size();
        this.debug("Found it in " + n + " places");
        if (n <= 0) {
            return null;
        }
        stringArray = new String[n];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private boolean findClass(String string) {
        if (string.toLowerCase().endsWith(".jar")) {
            return this.findClassInJar(string);
        }
        File file = new File(string + File.separator + this.classname);
        this.debug("Looking for " + file);
        return file.exists();
    }

    private boolean findClassInJar(String string) {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                zipInputStream.closeEntry();
                if (!string2.equals(this.jarClassname)) continue;
                zipInputStream.close();
                return true;
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            this.debug("" + iOException + "  " + string);
        }
        return false;
    }

    private void debug(String string) {
        if (this.debug_) {
            this.pr(string);
        }
    }

    private void pr(String string) {
        _logger.log(Level.FINE, string);
        this.result = this.result + string;
    }
}

