/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FileLister {
    private ArrayList fileList = null;
    private File mainRoot = null;

    FileLister(File file) {
        this.mainRoot = file;
        this.fileList = new ArrayList();
    }

    protected abstract boolean relativePath();

    public String[] getFiles() {
        this.getFilesInternal(this.mainRoot);
        String[] stringArray = new String[this.fileList.size()];
        if (stringArray.length <= 0) {
            return stringArray;
        }
        int n = 0;
        if (this.relativePath()) {
            n = this.mainRoot.getPath().length() + 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((File)this.fileList.get(i)).getPath().substring(n).replace('\\', '/');
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        return stringArray;
    }

    public void getFilesInternal(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.getFilesInternal(fileArray[i]);
                continue;
            }
            this.fileList.add(fileArray[i]);
        }
    }
}

