/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.io;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class Tee
extends PrintStream {
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;

    private Tee(PrintStream printStream) {
        super(printStream);
    }

    public static void start(String string) throws IOException {
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
        System.setOut(new Tee(System.out));
        System.setErr(new Tee(System.err));
    }

    public static void stop() {
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void write(int n) {
        try {
            logfile.write(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setError();
        }
        super.write(n);
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            logfile.write(byArray, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setError();
        }
        super.write(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            Tee.start("log.txt");
            System.out.println("Here's is some stuff to stdout.");
            System.err.println("Here's is some stuff to stderr.");
            System.out.println("Let's throw an exception...");
            new Exception().printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Tee.stop();
        }
    }
}

