/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.zip;

import com.iplanet.ias.util.diagnostics.Reporter;
import com.iplanet.ias.util.diagnostics.StackTrace;
import com.iplanet.ias.util.io.FileListerRelative;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    private String dirName = null;
    private ZipOutputStream zipStream = null;
    private byte[] buffer = new byte[16384];
    private ZipItem[] items = null;

    public ZipWriter(String string, String string2) throws ZipFileException {
        this.init(string, string2);
        this.createItemList(null);
    }

    public ZipWriter(String string, String string2, ZipItem[] zipItemArray) throws ZipFileException {
        this.items = zipItemArray;
        this.init(string, string2);
    }

    public ZipWriter(String string, String string2, String[] stringArray) throws ZipFileException {
        this.init(string, string2);
        this.createItemList(stringArray);
    }

    public ZipWriter(OutputStream outputStream, String string, String[] stringArray) throws ZipFileException {
        this.init(outputStream, string);
        this.createItemList(stringArray);
    }

    private void init(String string, String string2) throws ZipFileException {
        try {
            this.init(new FileOutputStream(string), string2);
        }
        catch (Exception exception) {
            throw new ZipFileException(exception);
        }
    }

    private void init(OutputStream outputStream, String string) throws ZipFileException {
        try {
            Reporter.insist(string);
            File file = new File(string);
            Reporter.insist(file.exists(), "directory (" + string + ") doesn't exist");
            Reporter.insist(file.isDirectory());
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Reporter.warn("Couldn't getCanonicalPath() for " + string);
            }
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            this.dirName = string;
            this.zipStream = new ZipOutputStream(outputStream);
        }
        catch (Throwable throwable) {
            throw new ZipFileException(throwable);
        }
    }

    public void safeWrite() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                try {
                    this.addEntry(this.items[i]);
                    continue;
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
            this.zipStream.close();
        }
        catch (ZipFileException zipFileException) {
            Reporter.critical(new StackTrace(zipFileException));
            throw zipFileException;
        }
        catch (Exception exception) {
            Reporter.critical(new StackTrace(exception));
            throw new ZipFileException(exception);
        }
    }

    public void write() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                this.addEntry(this.items[i]);
            }
            this.zipStream.close();
        }
        catch (ZipFileException zipFileException) {
            Reporter.critical(new StackTrace(zipFileException));
            throw zipFileException;
        }
        catch (Exception exception) {
            Reporter.critical(new StackTrace(exception));
            throw new ZipFileException(exception);
        }
    }

    private void addEntry(ZipItem zipItem) throws ZipFileException, IOException {
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(zipItem.file);
        ZipEntry zipEntry = new ZipEntry(zipItem.name);
        this.zipStream.putNextEntry(zipEntry);
        int n2 = fileInputStream.read(this.buffer);
        while (n2 > 0) {
            this.zipStream.write(this.buffer, 0, n2);
            n += n2;
            n2 = fileInputStream.read(this.buffer);
        }
        this.zipStream.closeEntry();
        Reporter.verbose("Wrote " + zipItem.name + " to Zip File.  Wrote " + n + " bytes.");
    }

    private void createItemList(String[] stringArray) throws ZipFileException {
        try {
            if (stringArray == null) {
                FileListerRelative fileListerRelative = new FileListerRelative(new File(this.dirName));
                stringArray = fileListerRelative.getFiles();
            }
            if (stringArray.length <= 0) {
                throw new ZipFileException("No files to add!");
            }
            this.items = new ZipItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this.dirName + stringArray[i]);
                this.items[i] = new ZipItem(file, stringArray[i].replace('\\', '/'));
            }
        }
        catch (Throwable throwable) {
            throw new ZipFileException(throwable);
        }
    }

    String getDirName() {
        return this.dirName;
    }

    private static void usage() {
        System.out.println("usage: java com.elf.util.zip.ZipWriter zip-filename directory-name");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Reporter.setSeverityLevel(0);
        if (stringArray == null || stringArray.length != 2) {
            ZipWriter.usage();
        }
        try {
            ZipWriter zipWriter = new ZipWriter(stringArray[0], stringArray[1]);
            zipWriter.write();
            Reporter.verbose("" + zipWriter);
        }
        catch (ZipFileException zipFileException) {
            Reporter.verbose("ZipFileException: " + zipFileException);
            System.exit(0);
        }
    }
}

