/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.util.logging.IASLevel;
import com.iplanet.ias.web.CacheModule;
import com.iplanet.ias.web.VirtualServer;
import com.iplanet.ias.web.WebModule;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.logging.LogDomains;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;

final class WebModuleListener
implements LifecycleListener {
    private static Logger _logger;
    private static boolean _debugLog;

    WebModuleListener() {
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        WebModule webModule;
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        try {
            webModule = (WebModule)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", lifecycleEvent.getLifecycle());
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.configureJspParameters(webModule);
            this.startCacheManager(webModule);
            this.setWSContextAttributes(webModule);
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJspParameters(WebModule webModule) {
        SunWebApp sunWebApp = webModule.getIasWebAppConfigBean();
        Container[] containerArray = webModule.findChildren();
        if (containerArray == null) {
            return;
        }
        for (int i = 0; i < containerArray.length; ++i) {
            boolean bl;
            Wrapper wrapper = (Wrapper)containerArray[i];
            String string = wrapper.getServletClass();
            boolean bl2 = string != null && (string.equals("org.apache.jasper.servlet.JspServlet") || string.equals("com.iplanet.ias.web.jsp.JspServlet"));
            boolean bl3 = bl = wrapper.getJspFile() != null;
            if (!bl2 && !bl) continue;
            if (sunWebApp != null && sunWebApp.getJspConfig() != null) {
                WebProperty[] webPropertyArray = sunWebApp.getJspConfig().getWebProperty();
                for (int j = 0; j < webPropertyArray.length; ++j) {
                    String string2 = webPropertyArray[j].getAttributeValue("name");
                    String string3 = webPropertyArray[j].getAttributeValue("value");
                    if (_debugLog) {
                        _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + string2 + "] = [" + string3 + "]");
                    }
                    wrapper.addInitParameter(string2, string3);
                }
            }
            wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
        }
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level.equals(IASLevel.FATAL)) {
            return "fatal";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebApp sunWebApp = webModule.getIasWebAppConfigBean();
        if (sunWebApp != null) {
            CacheManager cacheManager = null;
            try {
                cacheManager = CacheModule.configureResponseCache(webModule, sunWebApp);
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", exception);
            }
            if (cacheManager != null) {
                try {
                    cacheManager.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext servletContext = webModule.getServletContext();
                    servletContext.setAttribute("com.sun.appserv.web.CacheManager", (Object)cacheManager);
                }
                catch (LifecycleException lifecycleException) {
                    _logger.log(Level.WARNING, lifecycleException.getMessage(), lifecycleException.getThrowable());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext servletContext = webModule.getServletContext();
        CacheManager cacheManager = (CacheManager)servletContext.getAttribute("com.sun.appserv.web.CacheManager");
        if (cacheManager != null) {
            try {
                cacheManager.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                servletContext.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException lifecycleException) {
                _logger.log(Level.WARNING, lifecycleException.getMessage(), lifecycleException.getThrowable());
            }
        }
    }

    private void setWSContextAttributes(WebModule webModule) {
        ServletContext servletContext = webModule.getServletContext();
        VirtualServer virtualServer = (VirtualServer)webModule.getParent();
        servletContext.setAttribute("com.sun.web.vsid", (Object)virtualServer.getID());
        ClassLoader classLoader = webModule.getLoader().getClassLoader();
        if (classLoader != null) {
            servletContext.setAttribute("com.iplanet.server.http.servlet.classloader", (Object)classLoader);
        }
        if (webModule.getStatsEnabled()) {
            LinkedList<WebModule> linkedList = new LinkedList<WebModule>();
            linkedList.add(webModule);
            servletContext.setAttribute("com.sun.web.stats", linkedList);
        }
    }
}

