/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import java.io.IOException;
import javax.servlet.ServletInputStream;

final class NSAPIRequestStream
extends ServletInputStream {
    private NSAPIConnector _connector;
    private int _maxBytes = -1;
    private int _count = 0;

    public NSAPIRequestStream(NSAPIConnector nSAPIConnector) {
        this._connector = nSAPIConnector;
    }

    public NSAPIRequestStream(NSAPIConnector nSAPIConnector, int n) {
        this._connector = nSAPIConnector;
        this._maxBytes = n;
    }

    public int read() throws IOException {
        if (this._maxBytes != -1 && this._count == this._maxBytes) {
            return -1;
        }
        int n = this._connector.readByte();
        if (n != -1) {
            ++this._count;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + n2 >= this._maxBytes) {
                n2 = this._maxBytes - this._count;
            }
        }
        if ((n3 = this._connector.read(byArray, n, n2)) > 0) {
            this._count += n3;
        }
        return n3;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + n2 >= this._maxBytes) {
                n2 = this._maxBytes - this._count;
            }
        }
        if ((n3 = this._connector.readLine(byArray, n, n2)) > 0) {
            this._count += n3;
        }
        return n3;
    }

    public int available() throws IOException {
        throw new IOException("NSAPIRequestStream.available");
    }

    public void close() {
        this._connector.skip(this._maxBytes - this._count);
    }
}

