/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.jsp;

import com.iplanet.ias.web.StatsSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspMangler;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;

public class JspServlet
extends HttpServlet
implements StatsSource {
    private static final int DEFAULT_INITIAL_CAPACITY = 32;
    protected ServletContext context = null;
    protected String httpMethodsString = null;
    protected HashSet httpMethodsSet = null;
    protected Map jsps = null;
    protected ServletConfig config;
    protected Options options;
    protected URLClassLoader parentClassLoader;
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    private long reloadInterval = 0L;
    private int initialCapacity = 32;
    private boolean checkJSPmods = true;
    private boolean debugLogEnabled = false;
    String outputDir = null;
    URL[] loaderURLs = null;
    static boolean firstTime = true;
    private int countReloads = 0;
    private int countErrors;
    private Object errorCountLk = new Object();

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        Object object2;
        Policy policy;
        String string;
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        Constants.jasperLog = new DefaultLogger(this.context);
        Constants.jasperLog.setName("JASPER_LOG");
        Constants.jasperLog.setTimestamp("false");
        Constants.jasperLog.setVerbosityLevel(servletConfig.getInitParameter("logVerbosityLevel"));
        this.debugLogEnabled = Constants.jasperLog.matchVerbosityLevel(4);
        String string2 = servletConfig.getInitParameter("reload-interval");
        if (string2 != null) {
            try {
                this.reloadInterval = Integer.parseInt(string2) * 1000;
                if (this.reloadInterval < 0L) {
                    this.checkJSPmods = false;
                    Constants.message("jsp.message.recompile.disabled", 3);
                } else if (this.reloadInterval > 0L) {
                    Constants.message("jsp.message.reload.interval", new Object[]{string2}, 3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Constants.message("jsp.warning.interval.invalid", new Object[]{string2}, 2);
            }
        }
        if ((string = servletConfig.getInitParameter("initial-capacity")) != null) {
            try {
                int n;
                this.initialCapacity = Integer.parseInt(string);
                for (n = 32; n < this.initialCapacity; n *= 2) {
                }
                this.initialCapacity = n;
            }
            catch (NumberFormatException numberFormatException) {
                Constants.message("jsp.warning.initialcapacity.invalid", new Object[]{string, new Integer(32)}, 2);
            }
        }
        this.httpMethodsString = servletConfig.getInitParameter("httpMethods");
        if (this.httpMethodsString == null) {
            this.httpMethodsString = "GET,HEAD,POST";
        }
        if (!this.httpMethodsString.equals("*")) {
            this.httpMethodsSet = new HashSet();
            StringTokenizer stringTokenizer = new StringTokenizer(this.httpMethodsString, ", \t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                this.httpMethodsSet.add(stringTokenizer.nextToken());
            }
        }
        this.jsps = this.checkJSPmods ? new HashMap(this.initialCapacity) : new Hashtable(this.initialCapacity);
        this.options = new EmbededServletOptions(servletConfig, this.context);
        this.outputDir = this.options.getScratchDir().toString();
        File file = new File(this.outputDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.loaderURLs = new URL[1];
        try {
            this.loaderURLs[0] = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServletException((Throwable)malformedURLException);
        }
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        }
        String string3 = "<none>";
        if (this.parentClassLoader != null) {
            string3 = this.parentClassLoader.toString();
        }
        if (this.debugLogEnabled) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{string3}, 4);
        }
        if ((policy = Policy.getPolicy()) != null) {
            try {
                object2 = this.context.getRealPath("/");
                if (object2 == null) {
                    object2 = this.outputDir;
                }
                object = new URL("file:" + (String)object2);
                this.codeSource = new CodeSource((URL)object, null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                object2 = ((String)object2).endsWith(File.separator) ? (String)object2 + "-" : (String)object2 + File.separator + "-";
                this.permissionCollection.add(new FilePermission((String)object2, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] uRLArray = this.parentClassLoader.getURLs();
                    String string4 = null;
                    String string5 = null;
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (string5 == null && uRLArray[i].toString().startsWith("jndi:")) {
                            string5 = uRLArray[i].toString() + "-";
                        }
                        if (string4 != null || !uRLArray[i].toString().startsWith("jar:jndi:")) continue;
                        string4 = uRLArray[i].toString();
                        string4 = string4.substring(0, string4.length() - 2);
                        string4 = string4.substring(0, string4.lastIndexOf(47)) + "/-";
                    }
                    if (string4 != null) {
                        this.permissionCollection.add(new FilePermission(string4, "read"));
                        this.permissionCollection.add(new FilePermission(string4.substring(4), "read"));
                    }
                    if (string5 != null) {
                        this.permissionCollection.add(new FilePermission(string5, "read"));
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (firstTime) {
            firstTime = false;
            if (System.getSecurityManager() != null) {
                object2 = "org.apache.jasper.";
                object = "com.iplanet.ias.web.jsp.";
                try {
                    this.parentClassLoader.loadClass((String)object2 + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                    this.parentClassLoader.loadClass((String)object2 + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                    this.parentClassLoader.loadClass((String)object2 + "runtime.JspRuntimeLibrary");
                    this.parentClassLoader.loadClass((String)object2 + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                    this.parentClassLoader.loadClass((String)object2 + "runtime.ServletResponseWrapperInclude");
                    this.getClass().getClassLoader().loadClass((String)object + "JspServlet$JspServletWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Constants.jasperLog.log(Constants.getString("jsp.message.preload.failure"), classNotFoundException, 2);
                }
            }
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.outputDir}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
        if ((object2 = (LinkedList)this.context.getAttribute("com.sun.web.stats")) != null) {
            ((LinkedList)object2).add(this);
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (this.httpMethodsSet != null && (string = httpServletRequest.getMethod()) != null && !this.httpMethodsSet.contains(string)) {
            if (string.equals("OPTIONS")) {
                httpServletResponse.addHeader("Allow", this.httpMethodsString);
            }
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        try {
            String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            string = string2 == null ? httpServletRequest.getServletPath() : string2;
            String string3 = (String)httpServletRequest.getAttribute("org.apache.catalina.jsp_file");
            if (string3 != null) {
                string = string3;
            }
            if (this.debugLogEnabled) {
                Logger logger = Constants.jasperLog;
                logger.log("JspEngine --> " + string);
                logger.log("   ServletPath: " + httpServletRequest.getServletPath());
                logger.log("      PathInfo: " + httpServletRequest.getPathInfo());
                logger.log("      RealPath: " + this.context.getRealPath(string));
                logger.log("    RequestURI: " + httpServletRequest.getRequestURI());
                logger.log("   QueryString: " + httpServletRequest.getQueryString());
            }
            this.serviceJspFile(httpServletRequest, httpServletResponse, string);
        }
        catch (RuntimeException runtimeException) {
            this.incrementErrorCount();
            throw runtimeException;
        }
        catch (ServletException servletException) {
            this.incrementErrorCount();
            throw servletException;
        }
        catch (IOException iOException) {
            this.incrementErrorCount();
            throw iOException;
        }
        catch (Throwable throwable) {
            this.incrementErrorCount();
            throw new ServletException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        Object object = null;
        try {
            Object object2;
            if (this.checkJSPmods) {
                object = this.getWrapper(string);
                if (object == null) {
                    object2 = this;
                    synchronized (object2) {
                        object = this.getWrapper(string);
                        if (object == null) {
                            object = new JspServletWrapper(string);
                            ((JspServletWrapper)object).loadJSP(httpServletRequest, httpServletResponse);
                            this.putWrapper(string, (JspServletWrapper)object, false);
                        }
                    }
                } else if (((JspServletWrapper)object).isJspFileModified()) {
                    object2 = new JspServletWrapper(string);
                    ((JspServletWrapper)object2).loadJSP(httpServletRequest, httpServletResponse);
                    this.putWrapper(string, (JspServletWrapper)object2, true);
                    this.releaseWrapper((JspServletWrapper)object);
                    object = object2;
                }
            } else {
                object = (JspServletWrapper)this.jsps.get(string);
                if (object == null) {
                    object2 = this;
                    synchronized (object2) {
                        object = (JspServletWrapper)this.jsps.get(string);
                        if (object == null) {
                            object = new JspServletWrapper(string);
                            ((JspServletWrapper)object).loadJSP(httpServletRequest, httpServletResponse);
                            this.jsps.put(string, object);
                        }
                    }
                }
            }
            object2 = ((JspServletWrapper)object).getCompileException();
            if (object2 != null) {
                throw object2;
            }
            if (!this.preCompile(httpServletRequest)) {
                object.service(httpServletRequest, httpServletResponse);
            }
        }
        catch (JSPFileNotFoundException jSPFileNotFoundException) {
            String string2;
            if (this.checkJSPmods) {
                this.removeWrapper(string);
            }
            if ((string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri")) != null) {
                throw new ServletException((Throwable)jSPFileNotFoundException);
            }
            try {
                httpServletResponse.sendError(404);
                Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{jSPFileNotFoundException.getMessage()}), 2);
            }
            catch (IllegalStateException illegalStateException) {
                Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{jSPFileNotFoundException.getMessage()}), jSPFileNotFoundException, 1);
            }
        }
        finally {
            if (this.checkJSPmods) {
                this.releaseWrapper((JspServletWrapper)object);
            }
        }
    }

    private synchronized JspServletWrapper getWrapper(String string) {
        JspServletWrapper jspServletWrapper = (JspServletWrapper)this.jsps.get(string);
        if (jspServletWrapper != null) {
            jspServletWrapper.incrementRefCount();
        }
        return jspServletWrapper;
    }

    private synchronized void releaseWrapper(JspServletWrapper jspServletWrapper) {
        if (jspServletWrapper != null) {
            jspServletWrapper.decrementRefCount();
        }
    }

    private synchronized void putWrapper(String string, JspServletWrapper jspServletWrapper, boolean bl) {
        jspServletWrapper.incrementRefCount();
        JspServletWrapper jspServletWrapper2 = this.jsps.put(string, jspServletWrapper);
        if (jspServletWrapper2 != null) {
            jspServletWrapper2.tryDestroy();
        }
        if (bl) {
            ++this.countReloads;
        }
    }

    private synchronized void removeWrapper(String string) {
        JspServletWrapper jspServletWrapper = (JspServletWrapper)this.jsps.remove(string);
        if (jspServletWrapper != null) {
            jspServletWrapper.tryDestroy();
        }
    }

    boolean preCompile(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        String string2 = httpServletRequest.getQueryString();
        if (string2 == null) {
            return false;
        }
        int n = string2.indexOf("jsp_precompile");
        if (n < 0) {
            return false;
        }
        if ((string2 = string2.substring(n + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (string2.startsWith("&")) {
            return true;
        }
        if (!string2.startsWith("=")) {
            return false;
        }
        int n2 = string2.length();
        int n3 = string2.indexOf("&");
        if (n3 > 0) {
            n2 = n3;
        }
        if ((string = string2.substring(1, n2)).equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        JspServlet jspServlet = this;
        synchronized (jspServlet) {
            Iterator iterator = this.jsps.values().iterator();
            while (iterator.hasNext()) {
                ((JspServletWrapper)iterator.next()).destroy();
            }
            this.jsps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementErrorCount() {
        Object object = this.errorCountLk;
        synchronized (object) {
            ++this.countErrors;
        }
    }

    public String getName() {
        return "JSPs";
    }

    public Map getStats() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("initialCapacity", new Integer(this.initialCapacity));
        hashMap.put("countJsps", new Integer(this.jsps.size()));
        hashMap.put("countReloads", new Integer(this.countReloads));
        hashMap.put("countErrors", new Integer(this.countErrors));
        return hashMap;
    }

    class JSPFileNotFoundException
    extends FileNotFoundException {
        public JSPFileNotFoundException() {
        }

        public JSPFileNotFoundException(String string) {
            super(string);
        }
    }

    class JspServletWrapper {
        String jspUri;
        File jspFile = null;
        boolean jspFileExists = true;
        String jspClassName = null;
        Class servletClass = null;
        Servlet theServlet = null;
        int refCount = 0;
        boolean markedForDestroy = false;
        URLClassLoader loader = null;
        volatile long lastCheckedTime = 0L;
        volatile long jspLastModifiedTime = 0L;
        JasperException compileException = null;

        JspServletWrapper(String string) throws ServletException, JSPFileNotFoundException {
            this.jspUri = string;
            String string2 = JspServlet.this.context.getRealPath(string);
            if (string2 == null) {
                throw new JSPFileNotFoundException(string);
            }
            this.jspFile = new File(string2);
            this.jspFileExists = this.jspFile.exists();
            if (JspServlet.this.checkJSPmods && !this.jspFileExists) {
                throw new JSPFileNotFoundException(string);
            }
            JspMangler jspMangler = new JspMangler(string, JspServlet.this.outputDir);
            this.jspClassName = jspMangler.getPackageName() + "." + jspMangler.getClassName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            if (this.theServlet instanceof SingleThreadModel) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
            } else {
                this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isJspFileModified() throws JSPFileNotFoundException {
            boolean bl = false;
            long l = System.currentTimeMillis();
            if (l >= JspServlet.this.reloadInterval + this.lastCheckedTime) {
                long l2 = this.jspFile.lastModified();
                if (l2 == 0L) {
                    throw new JSPFileNotFoundException(this.jspUri);
                }
                if (l2 != this.jspLastModifiedTime) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (l2 != this.jspLastModifiedTime) {
                            this.jspLastModifiedTime = l2;
                            bl = true;
                        }
                    }
                }
                this.lastCheckedTime = l;
            }
            return bl;
        }

        private void loadJSP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, JSPFileNotFoundException {
            if (!JspServlet.this.checkJSPmods && !this.jspFileExists) {
                try {
                    this.loadAndInit();
                }
                catch (JasperException jasperException) {
                    Constants.jasperLog.log(jasperException.getMessage(), jasperException.getRootCause(), 3);
                    throw new JSPFileNotFoundException(this.jspUri);
                }
                return;
            }
            String string = (String)JspServlet.this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (JspServlet.this.debugLogEnabled) {
                Constants.message("jsp.message.context.classpath", new Object[]{string == null ? "<none>" : string}, 4);
            }
            JspEngineContext jspEngineContext = new JspEngineContext(JspServlet.this.parentClassLoader, string, JspServlet.this.context, this.jspUri, false, JspServlet.this.options, httpServletRequest, httpServletResponse);
            Compiler compiler = jspEngineContext.createCompiler();
            if (JspServlet.this.checkJSPmods) {
                this.lastCheckedTime = System.currentTimeMillis();
                this.jspLastModifiedTime = this.jspFile.lastModified();
            }
            try {
                compiler.compile();
            }
            catch (JasperException jasperException) {
                this.compileException = jasperException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                compiler.removeGeneratedFiles();
                throw new JSPFileNotFoundException(fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                this.compileException = new JasperException(Constants.getString("jsp.error.unable.compile"), exception);
            }
            if (this.compileException == null) {
                this.loadAndInit();
            }
        }

        private void loadAndInit() throws JasperException, ServletException {
            try {
                this.loader = new JasperLoader(JspServlet.this.loaderURLs, this.jspClassName, JspServlet.this.parentClassLoader, JspServlet.this.permissionCollection, JspServlet.this.codeSource);
                this.servletClass = this.loader.loadClass(this.jspClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), classNotFoundException);
            }
            try {
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(exception);
            }
            this.theServlet.init(JspServlet.this.config);
        }

        private JasperException getCompileException() {
            return this.compileException;
        }

        private void incrementRefCount() {
            ++this.refCount;
        }

        private void decrementRefCount() {
            --this.refCount;
            if (this.refCount == 0 && this.markedForDestroy) {
                this.destroy();
            }
        }

        private void tryDestroy() {
            if (this.refCount == 0) {
                this.destroy();
            }
            this.markedForDestroy = true;
        }

        private void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
            this.servletClass = null;
            this.theServlet = null;
            this.jspFile = null;
            this.loader = null;
        }
    }
}

