/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class WriterOutputStream
extends OutputStream {
    private Writer _writer = null;
    private CharsetDecoder _charsetDecoder = null;

    public WriterOutputStream(Writer writer) {
        this._writer = writer;
    }

    public WriterOutputStream(Writer writer, String string) {
        this._writer = writer;
        Charset charset = Charset.forName(string);
        this._charsetDecoder = charset != null ? charset.newDecoder() : null;
    }

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder) {
        this._writer = writer;
        this._charsetDecoder = charsetDecoder;
    }

    public void write(byte[] byArray) throws IOException {
        if (this._charsetDecoder == null) {
            this._writer.write(new String(byArray));
        } else {
            this.write(ByteBuffer.wrap(byArray));
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._charsetDecoder == null) {
            this._writer.write(new String(byArray, n, n2));
        } else {
            this.write(ByteBuffer.wrap(byArray, n, n2));
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    private void write(ByteBuffer byteBuffer) throws IOException {
        this._charsetDecoder.reset();
        CharBuffer charBuffer = null;
        try {
            charBuffer = this._charsetDecoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IOException(characterCodingException.getMessage());
        }
        if (charBuffer != null) {
            this._writer.write(charBuffer.array());
        }
    }
}

