/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.util;

import com.iplanet.server.http.util.LogUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.catalina.util.StringManager;

public final class SrvUtil {
    private static SrvUtil _this = new SrvUtil();
    private static MessageDigest _digest = null;
    private static Random _random = null;
    private static String _entropy = null;
    private static final String DEFAULT_ALGORITHM = "MD5";
    private static final int SESSION_ID_BYTES = 16;
    private static String _algorithm = "MD5";
    private static StringManager _sm = StringManager.getManager("org.apache.catalina.session");
    private static String _randomClass = "java.security.SecureRandom";

    public static String generateSID() {
        Random random = SrvUtil.getRandom();
        byte[] byArray = new byte[16];
        SrvUtil.getRandom().nextBytes(byArray);
        byArray = SrvUtil.getDigest().digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)((byArray[i] & 0xF0) >> 4);
            byte by2 = (byte)(byArray[i] & 0xF);
            if (by < 10) {
                stringBuffer.append((char)(48 + by));
            } else {
                stringBuffer.append((char)(65 + (by - 10)));
            }
            if (by2 < 10) {
                stringBuffer.append((char)(48 + by2));
                continue;
            }
            stringBuffer.append((char)(65 + (by2 - 10)));
        }
        return stringBuffer.toString();
    }

    private static synchronized MessageDigest getDigest() {
        if (_digest == null) {
            try {
                _digest = MessageDigest.getInstance(_algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LogUtil.logFailure(_sm.getString("managerBase.digest", _algorithm) + "\n" + LogUtil.getStackTrace(noSuchAlgorithmException));
                _digest = null;
            }
        }
        return _digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Random getRandom() {
        if (_random == null) {
            SrvUtil srvUtil = _this;
            synchronized (srvUtil) {
                if (_random == null) {
                    LogUtil.logInfo(_sm.getString("managerBase.seeding", _randomClass));
                    long l = System.currentTimeMillis();
                    char[] cArray = _this.getEntropy().toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        long l2 = (byte)cArray[i] << i % 8 * 8;
                        l ^= l2;
                    }
                    try {
                        Class<?> clazz = Class.forName(_randomClass);
                        _random = (Random)clazz.newInstance();
                        _random.setSeed(l);
                    }
                    catch (Exception exception) {
                        LogUtil.logFailure(_sm.getString("managerBase.random", _randomClass) + "\n" + exception);
                        _random = new Random();
                        _random.setSeed(l);
                    }
                    LogUtil.logInfo(_sm.getString("managerBase.complete", _randomClass));
                }
            }
        }
        return _random;
    }

    private String getEntropy() {
        if (_entropy == null) {
            _entropy = this.toString();
        }
        return _entropy;
    }
}

