/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.Map;
import java.util.Properties;

public class MultiLruCache
extends BaseCache {
    public static final int LRU_HEAD = 0;
    public static final int LRU_TAIL = 1;
    public static final int DEFAULT_HASHTABLE_SEGMENT_SIZE = 4096;
    int segmentSize;
    LruCacheItem[][] lists;
    protected int[] listsLength;
    int trimCount;
    int trimIndex;
    Object trimIndexLk = new Object();

    public void init(int n, Properties properties) throws Exception {
        String string;
        super.init(n, properties);
        this.segmentSize = 4096;
        if (properties != null && (string = properties.getProperty("MultiLRUSegmentSize")) != null) {
            try {
                this.segmentSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n2 = this.maxBuckets / this.segmentSize + (this.maxBuckets % this.segmentSize != 0 ? 1 : 0);
        this.lists = new LruCacheItem[n2][2];
        this.listsLength = new int[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i][0] = null;
            this.lists[i][1] = null;
            this.listsLength[i] = 0;
        }
    }

    private LruCacheItem[] getLRUList(int n) {
        int n2 = n / this.segmentSize;
        return this.lists[n2];
    }

    protected BaseCache.CacheItem createItem(int n, Object object, Object object2, int n2) {
        return new LruCacheItem(n, object, object2, n2);
    }

    protected BaseCache.CacheItem trimLru(int n) {
        LruCacheItem[] lruCacheItemArray = this.lists[n];
        LruCacheItem lruCacheItem = null;
        lruCacheItem = lruCacheItemArray[1];
        lruCacheItemArray[1] = lruCacheItem.lPrev;
        lruCacheItemArray[1].lNext = null;
        lruCacheItem.lPrev = null;
        int n2 = n;
        this.listsLength[n2] = this.listsLength[n2] - 1;
        lruCacheItem.isTrimmed = true;
        ++this.trimCount;
        return lruCacheItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem cacheItem) {
        LruCacheItem[] lruCacheItemArray;
        BaseCache.CacheItem cacheItem2 = null;
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        int n = this.getIndex(cacheItem.hashCode());
        int n2 = n / this.segmentSize;
        LruCacheItem[] lruCacheItemArray2 = lruCacheItemArray = this.lists[n2];
        synchronized (lruCacheItemArray) {
            if (lruCacheItemArray[0] != null) {
                lruCacheItemArray[0].lPrev = lruCacheItem;
                lruCacheItem.lNext = lruCacheItemArray[0];
            } else {
                lruCacheItemArray[1] = lruCacheItem;
            }
            lruCacheItemArray[0] = lruCacheItem;
            int n3 = n2;
            this.listsLength[n3] = this.listsLength[n3] + 1;
            if (this.isThresholdReached()) {
                cacheItem2 = this.trimLru(this.trimIndex);
                this.incrementTrimIndex();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return cacheItem2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
        int n = this.getIndex(cacheItem.hashCode());
        int n2 = n / this.segmentSize;
        LruCacheItem[] lruCacheItemArray = this.lists[n2];
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        LruCacheItem[] lruCacheItemArray2 = lruCacheItemArray;
        synchronized (lruCacheItemArray) {
            LruCacheItem lruCacheItem2 = lruCacheItem.lPrev;
            LruCacheItem lruCacheItem3 = lruCacheItem.lNext;
            if (lruCacheItem2 != null) {
                lruCacheItem.lPrev = null;
                lruCacheItem.lNext = lruCacheItemArray[0];
                lruCacheItemArray[0].lPrev = lruCacheItem;
                lruCacheItemArray[0] = lruCacheItem;
                lruCacheItem2.lNext = lruCacheItem3;
                if (lruCacheItem3 != null) {
                    lruCacheItem3.lPrev = lruCacheItem2;
                } else {
                    lruCacheItemArray[1] = lruCacheItem2;
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem cacheItem, int n) {
        this.itemAccessed(cacheItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem cacheItem) {
        LruCacheItem[] lruCacheItemArray;
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        int n = this.getIndex(cacheItem.hashCode());
        int n2 = n / this.segmentSize;
        LruCacheItem[] lruCacheItemArray2 = lruCacheItemArray = this.lists[n2];
        synchronized (lruCacheItemArray) {
            if (lruCacheItem.isTrimmed) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            LruCacheItem lruCacheItem2 = lruCacheItem.lPrev;
            LruCacheItem lruCacheItem3 = lruCacheItem.lNext;
            if (lruCacheItem2 != null) {
                lruCacheItem2.lNext = lruCacheItem3;
            } else {
                lruCacheItemArray[0] = lruCacheItem3;
            }
            if (lruCacheItem3 != null) {
                lruCacheItem3.lPrev = lruCacheItem2;
            } else {
                lruCacheItemArray[1] = lruCacheItem2;
            }
            int n3 = n2;
            this.listsLength[n3] = this.listsLength[n3] - 1;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    protected void handleOverflow() {
        Object var1_1 = null;
    }

    int getListsLength() {
        return this.lists.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementTrimIndex() {
        Object object = this.trimIndexLk;
        synchronized (object) {
            this.trimIndex = (this.trimIndex + 1) % this.lists.length;
        }
    }

    public Object getStatByName(String string) {
        Integer[] integerArray = super.getStatByName(string);
        if (integerArray == null && string != null) {
            if (string.equals("cache.MultiLruCache.stat_segmentSize")) {
                integerArray = new Integer(this.segmentSize);
            } else if (string.equals("cache.MultiLruCache.stat_trimCount")) {
                integerArray = new Integer(this.trimCount);
            } else if (string.equals("cache.MultiLruCache.stat_segmentListLength")) {
                integerArray = new Integer[this.lists.length];
                for (int i = 0; i < this.lists.length; ++i) {
                    integerArray[i] = new Integer(this.listsLength[i]);
                }
            }
        }
        return integerArray;
    }

    public Map getStats() {
        Map map = super.getStats();
        map.put("cache.MultiLruCache.stat_segmentSize", new Integer(this.segmentSize));
        for (int i = 0; i < this.lists.length; ++i) {
            map.put("cache.MultiLruCache.stat_segmentListLength[" + i + "]:", new Integer(this.listsLength[i]));
        }
        map.put("cache.MultiLruCache.stat_trimCount", new Integer(this.trimCount));
        return map;
    }

    static class LruCacheItem
    extends BaseCache.CacheItem {
        LruCacheItem lNext;
        LruCacheItem lPrev;
        boolean isTrimmed;

        LruCacheItem(int n, Object object, Object object2, int n2) {
            super(n, object, object2, n2);
        }
    }
}

