/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.DefaultCacheHelper;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;

public class CacheManager {
    public static final String CACHE_MANAGER_ATTR_NAME = "com.sun.appserv.web.CacheManager";
    public static final int DEFAULT_CACHE_MAX_ENTRIES = 4096;
    public static final int DEFAULT_CACHE_TIMEOUT = 30;
    public static final String DEFAULT_CACHE_CLASSNAME = "com.sun.appserv.util.cache.LruCache";
    private static Logger _logger;
    private static ResourceBundle _rb;
    int maxEntries = 4096;
    int defaultTimeout = 30;
    String cacheClassName = "com.sun.appserv.util.cache.LruCache";
    boolean enabled = false;
    ServletContext context;
    Properties cacheProps;
    Cache defaultCache;
    HashMap cacheMappings = new HashMap();
    Map defaultHelperProps;
    DefaultCacheHelper defaultHelper;
    HashMap helperDefs = new HashMap();
    HashMap cacheHelpers = new HashMap();
    HashMap cacheHelpersByFilterName = new HashMap();
    ArrayList listeners = new ArrayList();

    public void setMaxEntries(int n) {
        this.maxEntries = n;
    }

    public void setDefaultTimeout(int n) {
        this.defaultTimeout = n;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addProperty(String string, String string2) {
        if (string.equalsIgnoreCase("cacheClassName")) {
            this.cacheClassName = string2;
        } else {
            if (this.cacheProps == null) {
                this.cacheProps = new Properties();
            }
            this.cacheProps.setProperty(string, string2);
        }
    }

    public void addCacheHelperDef(String string, HashMap hashMap) {
        this.helperDefs.put(string, hashMap);
    }

    public void setDefaultHelperProps(Map map) {
        this.defaultHelperProps = map;
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    private CacheHelper loadCacheHelper(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        CacheHelper cacheHelper = (CacheHelper)clazz.newInstance();
        return cacheHelper;
    }

    public void start() throws LifecycleException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!this.enabled) {
            return;
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _rb = _logger.getResourceBundle();
        try {
            this.defaultCache = this.createCache(this.maxEntries, this.cacheClassName);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "cache.manager.excep_createCache", exception);
            String string = _rb.getString("cache.manager.excep_createCache");
            throw new LifecycleException(string, exception);
        }
        this.defaultHelper = new DefaultCacheHelper();
        this.defaultHelper.setCacheManager(this);
        this.defaultHelper.init(this.context, this.defaultHelperProps);
        Iterator iterator = this.helperDefs.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = (HashMap)this.helperDefs.get(object4);
            try {
                object2 = (String)((HashMap)object3).get("class-name");
                object = this.loadCacheHelper((String)object2);
                object.init(this.context, (Map)object3);
                this.cacheHelpers.put(object4, object);
            }
            catch (Exception exception) {
                object = _rb.getString("cache.manager.excep_initCacheHelper");
                Object[] objectArray = new Object[]{object4};
                object = MessageFormat.format((String)object, objectArray);
                throw new LifecycleException((String)object, exception);
            }
        }
        object4 = this.cacheMappings.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            object2 = (CacheMapping)this.cacheMappings.get(object3);
            object = ((CacheMapping)object2).getHelperNameRef();
            CacheHelper cacheHelper = object == null || ((String)object).equals("default") ? this.defaultHelper : (CacheHelper)this.cacheHelpers.get(object);
            this.cacheHelpersByFilterName.put(object3, cacheHelper);
        }
    }

    public String getCacheClassName() {
        return this.cacheClassName;
    }

    public Cache createCache() throws Exception {
        return this.createCache(this.maxEntries, DEFAULT_CACHE_CLASSNAME);
    }

    public Cache createCache(int n, String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        Cache cache = (Cache)clazz.newInstance();
        cache.init(this.maxEntries, this.cacheProps);
        return cache;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Cache getDefaultCache() {
        return this.defaultCache;
    }

    public void addCacheMapping(String string, CacheMapping cacheMapping) {
        this.cacheMappings.put(string, cacheMapping);
    }

    public CacheMapping getCacheMapping(String string) {
        return (CacheMapping)this.cacheMappings.get(string);
    }

    public CacheHelper getCacheHelper(String string) {
        return (CacheHelper)this.cacheHelpers.get(string);
    }

    public CacheHelper getCacheHelperByFilterName(String string) {
        return (CacheHelper)this.cacheHelpersByFilterName.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheManagerListener(CacheManagerListener cacheManagerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(cacheManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheManagerListener(CacheManagerListener cacheManagerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(cacheManagerListener);
        }
    }

    public void enable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener cacheManagerListener = (CacheManagerListener)this.listeners.get(i);
            cacheManagerListener.cacheManagerEnabled();
        }
    }

    public void disable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener cacheManagerListener = (CacheManagerListener)this.listeners.get(i);
            cacheManagerListener.cacheManagerDisabled();
        }
    }

    public void stop() throws LifecycleException {
        this.disable();
        try {
            this.defaultHelper.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration enumeration = Collections.enumeration(this.cacheHelpers.values());
        while (enumeration.hasMoreElements()) {
            CacheHelper cacheHelper = (CacheHelper)enumeration.nextElement();
            try {
                cacheHelper.destroy();
            }
            catch (Exception exception) {}
        }
        this.cacheHelpers.clear();
        this.cacheMappings.clear();
        this.cacheHelpersByFilterName.clear();
        this.listeners.clear();
    }

    static {
        _rb = null;
    }
}

