/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.validation.ConnectionValidator;
import com.sun.enterprise.resource.validation.ConnectionValidatorByAutoCommit;
import com.sun.enterprise.resource.validation.ConnectionValidatorByMetaData;
import com.sun.enterprise.resource.validation.ConnectionValidatorByUserTable;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASNonSharedResourcePool
implements ResourcePool {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    private final boolean debug = false;
    static boolean _fineLevel = _logger.isLoggable(Level.FINE);
    static boolean _logFinest = _logger.isLoggable(Level.FINEST);
    private Hashtable resourceStates;
    private Set free;
    private long idletime;
    private String name;
    private String jdbcConnectionPoolResourceName;
    private ResourceSpec resourceSpec;
    private ResourceAllocator allocator;
    private int maxPoolSize;
    private int steadyPoolSize;
    private int resizeQuantity;
    private int maxWaitTime;
    private ConnectionValidator validator = null;
    private boolean requireConnectionValidation = false;
    private boolean failAllConnections = false;
    private String validationType = null;
    private String userTable = null;
    private boolean poolInitialized = false;
    private TimerTask resizerTask;
    private int numConnFailedValidation = 0;
    private int numConnTimedOut = 0;
    static final String READ_UNCOMMITTED = "read-uncommitted";
    static final String READ_COMMITTED = "read-committed";
    static final String REPEATABLE_READ = "repeatable-read";
    static final String SERIALIZABLE = "serializable";
    boolean _isGuaranteedIsolationLevel = true;
    boolean _isDefaulIsolationLevel = true;
    int _isolationLevel;
    private LinkedList waitQueue = new LinkedList();
    private static final Timer timer = new Timer();

    public IASNonSharedResourcePool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.willcreate", resourceSpec.getJDBCConnectionPoolResourceName());
        }
        this.resourceSpec = resourceSpec;
        this.allocator = resourceAllocator;
        this.name = resourceSpec.toString();
        this.jdbcConnectionPoolResourceName = resourceSpec.getJDBCConnectionPoolResourceName();
        this.setConfigurationParameters();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.hascreated", resourceSpec.getJDBCConnectionPoolResourceName());
        }
    }

    private void setConfigurationParameters() throws PoolingException {
        String string;
        JdbcConnectionPool jdbcConnectionPool = ApplicationServer.getServerContext().getResourceManager().getJDBCConnectionPoolResource(this.jdbcConnectionPoolResourceName);
        this.idletime = Integer.parseInt(jdbcConnectionPool.getIdleTimeoutInSeconds()) * 1000;
        this.maxPoolSize = Integer.parseInt(jdbcConnectionPool.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(jdbcConnectionPool.getSteadyPoolSize());
        this.resizeQuantity = Integer.parseInt(jdbcConnectionPool.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(jdbcConnectionPool.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        if ((string = jdbcConnectionPool.getTransactionIsolationLevel()) == null || string.length() < 1) {
            this._isDefaulIsolationLevel = true;
            this._isGuaranteedIsolationLevel = true;
        } else {
            this._isDefaulIsolationLevel = false;
            this._isGuaranteedIsolationLevel = jdbcConnectionPool.isIsolationLevelGuaranteed();
            if (string.equals(READ_COMMITTED)) {
                this._isolationLevel = 2;
            } else if (string.equals(READ_UNCOMMITTED)) {
                this._isolationLevel = 1;
            } else if (string.equals(REPEATABLE_READ)) {
                this._isolationLevel = 4;
            } else if (string.equals(SERIALIZABLE)) {
                this._isolationLevel = 8;
            } else {
                this._isDefaulIsolationLevel = true;
                this._isGuaranteedIsolationLevel = true;
                _logger.log(Level.WARNING, "resource.pool.isolation_level_unknown", new Integer(string));
            }
        }
        this.requireConnectionValidation = jdbcConnectionPool.isIsConnectionValidationRequired();
        if (this.requireConnectionValidation) {
            this.failAllConnections = jdbcConnectionPool.isFailAllConnections();
            this.validationType = jdbcConnectionPool.getConnectionValidationMethod();
            if (this.validationType != null && this.requireConnectionValidation) {
                if (this.validationType.equals("auto-commit")) {
                    this.validator = new ConnectionValidatorByAutoCommit();
                } else if (this.validationType.equals("meta-data")) {
                    this.validator = new ConnectionValidatorByMetaData();
                } else if (this.validationType.equals("table")) {
                    this.userTable = jdbcConnectionPool.getValidationTableName();
                    if (this.userTable == null || this.userTable.length() <= 0) {
                        _logger.log(Level.WARNING, "resource.pool.null_validation_table_name");
                        _logger.log(Level.WARNING, "resource.pool.validation_set_false");
                        this.requireConnectionValidation = false;
                    } else {
                        this.validator = new ConnectionValidatorByUserTable(this.userTable);
                    }
                } else {
                    _logger.log(Level.WARNING, "resource.pool.invalid_validation_type", this.validationType);
                    _logger.log(Level.WARNING, "resource.pool.validation_set_false");
                    this.requireConnectionValidation = false;
                }
            }
        }
        if (jdbcConnectionPool.isPerfMonitor()) {
            int n = 1000 * jdbcConnectionPool.getPerfMonitorInterval();
            StatDumpTask statDumpTask = new StatDumpTask();
            timer.scheduleAtFixedRate((TimerTask)statDumpTask, n, (long)n);
        }
    }

    private synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.initializing", resourceSpec.getJDBCConnectionPoolResourceName());
        }
        this.resourceStates = new Hashtable(this.steadyPoolSize);
        this.free = new HashSet(this.steadyPoolSize);
        this.createSteadyResources();
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        this.poolInitialized = true;
        if (_logger.isLoggable(Level.FINE)) {
            int n = this.free == null ? 0 : this.free.size();
            Object[] objectArray = new Object[]{resourceSpec.getJDBCConnectionPoolResourceName(), n + ""};
            _logger.log(Level.FINE, "resource.pool.initialized", objectArray);
        }
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        } else {
            this.resizerTask = new Resizer();
        }
        if (_logger.isLoggable(Level.FINE)) {
            Object[] objectArray = new Object[]{this.resourceSpec.getJDBCConnectionPoolResourceName(), this.idletime + ""};
            _logger.log(Level.FINE, "resource.pool.scheduling_resizer", objectArray);
        }
        timer.scheduleAtFixedRate(this.resizerTask, this.idletime, this.idletime);
    }

    private boolean isValid(ResourceHandle resourceHandle) {
        return this.validator.isValid(resourceHandle);
    }

    public synchronized void addResource(ResourceSpec resourceSpec, ResourceHandle resourceHandle) {
        ResourceState resourceState = new ResourceState();
        this.resourceStates.put(resourceHandle, resourceState);
        resourceState.setBusy(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.addedresource", this.resourceSpec.getJDBCConnectionPoolResourceName());
        }
        if (_logFinest) {
            _logger.log(Level.FINEST, "resource.pool.resource", resourceHandle);
            _logger.log(Level.FINEST, "resource.pool.total_resources", this.resourceStates.size() + "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ResourceHandle getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.getresource", this.resourceSpec.getJDBCConnectionPoolResourceName());
        }
        ResourceHandle resourceHandle = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Object[] objectArray = new Object();
        if (this.maxWaitTime > 0) {
            l = System.currentTimeMillis();
        }
        while ((resourceHandle = this.internalGetResource(resourceSpec, resourceAllocator)) == null) {
            Object object;
            Object[] objectArray2;
            if (this.maxWaitTime > 0) {
                l2 = System.currentTimeMillis() - l;
                if (l2 >= (long)this.maxWaitTime) {
                    ++this.numConnTimedOut;
                    objectArray2 = new Object[]{resourceSpec.getJDBCConnectionPoolResourceName()};
                    object = Utility.getLocalizedString(_logger, "resource.pool.no_available_resource", objectArray2);
                    throw new PoolingException((String)object);
                }
                l3 = (long)this.maxWaitTime - l2;
            }
            objectArray2 = objectArray;
            // MONITORENTER : objectArray
            object = this.waitQueue;
            // MONITORENTER : object
            this.waitQueue.addLast(objectArray);
            // MONITOREXIT : object
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "resource.pool.waitqueue", resourceSpec.getJDBCConnectionPoolResourceName());
                    _logger.log(Level.FINEST, "resource.pool.waitqueue_size", this.waitQueue.size() + "");
                }
                objectArray.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                // MONITOREXIT : objectArray2
                return resourceHandle;
            }
            this.waitQueue.remove(objectArray);
            // MONITOREXIT : objectArray2
        }
        return resourceHandle;
    }

    private synchronized ResourceHandle internalGetResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        Object object;
        this.initPool(resourceSpec, resourceAllocator);
        Object object2 = null;
        Iterator iterator = this.free.iterator();
        while (iterator.hasNext()) {
            object = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState((ResourceHandle)object);
            if (!resourceAllocator.matchConnection((ResourceHandle)object)) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            object = this.getResourceState((ResourceHandle)object2);
            ((ResourceState)object).setBusy(true);
            this.free.remove(object2);
            if (_logFinest) {
                _logger.log(Level.FINEST, "resource.pool.match_found", this.resourceSpec.getJDBCConnectionPoolResourceName());
            }
            if (this.requireConnectionValidation) {
                int n = this.resourceStates.size();
                boolean bl = false;
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "resource.pool.validating_resource", this.resourceSpec.getJDBCConnectionPoolResourceName());
                    }
                    resourceAllocator.fillInResourceObjects((ResourceHandle)object2);
                    bl = this.isValid((ResourceHandle)object2);
                }
                catch (PoolingException poolingException) {
                    Object[] objectArray = new Object[]{resourceSpec.getJDBCConnectionPoolResourceName()};
                    String string = Utility.getLocalizedString(_logger, "resource.pool.exception_while_validating", objectArray);
                    _logger.log(Level.WARNING, string, poolingException);
                    bl = false;
                }
                if (!bl) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "resource.pool.failed_validation", this.resourceSpec.getJDBCConnectionPoolResourceName());
                    }
                    if (this.failAllConnections) {
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.log(Level.INFO, "resource.pool.validation_failed_all", this.resourceSpec.getJDBCConnectionPoolResourceName());
                        }
                        this.numConnFailedValidation += n;
                        object2 = this.failAllConnections(resourceAllocator);
                    } else {
                        this.resourceStates.remove(object2);
                        this.destroyResource((ResourceHandle)object2);
                        ++this.numConnFailedValidation;
                        object2 = null;
                    }
                }
            } else {
                resourceAllocator.fillInResourceObjects((ResourceHandle)object2);
            }
        }
        if (object2 == null && this.resourceStates.size() < this.maxPoolSize) {
            object2 = resourceAllocator.createResource();
            this.addResource(resourceSpec, (ResourceHandle)object2);
            resourceAllocator.fillInResourceObjects((ResourceHandle)object2);
        }
        if (!this._isDefaulIsolationLevel && object2 != null) {
            object = (ResourceState)this.resourceStates.get(object2);
            if (((ResourceState)object).isNew()) {
                this.setTransactionIsolationLevel((ResourceHandle)object2);
                ((ResourceState)object).setNotNew();
            } else if (this._isGuaranteedIsolationLevel) {
                this.setTransactionIsolationLevel((ResourceHandle)object2);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.got_resource", this.resourceSpec.getJDBCConnectionPoolResourceName());
        }
        if (_logFinest) {
            _logger.log(Level.FINEST, "resource.pool.resource", object2);
            _logger.log(Level.FINEST, "resource.pool.pool_stats", this.toString());
        }
        return object2;
    }

    private void setTransactionIsolationLevel(ResourceHandle resourceHandle) throws PoolingException {
        Connection connection = (Connection)resourceHandle.getUserConnection();
        if (connection == null) {
            connection = (Connection)resourceHandle.getResource();
        }
        try {
            connection.setTransactionIsolation(this._isolationLevel);
            if (_logFinest) {
                Object[] objectArray = new Object[]{this._isolationLevel + "", this.resourceSpec.getJDBCConnectionPoolResourceName()};
                _logger.log(Level.FINEST, "resource.pool.set_transaction_isolation", objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    private ResourceHandle failAllConnections(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle resourceHandle = null;
        this.emptyPool();
        this.createSteadyResources();
        if (resourceAllocator.equals(this.allocator) && this.free.size() > 0) {
            Iterator iterator = this.free.iterator();
            resourceHandle = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState(resourceHandle);
            resourceState.setBusy(true);
            this.free.remove(resourceHandle);
            this.allocator.fillInResourceObjects(resourceHandle);
        }
        return resourceHandle;
    }

    private synchronized void createSteadyResources() throws PoolingException {
        ResourceHandle resourceHandle = null;
        for (int i = 0; i < this.steadyPoolSize; ++i) {
            resourceHandle = this.allocator.createResource();
            this.addResource(this.resourceSpec, resourceHandle);
            this.getResourceState(resourceHandle).setBusy(false);
            this.free.add(resourceHandle);
        }
    }

    private void destroyResource(ResourceHandle resourceHandle) {
        block2: {
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "resource.pool.destroy_resource_failed", this.resourceSpec.getJDBCConnectionPoolResourceName());
                _logger.log(Level.FINEST, "resource.pool.destroy_resource_failed", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resourceClosed(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.resource_closed", this.resourceSpec.getJDBCConnectionPoolResourceName());
        }
        if ((resourceState = this.getResourceState(resourceHandle)) == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        resourceState.setBusy(false);
        resourceState.touchTimestamp();
        this.free.add(resourceHandle);
        Object object = null;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                object = this.waitQueue.removeFirst();
            }
        }
        if (object != null) {
            linkedList = object;
            synchronized (linkedList) {
                object.notify();
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "resource.pool.resource", resourceHandle);
            _logger.log(Level.FINEST, "resource.pool.total_resources", this.resourceStates.size() + "");
        }
    }

    public synchronized void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.resource_error_ocurred", this.resourceSpec.getJDBCConnectionPoolResourceName());
            _logger.log(Level.FINEST, "resource.pool.resource", resourceHandle);
        }
        if ((resourceState = this.getResourceState(resourceHandle)) == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        this.resourceStates.remove(resourceHandle);
        this.destroyResource(resourceHandle);
    }

    public int getNumThreadWaiting() {
        return this.waitQueue.size();
    }

    public int getNumConnFailedValidation() {
        return this.numConnFailedValidation;
    }

    public int getNumConnTimedOut() {
        return this.numConnTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resizePool(boolean bl) {
        Object[] objectArray;
        int n = 0;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                return;
            }
        }
        int n2 = this.resourceStates.size() - this.steadyPoolSize;
        if (n2 > 0) {
            int n3 = this.resizeQuantity < n2 ? this.resizeQuantity : n2;
            objectArray = this.free.iterator();
            long l = System.currentTimeMillis();
            while (n3 > 0 && objectArray.hasNext()) {
                ResourceHandle resourceHandle = (ResourceHandle)objectArray.next();
                ResourceState resourceState = this.getResourceState(resourceHandle);
                if (!bl && l - resourceState.getTimestamp() <= this.idletime) continue;
                this.resourceStates.remove(resourceHandle);
                this.destroyResource(resourceHandle);
                objectArray.remove();
                --n3;
                if (!_fineLevel) continue;
                ++n;
            }
        }
        if (this.resourceStates.size() < this.steadyPoolSize) {
            ResourceHandle resourceHandle = null;
            for (int i = this.resourceStates.size(); i < this.steadyPoolSize; ++i) {
                try {
                    resourceHandle = this.allocator.createResource();
                }
                catch (PoolingException poolingException) {
                    objectArray = new Object[]{this.resourceSpec.getJDBCConnectionPoolResourceName()};
                    String string = Utility.getLocalizedString(_logger, "resource.pool.resize_pool_error", objectArray);
                    _logger.log(Level.WARNING, string, poolingException);
                }
                this.addResource(this.resourceSpec, resourceHandle);
                this.getResourceState(resourceHandle).setBusy(false);
                this.free.add(resourceHandle);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            Object[] objectArray2 = new Object[]{this.resourceSpec.getJDBCConnectionPoolResourceName(), n + "", this.resourceStates.size() + ""};
            _logger.log(Level.FINE, "resource.pool.resized", objectArray2);
        }
    }

    private ResourceState getResourceState(ResourceHandle resourceHandle) {
        return (ResourceState)this.resourceStates.get(resourceHandle);
    }

    public synchronized void emptyPool() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "resource.pool.emptied", this.resourceSpec.getJDBCConnectionPoolResourceName());
        }
        Enumeration enumeration = this.resourceStates.keys();
        while (enumeration.hasMoreElements()) {
            ResourceHandle resourceHandle = (ResourceHandle)enumeration.nextElement();
            this.destroyResource(resourceHandle);
        }
        this.free.clear();
        this.resourceStates.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Pool [");
        stringBuffer.append(this.name);
        stringBuffer.append("] PoolSize=");
        stringBuffer.append(this.resourceStates.size());
        stringBuffer.append("  FreeResources=");
        stringBuffer.append(this.free.size());
        stringBuffer.append("  QueueSize=");
        stringBuffer.append(this.waitQueue.size());
        return stringBuffer.toString();
    }

    private void dumpStats() {
        System.out.println(this);
    }

    class StatDumpTask
    extends TimerTask {
        StatDumpTask() {
        }

        public void run() {
            IASNonSharedResourcePool.this.dumpStats();
        }
    }

    public static class ResourceState {
        private boolean busy;
        private long timestamp;
        private boolean isNew = true;

        public boolean isFree() {
            return !this.busy;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean bl) {
            this.busy = bl;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public ResourceState() {
            this.touchTimestamp();
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNotNew() {
            this.isNew = false;
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "resource.pool.resizing" + IASNonSharedResourcePool.this.resourceSpec.getJDBCConnectionPoolResourceName());
            }
            IASNonSharedResourcePool.this.resizePool(false);
        }
    }
}

