/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.logging.LogDomains;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdbcConnection
implements Connection {
    private boolean closed = false;
    private Connection localCon;
    private ResourceHandle resource;
    private PoolManager poolMgr;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _isFineLevel = _logger.isLoggable(Level.FINE);
    static boolean _isFinestLevel = _logger.isLoggable(Level.FINEST);

    public JdbcConnection(ResourceHandle resourceHandle, PoolManager poolManager) throws PoolingException {
        this.resource = resourceHandle;
        this.poolMgr = poolManager;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.createStatement(n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareCall(string, n, n2, n3);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.releaseSavepoint(savepoint);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string, stringArray);
    }

    public Statement createStatement() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.commit();
    }

    public void rollback() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.rollback();
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.localCon = null;
        Connection connection = (Connection)this.resource.getResource();
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        } else {
            if (_isFineLevel) {
                _logger.log(Level.FINE, "resource.connection.rollback", this.resource.getResourceSpec().getJDBCConnectionPoolResourceName());
            }
            connection.rollback();
        }
        this.poolMgr.putbackResourceToPool(this.resource, false);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.isReadOnly();
    }

    public void setHoldability(int n) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setHoldability(n);
    }

    public int getHoldability() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getHoldability();
    }

    public void setCatalog(String string) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.clearWarnings();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        connection.setTypeMap(map);
    }

    public Map getTypeMap() throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.getTypeMap();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareStatement(string, n, n2);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.createStatement(n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.errorIfClosed();
        Connection connection = this.getCurrentConnection();
        return connection.prepareCall(string, n, n2);
    }

    void setClosed() {
        this.closed = true;
    }

    private void errorIfClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
    }

    private Connection getCurrentConnection() throws SQLException {
        Connection connection;
        if (this.localCon == null && !(connection = (Connection)this.resource.getResource()).getAutoCommit()) {
            connection.rollback();
            connection.setAutoCommit(true);
            this.localCon = connection;
        }
        return this.localCon;
    }
}

