/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoolManagerImpl
implements PoolManager {
    private static final boolean debug = false;
    private static final long DEFAULT_SLEEPTIME = 10L;
    private static Integer m_lock = new Integer(0);
    private static PoolManager poolManager;
    private Hashtable poolTable = new Hashtable();
    static Logger _logger;
    static boolean _isFineLevel;

    public Object getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo) throws PoolingException {
        ResourceHandle resourceHandle = this.getResourceFromPool(resourceSpec, resourceAllocator, clientSecurityInfo);
        return (Connection)resourceHandle.getUserConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResourceFromPool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo) throws PoolingException {
        ResourcePool resourcePool = null;
        Object object = this.poolTable;
        synchronized (object) {
            resourcePool = (ResourcePool)this.poolTable.get(resourceSpec);
            if (resourcePool == null) {
                resourcePool = new IASNonSharedResourcePool(resourceSpec, resourceAllocator);
                this.poolTable.put(resourceSpec, resourcePool);
            }
        }
        object = resourcePool.getResource(resourceSpec, resourceAllocator);
        return object;
    }

    public void resourceClosed(ResourceHandle resourceHandle) {
        this.putbackResourceToPool(resourceHandle, false);
    }

    public void resourceErrorOccurred(ResourceHandle resourceHandle) {
        this.putbackResourceToPool(resourceHandle, true);
    }

    public void putbackResourceToPool(ResourceHandle resourceHandle, boolean bl) {
        Object object;
        try {
            object = resourceHandle.getResourceAllocator();
            object.cleanup(resourceHandle);
        }
        catch (PoolingException poolingException) {
            _logger.log(Level.WARNING, "resource.poolmgr.resource_return_error", poolingException);
            bl = true;
        }
        object = (ResourcePool)this.poolTable.get(resourceHandle.getResourceSpec());
        if (object != null) {
            if (bl) {
                object.resourceErrorOccurred(resourceHandle);
            } else {
                object.resourceClosed(resourceHandle);
            }
        }
    }

    public void emptyResourcePool(ResourceSpec resourceSpec) {
        ResourcePool resourcePool = (ResourcePool)this.poolTable.get(resourceSpec);
        if (resourcePool != null) {
            resourcePool.emptyPool();
        }
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Exception exception = new Exception();
            _logger.log(Level.WARNING, "resource.poolmgr.assert_exception", exception);
        }
    }

    public void resizeAllPools(boolean bl) {
        if (_isFineLevel) {
            _logger.log(Level.FINE, "resource.poolmgr.resize_all");
        }
        Hashtable hashtable = (Hashtable)this.poolTable.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ResourcePool)enumeration.nextElement()).resizePool(bl);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "resource.poolmgr.pool_resize_error", exception);
            }
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource");
        _isFineLevel = _logger.isLoggable(Level.FINE);
    }
}

