/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.admin;

import com.sun.web.search.admin.Options;

abstract class CommandParser {
    protected static final int INSTANCEID = 0;
    protected static final int VSID = 1;
    protected static final int COLLNAME = 2;
    protected static final int DESCRIPTION = 3;
    protected static final int DISPNAME = 4;
    protected static final int DIRECTORY = 5;
    protected static final int DOCURI = 6;
    protected static final int RECURSIVE = 8;
    protected static final int PATTERN = 9;
    protected static final int ENCODING = 10;
    protected static final int ENABLED = 12;
    protected static final int INDEXPATH = 13;
    private static final Object[][] _action_map = new Object[][]{{"createcoll", new Integer(1)}, {"configcoll", new Integer(2)}, {"adddocs", new Integer(3)}, {"removecoll", new Integer(5)}, {"optimizecoll", new Integer(6)}, {"reindexcoll", new Integer(7)}, {"removedocs", new Integer(4)}};
    protected int _action = Options.NONE;
    protected Options _options = null;

    CommandParser() {
    }

    protected void getAction(String string) throws ParserErrorException {
        this._action = this.checkAction(string);
        if (this._action == -1) {
            System.err.println("Invalid action.");
            throw new ParserErrorException("Invalid action.");
        }
    }

    private int checkAction(String string) {
        for (int i = 0; i < _action_map.length; ++i) {
            if (!string.equals((String)_action_map[i][0])) continue;
            return (Integer)_action_map[i][1];
        }
        return -1;
    }

    protected void setValue(int n, String string) {
        switch (n) {
            case 0: {
                this._options.setInstanceId(string);
                break;
            }
            case 1: {
                this._options.setVsId(string);
                break;
            }
            case 2: {
                this._options.setCollectionName(string);
                break;
            }
            case 3: {
                this._options.setDescription(string);
                break;
            }
            case 4: {
                this._options.setDisplayName(string);
                break;
            }
            case 5: {
                this._options.setDirectory(string);
                break;
            }
            case 6: {
                this._options.setDocUri(string);
                break;
            }
            case 13: {
                this._options.setIndexPath(string);
                break;
            }
            case 8: {
                this._options.setRecursive(string);
                break;
            }
            case 12: {
                this._options.setEnabled(string);
                break;
            }
            case 9: {
                this._options.setPattern(string);
                break;
            }
            case 10: {
                this._options.setEncoding(string);
            }
        }
    }

    protected boolean isInputComplete() {
        if (this._options == null) {
            return false;
        }
        if (this._options.getInstanceId() == null || this._options.getVsId() == null) {
            return false;
        }
        if (this._options.getCollectionName() == null) {
            return false;
        }
        switch (this._action) {
            case 1: {
                if (this._options.getDirectory() != null && this._options.getDocUri() != null) break;
                return false;
            }
            case 2: {
                if (this._options.getDocUri() != null || this._options.getDisplayName() != null || this._options.getDescription() != null || this._options.getEnabled() != null) break;
                return false;
            }
            case 3: {
                if (this._options.getPattern() != null) break;
                return false;
            }
            case 4: {
                if (this._options.getPattern() != null) break;
                return false;
            }
        }
        return true;
    }

    public abstract Options parse(String[] var1) throws CannotHandleException, ParserErrorException;

    class ParserErrorException
    extends Exception {
        ParserErrorException(String string) {
            super(string);
        }

        ParserErrorException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    class CannotHandleException
    extends Exception {
        CannotHandleException(String string) {
            super(string);
        }

        CannotHandleException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

