/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.web.search.index.FileSource;
import com.sun.web.search.index.IndexingLog;
import java.io.File;
import java.util.ArrayList;

public class DirectoryWalker {
    private FileSource fileSource = null;
    private ArrayList files = new ArrayList();
    private int count = 0;
    private int current = 0;
    private static String SLASH = "/";

    public DirectoryWalker(String string) {
        this(string, true, null);
    }

    public DirectoryWalker(String string, boolean bl) {
        this(string, bl, null);
    }

    public DirectoryWalker(String string, boolean bl, FileSource fileSource) {
        this.fileSource = fileSource;
        File file = new File(string);
        if (!file.canRead()) {
            IndexingLog.log("Docroot '" + string + "' does not have any read permissions.\nHence cannot index any files.");
        } else if (file.isFile()) {
            this.files.add(string);
            ++this.count;
        } else {
            this.addFiles(string, bl);
        }
    }

    private boolean canAdd(String string) {
        File file = new File(string);
        if (!file.isDirectory() && this.fileSource != null && !this.fileSource.checkFilter(string)) {
            return false;
        }
        if (!file.canRead()) {
            IndexingLog.log("Skipping since no read permissions : '" + string + "'");
            return false;
        }
        return true;
    }

    private void addFiles(String string, boolean bl) {
        try {
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) {
                return;
            }
            int n = stringArray.length;
            File file2 = null;
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                string2 = string + SLASH + stringArray[i];
                if (!this.canAdd(string2)) continue;
                file2 = new File(string2);
                if (file2.isFile()) {
                    this.files.add(string2);
                    ++this.count;
                    continue;
                }
                if (!file2.isDirectory() || !bl) continue;
                this.addFiles(string2, bl);
            }
        }
        catch (Exception exception) {
            IndexingLog.log(exception.getMessage(), exception);
        }
    }

    public String getNextFile() {
        if (this.current == this.count) {
            return null;
        }
        return (String)this.files.get(this.current++);
    }

    public int getCount() {
        return this.count;
    }

    public String[] getFiles() {
        String[] stringArray = new String[this.files.size()];
        return this.files.toArray(stringArray);
    }

    public static void main(String[] stringArray) {
        String string;
        DirectoryWalker directoryWalker = new DirectoryWalker(stringArray[0]);
        System.out.println("listing " + directoryWalker.getCount() + "files.");
        while (null != (string = directoryWalker.getNextFile())) {
            System.out.println(string);
        }
    }
}

