/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.retrieval;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.logging.LogDomains;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.retrieval.KtSearchEngine;
import com.sun.web.search.retrieval.Result;
import com.sun.web.search.retrieval.ResultSet;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.util.CollectionConfig;
import com.sun.web.search.util.SearchConfig;
import com.sun.web.search.util.VSNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchBean {
    private static Logger _logger;
    private static boolean _debugLog;
    private static ResourceBundle _rb;
    private KtSearchEngine _engine = null;
    private SearchConfig config = null;
    private CollectionConfig collectionconfig = null;
    private String vsid = null;
    private int maxHits = -1;
    private ResultSet resultSet = null;

    public SearchBean(String string) throws SearchException {
        if (string == null) {
            throw new SearchException("Virtual server id should not be null.");
        }
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.core.search");
            _rb = _logger.getResourceBundle();
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        this.vsid = string;
        this.init();
    }

    private SearchBean(SearchConfig searchConfig) {
        this.config = searchConfig;
        this.collectionconfig = searchConfig.getCollectionConfig();
        this._engine = new KtSearchEngine(searchConfig);
    }

    public ResultSet search(String string, String string2, String[] stringArray) throws SearchException, IndexException {
        String string3 = null;
        if (this.maxHits != -1) {
            this._engine.setMaxHits(this.maxHits);
        }
        if (stringArray == null) {
            stringArray = this.getCollectionNames(null);
        }
        if (_debugLog) {
            string3 = "Executing search in collection(s) ";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                string3 = string3 + stringArray[i];
                if (i == n - 1) continue;
                string3 = string3 + ", ";
            }
            string3 = string3 + ".";
            _logger.log(Level.FINE, string3);
            string3 = "query = " + string + " sort = " + string2 + ".";
            _logger.log(Level.FINE, string3);
        }
        long l = 0L;
        if (_debugLog) {
            l = System.currentTimeMillis();
        }
        this.resultSet = this._engine.search(string, string2, stringArray);
        if (_debugLog) {
            long l2 = System.currentTimeMillis() - l;
            string3 = "Search took " + l2 + "ms and returned ";
            string3 = string3 + (this.resultSet != null ? this.resultSet.size() : 0) + " results.";
            _logger.log(Level.FINE, string3);
        }
        return this.resultSet;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int n) {
        this.maxHits = n;
    }

    public void init() throws SearchException {
        String string = ApplicationServer.getServerContext().getServerConfigURL();
        try {
            this.config = new SearchConfig(string, this.vsid, true);
            this.collectionconfig = new CollectionConfig(this.config, this.vsid);
        }
        catch (ConfigException configException) {
            throw new SearchException(configException.getMessage());
        }
        catch (VSNotFoundException vSNotFoundException) {
            throw new SearchException(vSNotFoundException.getMessage());
        }
        this._engine = new KtSearchEngine(this.config);
    }

    public String[] getCollectionNames(String string) throws SearchException {
        Map map = this.getCollections(null);
        int n = map.size();
        Iterator iterator = map.keySet().iterator();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public Map getCollections(String string) {
        return this.collectionconfig.getEnabledCollections();
    }

    private void setSearchConfig(SearchConfig searchConfig) {
        this.config = searchConfig;
    }

    public static void main(String[] stringArray) throws SearchException, IndexException, ConfigException, VSNotFoundException {
        if (stringArray.length != 4) {
            System.out.println("java com.sun.web.search.SearchBean <server_xml_path> <vsid> <collection> <query>");
            return;
        }
        SearchConfig searchConfig = new SearchConfig(stringArray[0], stringArray[1], true);
        SearchBean searchBean = new SearchBean(searchConfig);
        char[] cArray = new char[]{'\u4f4e', '\u6d88', '\u8cbb', '\u96fb'};
        ResultSet resultSet = searchBean.search(new String(cArray), "-score", new String[]{"oneword"});
        if (resultSet == null) {
            System.out.println("no hits");
            return;
        }
        List list = resultSet.getHits(0, resultSet.size());
        int n = list.size();
        System.out.println("There are " + n + " hits.");
        for (int i = 0; i < n; ++i) {
            Result result = (Result)list.get(i);
            System.out.println(result.getScore() + "  " + result.getPath() + "   " + result.getFieldValue("collection") + "  " + result.getDate() + " " + result.getSize());
        }
    }

    static {
        _rb = null;
    }
}

