/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.taglibs;

import com.sun.web.search.retrieval.ResultSet;
import com.sun.web.search.retrieval.SearchBean;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.taglibs.SearchTagBase;
import com.sun.web.search.taglibs.util.Constants;
import com.sun.web.search.util.CollectionInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class SearchTag
extends SearchTagBase {
    private Constants defValues = Constants.getInstance();
    private static final String ATTR_VSID = "com.sun.web.vsid";
    private String elemColl;
    private String collGroup;
    private String collName;
    private String[] collArray;
    private String elemQuery;
    private String query;
    private String elemSort;
    private String sort;
    private String vsid = null;
    private SearchBean bean;
    private Map colls;
    private List results;

    protected void initForm() throws JspException {
        this.vsid = (String)this.pageContext.getServletContext().getAttribute(ATTR_VSID);
        if (this.vsid == null) {
            throw new JspException("Missing vsid in context attributes.");
        }
        this.initBeanCollInfo();
        super.initForm();
    }

    private void initBeanCollInfo() throws JspException {
        this.bean = (SearchBean)this.pageContext.getServletContext().getAttribute("com.sun.web.search.taglibs.searchbean");
        if (this.bean == null) {
            try {
                this.bean = new SearchBean(this.vsid);
            }
            catch (SearchException searchException) {
                throw new JspTagException("Can not get collections. " + searchException.getMessage());
            }
            this.pageContext.getServletContext().setAttribute("com.sun.web.search.taglibs.searchbean", (Object)this.bean);
        }
        this.colls = (Map)this.pageContext.getServletContext().getAttribute("com.sun.web.search.taglibs.coll_info");
        if (null == this.colls || this.colls.isEmpty()) {
            this.colls = this.bean.getCollections(this.collGroup);
            if (null == this.colls || this.colls.isEmpty()) {
                throw new JspTagException("no collection found on the server.");
            }
            this.pageContext.getServletContext().setAttribute("com.sun.web.search.taglibs.coll_info", (Object)this.colls);
        }
    }

    private boolean parseColl() throws JspException {
        if (this.colls == null) {
            return false;
        }
        if (null != this.collName) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(this.collName, ",");
            this.collArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()) != null) {
                if (this.colls.containsKey(string)) {
                    this.collArray[n] = string;
                    ++n;
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                try {
                    string = this.pageContext.getOut();
                    string.print("Collection: " + stringBuffer.toString() + " not found on server.");
                }
                catch (IOException iOException) {
                    throw new JspTagException(iOException.getMessage());
                }
                return false;
            }
        } else if (this.hasForm()) {
            this.collArray = (String[])this.formValues.get(this.elemColl);
        } else {
            Iterator iterator = this.colls.keySet().iterator();
            this.collArray = new String[this.colls.size()];
            int n = 0;
            while (iterator.hasNext()) {
                CollectionInfo collectionInfo = (CollectionInfo)iterator.next();
                if (collectionInfo.getEnabled()) {
                    this.collArray[n] = collectionInfo.getName();
                }
                ++n;
            }
        }
        return true;
    }

    private void getElems() throws JspException {
        if (this.hasForm()) {
            this.elemQuery = (String)this.formValues.get("com.sun.web.search.taglibs.qtName");
            this.elemColl = (String)this.formValues.get("com.sun.web.search.taglibs.collName");
            this.elemSort = (String)this.formValues.get("com.sun.web.search.taglibs.stName");
        }
        if (null == this.elemQuery) {
            this.elemQuery = this.defValues.getDefValue("com.sun.web.search.taglibs.qtName");
        }
        if (null == this.elemColl) {
            this.elemColl = this.defValues.getDefValue("com.sun.web.search.taglibs.collName");
        }
        if (null == this.elemSort) {
            this.elemSort = this.defValues.getDefValue("com.sun.web.search.taglibs.stName");
        }
    }

    private void getSubmitValues() throws JspException {
        this.getElems();
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        if (this.query == null) {
            this.query = this.hasForm() ? (String)this.formValues.get(this.elemQuery) : httpServletRequest.getParameter(this.elemQuery);
        }
        if (this.collName == null && !this.hasForm() && null != httpServletRequest.getParameter(this.elemColl)) {
            this.collName = httpServletRequest.getParameter(this.elemColl);
        }
        if (null == this.sort) {
            this.sort = this.hasForm() ? (String)this.formValues.get(this.elemSort) : httpServletRequest.getParameter(this.elemSort);
            if (null == this.sort) {
                this.sort = this.defValues.getDefValue("com.sun.web.search.taglibs.stValue");
            }
        }
        if (this.sort.equalsIgnoreCase("relevance")) {
            this.sort = "-score";
        }
    }

    public void otherDoStartTagOperations() throws JspException {
        this.initForm();
        this.getSubmitValues();
        ResultSet resultSet = null;
        if (this.query != null && !this.query.equals("") && this.parseColl()) {
            try {
                resultSet = this.bean.search(this.query, this.sort, this.collArray);
            }
            catch (Exception exception) {
                System.out.println("Search exception:");
                exception.printStackTrace();
                this.results = null;
            }
        }
        int n = null == resultSet ? 0 : resultSet.size();
        Integer n2 = new Integer(n);
        if (n != 0) {
            this.pageContext.setAttribute("com.sun.web.search.taglibs.results_" + this.formId, (Object)resultSet, this.translateScope(this.scope));
        }
        this.pageContext.setAttribute("com.sun.web.search.taglibs.count_" + this.formId, (Object)n2, this.translateScope(this.scope));
    }

    public boolean theBodyShouldBeEvaluated() {
        return false;
    }

    public void otherDoEndTagOperations() {
        this.clearProperties();
    }

    protected void clearProperties() {
        this.collGroup = null;
        this.elemColl = null;
        this.collName = null;
        this.collArray = null;
        this.elemQuery = null;
        this.query = null;
        this.elemSort = null;
        this.sort = null;
        this.vsid = null;
        this.bean = null;
        this.colls = null;
    }

    public boolean shouldEvaluateRestOfPageAfterEndTag() {
        return true;
    }

    public int doStartTag() throws JspException {
        this.otherDoStartTagOperations();
        if (this.theBodyShouldBeEvaluated()) {
            return 1;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.otherDoEndTagOperations();
        if (this.shouldEvaluateRestOfPageAfterEndTag()) {
            return 6;
        }
        return 5;
    }

    public String getCollection() {
        return this.collName;
    }

    public void setCollGroup(String string) {
        this.collGroup = string;
    }

    public void setCollection(String string) {
        this.collName = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void setSort(String string) {
        this.sort = string;
    }

    public void setElemColl(String string) {
        this.elemColl = string;
    }

    public void setElemQuery(String string) {
        this.elemQuery = string;
    }
}

