/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.taglibs.util;

import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.PageContext;

public class ResourceUtil {
    private static String basename = "com.sun.web.search.taglibs.resources.messages";
    private static String L10NBUNDLE = "com.sun.web.search.taglibs.l10nBundle";
    private static String L10NDATEFORMAT = "com.sun.web.search.taglibs.l10nDateFormat";

    public static DateFormat getLocalizedDateFormat(PageContext pageContext) {
        DateFormat dateFormat = (DateFormat)pageContext.getAttribute(L10NDATEFORMAT);
        if (null == dateFormat) {
            ResourceBundle resourceBundle = ResourceUtil.getPCResourceBundle(pageContext);
            dateFormat = null != resourceBundle ? DateFormat.getDateTimeInstance(2, 1, resourceBundle.getLocale()) : DateFormat.getDateTimeInstance(2, 1, Locale.ENGLISH);
            pageContext.setAttribute(L10NDATEFORMAT, (Object)dateFormat);
        }
        return dateFormat;
    }

    public static String getLocalizedString(String string, PageContext pageContext) {
        ResourceBundle resourceBundle = ResourceUtil.getPCResourceBundle(pageContext);
        String string2 = null;
        if (null != resourceBundle) {
            string2 = resourceBundle.getString(string);
        }
        return null == string2 ? string : string2;
    }

    public static ResourceBundle getPCResourceBundle(PageContext pageContext) {
        ResourceBundle resourceBundle = null;
        resourceBundle = (ResourceBundle)pageContext.getAttribute(L10NBUNDLE);
        if (null != resourceBundle) {
            return resourceBundle;
        }
        Enumeration enumeration = pageContext.getRequest().getLocales();
        if (null != enumeration) {
            resourceBundle = ResourceUtil.getBundle(enumeration);
        }
        if (null == resourceBundle) {
            try {
                resourceBundle = ResourceBundle.getBundle(basename, new Locale("", ""));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        pageContext.setAttribute(L10NBUNDLE, (Object)resourceBundle);
        return resourceBundle;
    }

    private static ResourceBundle getBundle(Enumeration enumeration) {
        Locale locale;
        ResourceBundle resourceBundle = null;
        while (enumeration.hasMoreElements() && (resourceBundle = ResourceUtil.findMatch(locale = (Locale)enumeration.nextElement())) == null) {
        }
        return resourceBundle;
    }

    private static ResourceBundle findMatch(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
            Locale locale2 = resourceBundle2.getLocale();
            if (locale.equals(locale2)) {
                resourceBundle = resourceBundle2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && ("".equals(locale2.getCountry()) || locale.getCountry().equals(locale2.getCountry()))) {
                resourceBundle = resourceBundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }
}

