/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.taglibs.util;

import com.sun.web.search.taglibs.util.LocalStrings;
import com.sun.web.search.taglibs.util.Util;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class TagSupportEx
extends TagSupport {
    public static final String PAGE_ID = "page";
    public static final String REQUEST_ID = "request";
    public static final String SESSION_ID = "session";
    public static final String APPLICATION_ID = "application";
    static LocalStrings ls = LocalStrings.getSearchLogger();

    public int doEndTag() throws JspException {
        this.clearServiceState();
        return super.doEndTag();
    }

    public void release() {
        this.clearServiceState();
        this.clearProperties();
        super.release();
    }

    public void resetCustomProperties() {
        this.clearProperties();
    }

    protected void clearProperties() {
    }

    protected void clearServiceState() {
    }

    protected void log(String string) {
        this.getServletContext().log(string);
    }

    protected void log(String string, Throwable throwable) {
        this.getServletContext().log(string, throwable);
    }

    protected String findInitParameter(String string) {
        String string2 = this.getInitParameter(string, 1);
        if (null != string2) {
            return string2;
        }
        return this.getInitParameter(string, 4);
    }

    protected String getInitParameter(String string) {
        return this.getInitParameter(string, 4);
    }

    protected Enumeration getInitParameterNames() {
        return this.getInitParameterNamesForScope(4);
    }

    protected String getInitParameter(String string, int n) {
        switch (n) {
            case 1: {
                return this.getServletConfig().getInitParameter(string);
            }
            case 4: {
                return this.getServletContext().getInitParameter(string);
            }
        }
        throw new IllegalArgumentException(ls.getStr("search.taglibs.illegalScope"));
    }

    protected Enumeration getInitParameterNamesForScope(int n) {
        switch (n) {
            case 1: {
                return this.getServletConfig().getInitParameterNames();
            }
            case 4: {
                return this.getServletContext().getInitParameterNames();
            }
        }
        throw new IllegalArgumentException(ls.getStr("search.taglibs.illegalScope"));
    }

    protected ServletContext getServletContext() {
        return this.pageContext.getServletContext();
    }

    protected ServletConfig getServletConfig() {
        return this.pageContext.getServletConfig();
    }

    protected void writeHtml(JspWriter jspWriter, String string) throws IOException {
        jspWriter.print(Util.escapeHTML(string));
    }

    protected int translateScope(String string) throws JspException {
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase(PAGE_ID)) {
            return 1;
        }
        if (string.equalsIgnoreCase(REQUEST_ID)) {
            return 2;
        }
        if (string.equalsIgnoreCase(SESSION_ID)) {
            return 3;
        }
        if (string.equalsIgnoreCase(APPLICATION_ID)) {
            return 4;
        }
        return 1;
    }
}

