/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.util;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Search;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.Vs;
import com.iplanet.ias.config.serverbeans.Vsclass;
import com.iplanet.ias.config.serverbeans.Webapp;
import com.sun.web.search.util.CollectionConfig;
import com.sun.web.search.util.Util;
import com.sun.web.search.util.VSNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class SearchConfig {
    public static final String DEF_WEBAPP_SUBDIR = "/bin/https/webapps/search";
    public static final String DEF_WEBAPP_URI = "/search";
    public static final int DEF_MAXHITS = 5000;
    private String _vsId = null;
    private boolean _autoCommit = true;
    private ConfigContext _ctx = null;
    private Server _server = null;
    private Vs _vs = null;
    private Search _search = null;
    private int _maxhits = 5000;
    private Properties _props = null;
    private String _uri = "/search";
    private String _path = "/bin/https/webapps/search";
    private boolean _enabled = false;
    private boolean _srchExists = false;

    public SearchConfig(String string, String string2) throws ConfigException, VSNotFoundException {
        this(string, string2, false);
    }

    public SearchConfig(String string, String string2, boolean bl) throws ConfigException, VSNotFoundException {
        this._ctx = ConfigFactory.createConfigContext(string, bl, false, false);
        this._vsId = string2;
        this._path = Util.getInstallRoot() + this._path;
        this.init();
    }

    public void setAutoCommit(boolean bl) {
        this._autoCommit = bl;
    }

    private void init() throws ConfigException, VSNotFoundException {
        this._server = ServerBeansFactory.getServerBean(this._ctx);
        if (this._server != null) {
            Vsclass[] vsclassArray = this._server.getVsclass();
            for (int i = 0; i < vsclassArray.length; ++i) {
                Vs vs = vsclassArray[i].getVsById(this._vsId);
                if (vs == null) continue;
                this._vs = vs;
                this._search = vs.getSearch();
                if (this._search != null) {
                    this._srchExists = true;
                    break;
                }
                this._search = new Search();
                this._srchExists = false;
                break;
            }
            if (this._vs == null) {
                throw new VSNotFoundException("Virtual server '" + this._vsId + "' does not exist.");
            }
        }
        if (this._search == null) {
            return;
        }
        this.getDetails();
    }

    public int getMaxhits() {
        return this._maxhits;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getDefWebAppUri() {
        return this._uri;
    }

    public String getDefWebAppPath() {
        return this._path;
    }

    public boolean isDefWebAppEnabled() {
        return this._enabled;
    }

    public CollectionConfig getCollectionConfig() {
        CollectionConfig collectionConfig = new CollectionConfig(this, this._vsId, this._autoCommit);
        return collectionConfig;
    }

    public void setMaxhits(int n) {
        this._maxhits = n;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public void setDefWebAppDetails(String string, String string2, boolean bl) {
        this._uri = string;
        this._path = string2;
        this._enabled = bl;
    }

    public void save() throws ConfigException, VSNotFoundException {
        Webapp webapp = null;
        boolean bl = false;
        webapp = this._search.getWebapp();
        if (webapp == null) {
            webapp = new Webapp();
        } else {
            bl = true;
        }
        if (this._maxhits <= 0) {
            this._maxhits = 5000;
        }
        this._search.setMaxhits(Integer.toString(this._maxhits));
        if (this._props != null) {
            this.setElementProperties();
        }
        boolean bl2 = false;
        if (!(this._uri != null && !this._uri.equals("") || this._path != null && !this._path.equals("") || this._enabled)) {
            this._search.setWebapp(null);
        } else if (this._uri != null && this._path != null && !this._uri.equals("") && !this._path.equals("")) {
            webapp.setUri(this._uri);
            webapp.setPath(this._path);
            webapp.setEnabled(this._enabled);
            bl2 = true;
        }
        if (bl2 && bl) {
            this._search.setWebapp((Webapp)webapp.clone());
        } else if (bl2) {
            this._search.setWebapp(webapp);
        }
        if (this._srchExists) {
            this._vs.setSearch((Search)this._search.clone());
        } else {
            this._vs.setSearch(this._search);
        }
        this._ctx.flush();
        this._ctx.refresh(true);
        this.init();
    }

    Search getSearchBean() {
        return this._search;
    }

    private void setElementProperties() {
        ElementProperty[] elementPropertyArray;
        Enumeration<Object> enumeration = this._props.keys();
        ArrayList<ElementProperty> arrayList = new ArrayList<ElementProperty>();
        while (enumeration.hasMoreElements()) {
            elementPropertyArray = (ElementProperty[])enumeration.nextElement();
            String string = this._props.getProperty((String)elementPropertyArray);
            ElementProperty elementProperty = new ElementProperty();
            elementProperty.setName((String)elementPropertyArray);
            elementProperty.setValue(string);
            arrayList.add(elementProperty);
        }
        elementPropertyArray = new ElementProperty[arrayList.size()];
        elementPropertyArray = arrayList.toArray(elementPropertyArray);
        this._search.setElementProperty(elementPropertyArray);
    }

    private Properties getElementProperties() {
        Properties properties = new Properties();
        ElementProperty[] elementPropertyArray = this._search.getElementProperty();
        for (int i = 0; elementPropertyArray != null && i < elementPropertyArray.length; ++i) {
            properties.setProperty(elementPropertyArray[i].getName(), elementPropertyArray[i].getValue());
        }
        return properties;
    }

    private void getDetails() {
        String string = this._search.getMaxhits();
        if (string != null) {
            this._maxhits = Integer.parseInt(string);
        }
        if (this._maxhits <= 0) {
            this._maxhits = 5000;
        }
        this._props = this.getElementProperties();
        Webapp webapp = this._search.getWebapp();
        if (webapp == null) {
            return;
        }
        this._uri = webapp.getUri();
        if (this._uri == null || this._uri.equals("")) {
            this._uri = DEF_WEBAPP_URI;
        }
        this._path = webapp.getPath();
        if (this._path == null || this._path.equals("")) {
            this._path = Util.getInstallRoot() + DEF_WEBAPP_SUBDIR;
        }
        this._enabled = webapp.isEnabled();
    }
}

