/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.util;

import com.sun.web.search.util.PooledThread;
import java.util.LinkedList;

public abstract class ThreadPool {
    public static final int NUM_THREADS = 1;
    protected int numThreads;
    protected LinkedList queue = new LinkedList();
    protected Class threadClass;
    protected String name;

    protected ThreadPool(String string, Class clazz, int n) {
        this.numThreads = n;
        this.threadClass = clazz;
        this.name = string;
    }

    public void start() {
        for (int i = 0; i < this.numThreads; ++i) {
            PooledThread pooledThread;
            try {
                pooledThread = (PooledThread)this.threadClass.newInstance();
                pooledThread.setName(this.name + "_" + i);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("Invalid or unavailable thread class.");
            }
            pooledThread.setPool(this);
            pooledThread.start();
            this.enqueue(pooledThread);
        }
    }

    protected ThreadPool(String string, Class clazz) {
        this(string, clazz, 1);
    }

    public synchronized void enqueue(PooledThread pooledThread) {
        this.queue.addLast(pooledThread);
        this.notifyAll();
    }

    public synchronized PooledThread dequeue() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (PooledThread)this.queue.removeFirst();
    }
}

