/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebPrincipal;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.HttpRequestFacade;
import org.apache.catalina.deploy.LoginConfig;

public class WebProgrammaticLogin {
    public static final String WEBAUTH_PROGRAMMATIC = "PROGRAMMATIC";
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Boolean login(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        HttpRequestBase httpRequestBase = WebProgrammaticLogin.getHttpRequestBase(httpServletRequest);
        if (httpRequestBase == null) {
            return new Boolean(false);
        }
        try {
            object = WebProgrammaticLogin.getRealm(httpRequestBase);
            logger.fine("Programmatic login using realm: " + (String)object);
            LoginContextDriver.login(string, string2, (String)object);
        }
        catch (Exception exception) {
            logger.fine("Error in programmatic login: " + exception);
            return new Boolean(false);
        }
        object = new WebPrincipal(string, string2);
        httpRequestBase.setUserPrincipal((Principal)object);
        httpRequestBase.setAuthType(WEBAUTH_PROGRAMMATIC);
        logger.finest("Programmatic login set principal in http request to: " + string);
        Session session = WebProgrammaticLogin.getSession(httpRequestBase);
        if (session != null) {
            session.setPrincipal((Principal)object);
            session.setAuthType(WEBAUTH_PROGRAMMATIC);
            logger.finest("Programmatic login set principal in session.");
        } else {
            logger.finest("Programmatic login: No session available.");
        }
        return new Boolean(true);
    }

    public static Boolean logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpRequestBase httpRequestBase = WebProgrammaticLogin.getHttpRequestBase(httpServletRequest);
        if (httpRequestBase == null) {
            return new Boolean(false);
        }
        httpRequestBase.setUserPrincipal(null);
        httpRequestBase.setAuthType(null);
        logger.finest("Programmatic logout removed principal from request.");
        Session session = WebProgrammaticLogin.getSession(httpRequestBase);
        if (session != null) {
            session.setPrincipal(null);
            session.setAuthType(null);
            logger.finest("Programmatic logout removed principal from session.");
        }
        return new Boolean(true);
    }

    private static HttpRequestBase getHttpRequestBase(HttpServletRequest httpServletRequest) {
        if (!(httpServletRequest instanceof HttpRequestFacade)) {
            logger.warning("prologin.web.badclass");
            return null;
        }
        HttpRequestFacade httpRequestFacade = (HttpRequestFacade)httpServletRequest;
        HttpRequestBase httpRequestBase = null;
        try {
            httpRequestBase = httpRequestFacade.getHttpRequestBase();
        }
        catch (AccessControlException accessControlException) {
            logger.warning("prologin.web.badcall");
            return null;
        }
        return httpRequestBase;
    }

    private static Session getSession(HttpRequestBase httpRequestBase) {
        Manager manager;
        Context context;
        HttpSession httpSession = httpRequestBase.getSession(false);
        if (httpSession != null && (context = httpRequestBase.getContext()) != null && (manager = context.getManager()) != null) {
            String string = httpSession.getId();
            try {
                Session session = manager.findSession(string);
                return session;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getRealm(HttpRequestBase httpRequestBase) {
        Context context = httpRequestBase.getContext();
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        String string = null;
        LoginConfig loginConfig = context.getLoginConfig();
        if (loginConfig != null && (string = loginConfig.getRealmName()) != null && Realm.getInstance(string) == null) {
            string = null;
        }
        if (string == null) {
            string = Realm.getDefaultRealm();
        }
        return string;
    }

    static {
        $assertionsDisabled = !WebProgrammaticLogin.class.desiredAssertionStatus();
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

