/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.util.StringManager;

public class ResponseStream
extends ServletOutputStream {
    protected boolean closed = false;
    protected boolean commit = false;
    protected int count = 0;
    protected int length = -1;
    protected Response response = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected OutputStream stream = null;
    protected boolean suspended = false;

    public ResponseStream(Response response) {
        this.response = response;
        this.stream = response.getStream();
        this.suspended = response.isSuspended();
    }

    boolean getCommit() {
        return this.commit;
    }

    void setCommit(boolean bl) {
        this.commit = bl;
    }

    void setSuspended(boolean bl) {
        this.suspended = bl;
    }

    boolean isSuspended() {
        return this.suspended;
    }

    public void close() throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.close.closed"));
        }
        this.response.setClosing();
        this.response.getResponse().flushBuffer();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.flush.closed"));
        }
        if (this.commit) {
            this.response.getResponse().flushBuffer();
        }
    }

    public void write(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        if (this.length > 0 && this.count >= this.length) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
        ((ResponseBase)this.response).write(n);
        ++this.count;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        int n3 = n2;
        if (this.length > 0 && this.count + n2 >= this.length) {
            n3 = this.length - this.count;
        }
        ((ResponseBase)this.response).write(byArray, n, n3);
        this.count += n3;
        if (n3 < n2) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
    }

    boolean closed() {
        return this.closed;
    }

    void reset() {
        this.count = 0;
    }
}

