/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    private ArrayList filters = new ArrayList();
    private Iterator iterator = null;
    private Servlet servlet = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (System.getSecurityManager() != null) {
            final ServletRequest servletRequest2 = servletRequest;
            final ServletResponse servletResponse2 = servletResponse;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(servletRequest2, servletResponse2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.internalDoFilter(servletRequest, servletResponse);
        }
    }

    private void internalDoFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this.iterator == null) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            ApplicationFilterConfig applicationFilterConfig = (ApplicationFilterConfig)this.iterator.next();
            Filter filter = null;
            try {
                filter = applicationFilterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, servletRequest, servletResponse);
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse);
            }
            catch (IOException iOException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)iOException);
                }
                throw iOException;
            }
            catch (ServletException servletException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)servletException);
                }
                throw servletException;
            }
            catch (RuntimeException runtimeException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            catch (Throwable throwable) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, throwable);
                }
                throw new ServletException(sm.getString("filterChain.filter"), throwable);
            }
            return;
        }
        try {
            this.support.fireInstanceEvent("beforeService", this.servlet, servletRequest, servletResponse);
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
                this.servlet.service((ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)((HttpServletResponse)servletResponse));
            } else {
                this.servlet.service(servletRequest, servletResponse);
            }
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse);
        }
        catch (IOException iOException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)iOException);
            throw iOException;
        }
        catch (ServletException servletException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)servletException);
            throw servletException;
        }
        catch (RuntimeException runtimeException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, throwable);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable);
        }
    }

    void addFilter(ApplicationFilterConfig applicationFilterConfig) {
        this.filters.add(applicationFilterConfig);
    }

    void release() {
        this.filters.clear();
        this.iterator = this.iterator;
        this.servlet = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport instanceSupport) {
        this.support = instanceSupport;
    }
}

