/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.DirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.catalina.Auditor;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public class StandardContext
extends ContainerBase
implements Context {
    private String[] applicationListeners = new String[0];
    private Object[] applicationListenersObjects = new Object[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean available = false;
    private CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private boolean configured = false;
    private SecurityConstraint[] constraints = new SecurityConstraint[0];
    protected ApplicationContext context = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private String displayName = null;
    private String docBase = null;
    private HashMap ejbs = new HashMap();
    private HashMap envs = new HashMap();
    private HashMap exceptionPages = new HashMap();
    private HashMap filterConfigs = new HashMap();
    private HashMap filterDefs = new HashMap();
    private FilterMap[] filterMaps = new FilterMap[0];
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    private String[] instanceListeners = new String[0];
    private HashMap localEjbs = new HashMap();
    private LoginConfig loginConfig = null;
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private HashMap mimeMappings = new HashMap();
    private HashMap parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean override = false;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private HashMap resourceEnvRefs = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap resourceParams = new HashMap();
    private HashMap roleMappings = new HashMap();
    private String[] securityRoles = new String[0];
    private HashMap servletMappings = new HashMap();
    private int sessionTimeout = 30;
    private HashMap statusPages = new HashMap();
    private HashMap taglibs = new HashMap();
    private String[] welcomeFiles = new String[0];
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String workDir = null;
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private String _altDDName = null;
    protected boolean cachingAllowed = true;
    private int stmPoolSize = 5;
    private Auditor[] auditors = null;
    private static int instanceIDCounter = 1;
    private boolean reuseSessionID = false;
    private boolean allowRelativeRedirect = false;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean bl) {
        this.cachingAllowed = bl;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        this.useNaming = bl;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    public Object[] getApplicationListeners() {
        return this.applicationListenersObjects;
    }

    public void setApplicationListeners(Object[] objectArray) {
        this.applicationListenersObjects = objectArray;
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(boolean bl) {
        boolean bl2 = this.available;
        this.available = bl;
        this.support.firePropertyChange("available", new Boolean(bl2), new Boolean(this.available));
    }

    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    public void setCharsetMapper(CharsetMapper charsetMapper) {
        CharsetMapper charsetMapper2 = this.charsetMapper;
        this.charsetMapper = charsetMapper;
        this.support.firePropertyChange("charsetMapper", charsetMapper2, this.charsetMapper);
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean bl) {
        boolean bl2 = this.configured;
        this.configured = bl;
        this.support.firePropertyChange("configured", new Boolean(bl2), new Boolean(this.configured));
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean bl) {
        boolean bl2 = this.cookies;
        this.cookies = bl;
        this.support.firePropertyChange("cookies", new Boolean(bl2), new Boolean(this.cookies));
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean bl) {
        boolean bl2 = this.crossContext;
        this.crossContext = bl;
        this.support.firePropertyChange("crossContext", new Boolean(bl2), new Boolean(this.crossContext));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        this.support.firePropertyChange("displayName", string2, this.displayName);
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String string) {
        this.docBase = string;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void setLoader(Loader loader) {
        super.setLoader(loader);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        String string;
        if (loginConfig == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String string2 = loginConfig.getLoginPage();
        if (string2 != null && !string2.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(sm.getString("standardContext.loginConfig.loginWarning", string2), 2);
                loginConfig.setLoginPage("/" + string2);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", string2));
            }
        }
        if ((string = loginConfig.getErrorPage()) != null && !string.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(sm.getString("standardContext.loginConfig.errorWarning", string), 2);
                loginConfig.setErrorPage("/" + string);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", string));
            }
        }
        LoginConfig loginConfig2 = this.loginConfig;
        this.loginConfig = loginConfig;
        this.support.firePropertyChange("loginConfig", loginConfig2, this.loginConfig);
    }

    public String getPath() {
        return this.getName();
    }

    public void setPath(String string) {
        this.setName(RequestUtil.URLDecode(string));
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String string) {
        if (this.debug >= 1) {
            this.log("Setting deployment descriptor public ID to '" + string + "'");
        }
        String string2 = this.publicId;
        this.publicId = string;
        this.support.firePropertyChange("publicId", string2, string);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", new Boolean(bl2), new Boolean(this.reloadable));
    }

    public void setOverride(boolean bl) {
        boolean bl2 = this.override;
        this.override = bl;
        this.support.firePropertyChange("override", new Boolean(bl2), new Boolean(this.override));
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(boolean bl) {
        boolean bl2 = this.privileged;
        this.privileged = bl;
        this.support.firePropertyChange("privileged", new Boolean(bl2), new Boolean(this.privileged));
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean bl) {
        boolean bl2 = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = bl;
        this.support.firePropertyChange("replaceWelcomeFiles", new Boolean(bl2), new Boolean(this.replaceWelcomeFiles));
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(), this);
            if (this._altDDName != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this._altDDName);
            }
        }
        return this.context;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int n) {
        int n2 = this.sessionTimeout;
        this.sessionTimeout = n > 0 ? n : -1;
        this.support.firePropertyChange("sessionTimeout", new Integer(n2), new Integer(this.sessionTimeout));
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String string) {
        this.wrapperClass = string;
    }

    public synchronized void setResources(DirContext dirContext) {
        if (dirContext instanceof BaseDirContext) {
            ((BaseDirContext)dirContext).setDocBase(this.getBasePath());
            ((BaseDirContext)dirContext).setCached(this.isCachingAllowed());
        }
        if (dirContext instanceof FileDirContext) {
            this.filesystemBased = true;
        }
        super.setResources(dirContext);
        if (this.started) {
            this.postResources();
        }
    }

    public void setAltDDName(String string) {
        this._altDDName = string;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this._altDDName);
        }
    }

    public Auditor[] getAuditors() {
        return this.auditors;
    }

    public void setAuditors(Auditor[] auditorArray) {
        this.auditors = auditorArray;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String string) {
        String string2 = this.charsetMapperClass;
        this.charsetMapperClass = string;
        this.support.firePropertyChange("charsetMapperClass", string2, this.charsetMapperClass);
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String string) {
        String string2 = this.mapperClass;
        this.mapperClass = string;
        this.support.firePropertyChange("mapperClass", string2, this.mapperClass);
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String string) {
        this.workDir = string;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    public int getSTMPoolSize() {
        return this.stmPoolSize;
    }

    public void setSTMPoolSize(int n) {
        int n2 = this.stmPoolSize;
        this.stmPoolSize = n;
        this.support.firePropertyChange("stmPoolSize", new Integer(n2), new Integer(this.stmPoolSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String string) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            String[] stringArray2 = new String[this.applicationListeners.length + 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (string.equals(this.applicationListeners[i])) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                stringArray2[i] = this.applicationListeners[i];
            }
            stringArray2[this.applicationListeners.length] = string;
            this.applicationListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addApplicationListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter applicationParameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            String string = applicationParameter.getName();
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!this.name.equals(this.applicationParameters[i].getName()) || this.applicationParameters[i].getOverride()) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ApplicationParameter[] applicationParameterArray2 = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, applicationParameterArray2, 0, this.applicationParameters.length);
            applicationParameterArray2[this.applicationParameters.length] = applicationParameter;
            this.applicationParameters = applicationParameterArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addApplicationParameter", applicationParameter);
            return;
        }
    }

    public void addChild(Container container) {
        if (!(container instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        Wrapper wrapper = (Wrapper)container;
        String string = wrapper.getJspFile();
        if (string != null && !string.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(sm.getString("standardContext.wrapper.warning", string), 2);
                wrapper.setJspFile("/" + string);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.wrapper.error", string));
            }
        }
        super.addChild(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstraint(SecurityConstraint securityConstraint) {
        int n;
        Object[] objectArray;
        SecurityCollection[] securityCollectionArray = securityConstraint.findCollections();
        for (int i = 0; i < securityCollectionArray.length; ++i) {
            objectArray = securityCollectionArray[i].findPatterns();
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = this.adjustURLPattern((String)objectArray[n]);
                if (this.validateURLPattern((String)objectArray[n])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", objectArray[n]));
            }
        }
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            objectArray = new SecurityConstraint[this.constraints.length + 1];
            for (n = 0; n < this.constraints.length; ++n) {
                objectArray[n] = this.constraints[n];
            }
            objectArray[this.constraints.length] = securityConstraint;
            this.constraints = objectArray;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb contextEjb) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.put(contextEjb.getName(), contextEjb);
        }
        this.fireContainerEvent("addEjb", contextEjb.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment contextEnvironment2 = (ContextEnvironment)this.envs.get(contextEnvironment.getName());
            if (contextEnvironment2 != null && !contextEnvironment2.getOverride()) {
                return;
            }
            this.envs.put(contextEnvironment.getName(), contextEnvironment);
        }
        this.fireContainerEvent("addEnvironment", contextEnvironment.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceParams(ResourceParams resourceParams) {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            this.resourceParams.put(resourceParams.getName(), resourceParams);
        }
        this.fireContainerEvent("addResourceParams", resourceParams.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPage(ErrorPage errorPage) {
        String string;
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String string2 = errorPage.getLocation();
        if (string2 != null && !string2.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(sm.getString("standardContext.errorPage.warning", string2), 2);
                errorPage.setLocation("/" + string2);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", string2));
            }
        }
        if ((string = errorPage.getExceptionType()) != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.put(string, errorPage);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.put(new Integer(errorPage.getErrorCode()), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterMap(FilterMap filterMap) {
        String string = filterMap.getFilterName();
        String string2 = filterMap.getServletName();
        String string3 = filterMap.getURLPattern();
        if (this.findFilterDef(string) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", string));
        }
        if (string2 == null && string3 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (string2 != null && string3 != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (string3 != null && !this.validateURLPattern(string3)) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", string3));
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            FilterMap[] filterMapArray2 = new FilterMap[this.filterMaps.length + 1];
            System.arraycopy(this.filterMaps, 0, filterMapArray2, 0, this.filterMaps.length);
            filterMapArray2[this.filterMaps.length] = filterMap;
            this.filterMaps = filterMapArray2;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.fireContainerEvent("addFilterMap", filterMap);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String string) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            String[] stringArray2 = new String[this.instanceListeners.length + 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                stringArray2[i] = this.instanceListeners[i];
            }
            stringArray2[this.instanceListeners.length] = string;
            this.instanceListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addInstanceListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb contextLocalEjb) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            this.localEjbs.put(contextLocalEjb.getName(), contextLocalEjb);
        }
        this.fireContainerEvent("addLocalEjb", contextLocalEjb.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMimeMapping(String string, String string2) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(string, string2);
        }
        this.fireContainerEvent("addMimeMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(string) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", string));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(string, string2);
        }
        this.fireContainerEvent("addParameter", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource contextResource) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.put(contextResource.getName(), contextResource);
        }
        this.fireContainerEvent("addResource", contextResource.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(String string, String string2) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.put(string, string2);
        }
        this.fireContainerEvent("addResourceEnvRef", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleMapping(String string, String string2) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.put(string, string2);
        }
        this.fireContainerEvent("addRoleMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityRole(String string) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            String[] stringArray2 = new String[this.securityRoles.length + 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                stringArray2[i] = this.securityRoles[i];
            }
            stringArray2[this.securityRoles.length] = string;
            this.securityRoles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addSecurityRole", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String string, String string2) {
        if (this.findChild(string2) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", string2));
        }
        if (!this.validateURLPattern(string = this.adjustURLPattern(RequestUtil.URLDecode(string)))) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", string));
        }
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            this.servletMappings.put(string, string2);
        }
        this.fireContainerEvent("addServletMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaglib(String string, String string2) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.put(string, string2);
        }
        this.fireContainerEvent("addTaglib", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWelcomeFile(String string) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            if (this.replaceWelcomeFiles) {
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] stringArray2 = new String[this.welcomeFiles.length + 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                stringArray2[i] = this.welcomeFiles[i];
            }
            stringArray2[this.welcomeFiles.length] = string;
            this.welcomeFiles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            this.fireContainerEvent("addWelcomeFile", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String string) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            String[] stringArray2 = new String[this.wrapperLifecycles.length + 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                stringArray2[i] = this.wrapperLifecycles[i];
            }
            stringArray2[this.wrapperLifecycles.length] = string;
            this.wrapperLifecycles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addWrapperLifecycle", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String string) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            String[] stringArray2 = new String[this.wrapperListeners.length + 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                stringArray2[i] = this.wrapperListeners[i];
            }
            stringArray2[this.wrapperListeners.length] = string;
            this.wrapperListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addWrapperListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        StandardWrapper standardWrapper = new StandardWrapper();
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            Object object;
            Class<?> clazz;
            int n;
            for (n = 0; n < this.instanceListeners.length; ++n) {
                try {
                    clazz = Class.forName(this.instanceListeners[n]);
                    object = (InstanceListener)clazz.newInstance();
                    standardWrapper.addInstanceListener((InstanceListener)object);
                    continue;
                }
                catch (Throwable throwable) {
                    this.log("createWrapper", throwable);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = this.wrapperLifecycles;
            synchronized (this.wrapperLifecycles) {
                for (n = 0; n < this.wrapperLifecycles.length; ++n) {
                    try {
                        clazz = Class.forName(this.wrapperLifecycles[n]);
                        object = (LifecycleListener)clazz.newInstance();
                        if (!(standardWrapper instanceof Lifecycle)) continue;
                        ((Lifecycle)standardWrapper).addLifecycleListener((LifecycleListener)object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.log("createWrapper", throwable);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                stringArray = this.wrapperListeners;
                synchronized (this.wrapperListeners) {
                    for (n = 0; n < this.wrapperListeners.length; ++n) {
                        try {
                            clazz = Class.forName(this.wrapperListeners[n]);
                            object = (ContainerListener)clazz.newInstance();
                            standardWrapper.addContainerListener((ContainerListener)object);
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.log("createWrapper", throwable);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return null;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    standardWrapper.setMaxInstances(this.stmPoolSize);
                    return standardWrapper;
                }
            }
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String string) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            return (ContextEjb)this.ejbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] contextEjbArray = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(contextEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String string) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            return (ContextEnvironment)this.envs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] contextEnvironmentArray = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(contextEnvironmentArray);
        }
    }

    public ErrorPage findErrorPage(int n) {
        if (n > 200) {
            return (ErrorPage)this.statusPages.get(new Integer(n));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage findErrorPage(String string) {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            return (ErrorPage)this.exceptionPages.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage[] findErrorPages() {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            HashMap hashMap2 = this.statusPages;
            synchronized (hashMap2) {
                int n;
                ErrorPage[] errorPageArray = new ErrorPage[this.exceptionPages.size()];
                errorPageArray = this.exceptionPages.values().toArray(errorPageArray);
                ErrorPage[] errorPageArray2 = new ErrorPage[this.statusPages.size()];
                errorPageArray2 = this.statusPages.values().toArray(errorPageArray2);
                ErrorPage[] errorPageArray3 = new ErrorPage[errorPageArray.length + errorPageArray2.length];
                for (n = 0; n < errorPageArray.length; ++n) {
                    errorPageArray3[n] = errorPageArray[n];
                }
                for (n = errorPageArray.length; n < errorPageArray3.length; ++n) {
                    errorPageArray3[n] = errorPageArray2[n - errorPageArray.length];
                }
                return errorPageArray3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef findFilterDef(String string) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            return (FilterDef)this.filterDefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef[] findFilterDefs() {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] filterDefArray = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(filterDefArray);
        }
    }

    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String string) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            return (ContextLocalEjb)this.localEjbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            ContextLocalEjb[] contextLocalEjbArray = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(contextLocalEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMimeMapping(String string) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            return (String)this.mimeMappings.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMimeMappings() {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            String[] stringArray = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] stringArray = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String string) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            return (ContextResource)this.resources.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findResourceEnvRef(String string) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return (String)this.resourceEnvRefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findResourceEnvRefs() {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            String[] stringArray = new String[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] contextResourceArray = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(contextResourceArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findRoleMapping(String string) {
        String string2 = null;
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            string2 = (String)this.roleMappings.get(string);
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findSecurityRole(String string) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!string.equals(this.securityRoles[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public String[] findSecurityRoles() {
        return this.securityRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findServletMapping(String string) {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            return (String)this.servletMappings.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findServletMappings() {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            String[] stringArray = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(stringArray);
        }
    }

    public String findStatusPage(int n) {
        return (String)this.statusPages.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findStatusPages() {
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            int[] nArray = new int[this.statusPages.size()];
            Iterator iterator = this.statusPages.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findTaglib(String string) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            return (String)this.taglibs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findTaglibs() {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            String[] stringArray = new String[this.taglibs.size()];
            return this.taglibs.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findWelcomeFile(String string) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!string.equals(this.welcomeFiles[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        while (this.getPaused()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.invoke(request, response);
    }

    public synchronized void reload() {
        int n;
        if (!this.started) {
            throw new IllegalStateException(sm.getString("containerBase.notStarted", this.logName()));
        }
        this.log(sm.getString("standardContext.reloadingStarted"));
        this.setPaused(true);
        ClassLoader classLoader = this.bindThread();
        Container[] containerArray = this.findChildren();
        for (n = 0; n < containerArray.length; ++n) {
            Wrapper wrapper = (Wrapper)containerArray[n];
            if (!(wrapper instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)wrapper)).stop();
                continue;
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.stoppingWrapper", wrapper.getName()), lifecycleException);
            }
        }
        if (this.context != null) {
            this.context.clearAttributes();
        }
        this.filterStop();
        this.listenerStop();
        if (this.manager != null && this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.stoppingManager"), lifecycleException);
            }
        }
        this.unbindThread(classLoader);
        if (this.loader != null && this.loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.loader)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.stoppingLoader"), lifecycleException);
            }
        }
        if (this.isUseNaming()) {
            ContextBindings.unbindClassLoader(this, this);
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.loader)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.startingLoader"), lifecycleException);
            }
        }
        n = 1;
        if (this.isUseNaming()) {
            try {
                this.createNamingContext();
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.namingInitFailed", this.getName()), namingException);
                n = 0;
            }
        }
        classLoader = this.bindThread();
        if (n != 0 && !this.listenerStart()) {
            this.log(sm.getString("standardContext.listenerStartFailed"), 1);
            n = 0;
        }
        if (n != 0 && !this.filterStart()) {
            this.log(sm.getString("standardContext.filterStartFailed"), 1);
            n = 0;
        }
        this.postResources();
        this.postWelcomeFiles();
        for (int i = 0; i < containerArray.length && n != 0; ++i) {
            Wrapper wrapper = (Wrapper)containerArray[i];
            if (!(wrapper instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)wrapper)).start();
                continue;
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.startingWrapper", wrapper.getName()), lifecycleException);
                n = 0;
            }
        }
        this.loadOnStartup(containerArray);
        if (this.manager != null && this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log(sm.getString("standardContext.startingManager"), lifecycleException);
            }
        }
        this.unbindThread(classLoader);
        if (n != 0) {
            this.log(sm.getString("standardContext.reloadingCompleted"));
        } else {
            this.setAvailable(false);
            this.log(sm.getString("standardContext.reloadingFailed"), 1);
        }
        this.setPaused(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String string) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.applicationListeners.length; ++n) {
                if (!this.applicationListeners[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.applicationListeners[i];
            }
            this.applicationListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeApplicationListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String string) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.applicationParameters.length; ++n) {
                if (!string.equals(this.applicationParameters[n].getName())) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            ApplicationParameter[] applicationParameterArray2 = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n2) continue;
                applicationParameterArray2[n++] = this.applicationParameters[i];
            }
            this.applicationParameters = applicationParameterArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeApplicationParameter", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstraint(SecurityConstraint securityConstraint) {
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.constraints.length; ++n) {
                if (!this.constraints[n].equals(securityConstraint)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            SecurityConstraint[] securityConstraintArray2 = new SecurityConstraint[this.constraints.length - 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i == n2) continue;
                securityConstraintArray2[n++] = this.constraints[i];
            }
            this.constraints = securityConstraintArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeConstraint", securityConstraint);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String string) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.remove(string);
        }
        this.fireContainerEvent("removeEjb", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String string) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.remove(string);
        }
        this.fireContainerEvent("removeEnvironment", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorPage(ErrorPage errorPage) {
        String string = errorPage.getExceptionType();
        if (string != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.remove(string);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.remove(new Integer(errorPage.getErrorCode()));
        }
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterMap(FilterMap filterMap) {
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            int n = -1;
            for (int i = 0; i < this.filterMaps.length; ++i) {
                if (this.filterMaps[i] != filterMap) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FilterMap[] filterMapArray2 = new FilterMap[this.filterMaps.length - 1];
            System.arraycopy(this.filterMaps, 0, filterMapArray2, 0, n);
            System.arraycopy(this.filterMaps, n + 1, filterMapArray2, n, this.filterMaps.length - 1 - n);
            this.filterMaps = filterMapArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeFilterMap", filterMap);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String string) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.instanceListeners.length; ++n) {
                if (!this.instanceListeners[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.instanceListeners.length - 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.instanceListeners[i];
            }
            this.instanceListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeInstanceListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String string) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            this.localEjbs.remove(string);
        }
        this.fireContainerEvent("removeLocalEjb", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMimeMapping(String string) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(string);
        }
        this.fireContainerEvent("removeMimeMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(string);
        }
        this.fireContainerEvent("removeParameter", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String string) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.remove(string);
        }
        this.fireContainerEvent("removeResource", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String string) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.remove(string);
        }
        this.fireContainerEvent("removeResourceEnvRef", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleMapping(String string) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.remove(string);
        }
        this.fireContainerEvent("removeRoleMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRole(String string) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.securityRoles.length; ++n) {
                if (!string.equals(this.securityRoles[n])) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.securityRoles.length - 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.securityRoles[i];
            }
            this.securityRoles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeSecurityRole", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletMapping(String string) {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            this.servletMappings.remove(string);
        }
        this.fireContainerEvent("removeServletMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaglib(String string) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.remove(string);
        }
        this.fireContainerEvent("removeTaglib", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWelcomeFile(String string) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.welcomeFiles.length; ++n) {
                if (!this.welcomeFiles[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.welcomeFiles.length - 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.welcomeFiles[i];
            }
            this.welcomeFiles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            this.fireContainerEvent("removeWelcomeFile", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String string) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.wrapperLifecycles.length; ++n) {
                if (!this.wrapperLifecycles[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeWrapperLifecycle", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String string) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.wrapperListeners.length; ++n) {
                if (!this.wrapperListeners[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeWrapperListener", string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (this.debug >= 1) {
            this.log("Starting filters");
        }
        boolean bl = true;
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            Iterator iterator = this.filterDefs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.debug >= 1) {
                    this.log(" Starting filter '" + string + "'");
                }
                ApplicationFilterConfig applicationFilterConfig = null;
                try {
                    applicationFilterConfig = new ApplicationFilterConfig(this, (FilterDef)this.filterDefs.get(string));
                    this.filterConfigs.put(string, applicationFilterConfig);
                }
                catch (Throwable throwable) {
                    this.log(sm.getString("standardContext.filterStart", string), throwable);
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (this.debug >= 1) {
            this.log("Stopping filters");
        }
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            Iterator iterator = this.filterConfigs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.debug >= 1) {
                    this.log(" Stopping filter '" + string + "'");
                }
                ApplicationFilterConfig applicationFilterConfig = (ApplicationFilterConfig)this.filterConfigs.get(string);
                applicationFilterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterConfig findFilterConfig(String string) {
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            return (FilterConfig)this.filterConfigs.get(string);
        }
    }

    public boolean listenerStart() {
        ServletContextEvent servletContextEvent;
        if (this.debug >= 1) {
            this.log("Configuring application event listeners");
        }
        ClassLoader classLoader = this.getLoader().getClassLoader();
        String[] stringArray = this.findApplicationListeners();
        Object[] objectArray = new Object[stringArray.length];
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.debug >= 2) {
                this.log(" Configuring event listener class '" + stringArray[i] + "'");
            }
            try {
                servletContextEvent = classLoader.loadClass(stringArray[i]);
                objectArray[i] = servletContextEvent.newInstance();
                continue;
            }
            catch (Throwable throwable) {
                this.log(sm.getString("standardContext.applicationListener", stringArray[i]), throwable);
                bl = false;
            }
        }
        if (!bl) {
            this.log(sm.getString("standardContext.applicationSkipped"), 2);
            return false;
        }
        if (this.debug >= 1) {
            this.log("Sending application start events");
        }
        this.setApplicationListeners(objectArray);
        Object[] objectArray2 = this.getApplicationListeners();
        if (objectArray2 == null) {
            return bl;
        }
        servletContextEvent = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i] == null || !(objectArray2[i] instanceof ServletContextListener)) continue;
            ServletContextListener servletContextListener = (ServletContextListener)objectArray2[i];
            try {
                this.fireContainerEvent("beforeContextInitialized", servletContextListener);
                servletContextListener.contextInitialized(servletContextEvent);
                this.fireContainerEvent("afterContextInitialized", servletContextListener);
                continue;
            }
            catch (Throwable throwable) {
                this.fireContainerEvent("afterContextInitialized", servletContextListener);
                this.log(sm.getString("standardContext.listenerStart", objectArray2[i].getClass().getName()), throwable);
                bl = false;
            }
        }
        return bl;
    }

    public boolean listenerStop() {
        if (this.debug >= 1) {
            this.log("Sending application stop events");
        }
        boolean bl = true;
        Object[] objectArray = this.getApplicationListeners();
        if (objectArray == null) {
            return bl;
        }
        ServletContextEvent servletContextEvent = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < objectArray.length; ++i) {
            int n = objectArray.length - 1 - i;
            if (objectArray[n] == null || !(objectArray[n] instanceof ServletContextListener)) continue;
            ServletContextListener servletContextListener = (ServletContextListener)objectArray[n];
            try {
                this.fireContainerEvent("beforeContextDestroyed", servletContextListener);
                servletContextListener.contextDestroyed(servletContextEvent);
                this.fireContainerEvent("beforeContextDestroyed", servletContextListener);
                continue;
            }
            catch (Throwable throwable) {
                this.fireContainerEvent("beforeContextDestroyed", servletContextListener);
                this.log(sm.getString("standardContext.listenerStop", objectArray[n].getClass().getName()), throwable);
                bl = false;
            }
        }
        this.setApplicationListeners(null);
        return bl;
    }

    public void loadOnStartup(Container[] containerArray) {
        Object object;
        ArrayList arrayList;
        Object object2;
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < containerArray.length; ++i) {
            object2 = (Wrapper)containerArray[i];
            int n = object2.getLoadOnStartup();
            if (n < 0) continue;
            if (n == 0) {
                n = Integer.MAX_VALUE;
            }
            if ((arrayList = (ArrayList)treeMap.get(object = new Integer(n))) == null) {
                arrayList = new ArrayList();
                treeMap.put(object, arrayList);
            }
            arrayList.add(object2);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Integer)iterator.next();
            ArrayList arrayList2 = (ArrayList)treeMap.get(object2);
            object = arrayList2.iterator();
            while (object.hasNext()) {
                arrayList = (Wrapper)object.next();
                try {
                    arrayList.load();
                }
                catch (ServletException servletException) {
                    this.log(sm.getString("standardWrapper.loadException", this.getName()), servletException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws LifecycleException {
        boolean bl;
        block46: {
            if (this.started) {
                throw new LifecycleException(sm.getString("containerBase.alreadyStarted", this.logName()));
            }
            if (this.debug >= 1) {
                this.log("Starting");
            }
            if (this.debug >= 1) {
                this.log("Processing start(), current available=" + this.getAvailable());
            }
            this.setAvailable(false);
            this.setConfigured(false);
            bl = true;
            if (this.getResources() == null) {
                if (this.debug >= 1) {
                    this.log("Configuring default Resources");
                }
                try {
                    if (this.docBase != null && this.docBase.endsWith(".war")) {
                        this.setResources(new WARDirContext());
                        break block46;
                    }
                    this.setResources(new FileDirContext());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log("Error initializing resources: " + illegalArgumentException.getMessage(), 1);
                    bl = false;
                }
            } else {
                DirContext dirContext = this.getResources();
                if (dirContext instanceof ProxyDirContext) {
                    dirContext = ((ProxyDirContext)dirContext).getDirContext();
                    this.log("Configuring ProxyDirContext Resources" + dirContext);
                }
                if (dirContext instanceof BaseDirContext) {
                    ((BaseDirContext)dirContext).setDocBase(this.getBasePath());
                    ((BaseDirContext)dirContext).setCached(this.isCachingAllowed());
                }
                if (dirContext instanceof FileDirContext) {
                    this.filesystemBased = true;
                }
            }
        }
        if (this.getLoader() == null) {
            if (this.debug >= 1) {
                this.log("Configuring non-privileged default Loader");
            }
            this.setLoader(new WebappLoader(this.getParentClassLoader()));
        }
        if (this.getManager() == null) {
            if (this.debug >= 1) {
                this.log("Configuring default Manager");
            }
            this.setManager(new StandardManager());
        }
        if (bl) {
            DirContextURLStreamHandler.bind(this.getResources());
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        if (this.debug >= 1) {
            this.log("Processing standard container startup");
        }
        if (bl) {
            this.addDefaultMapper(this.mapperClass);
            this.started = true;
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).start();
            }
            boolean bl2 = this.isUseNaming();
            this.setUseNaming(false);
            ClassLoader classLoader = this.bindThread();
            this.setUseNaming(bl2);
            try {
                String string;
                if (this.logger != null && this.logger instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.logger)).start();
                }
                if (this.manager != null && this.manager instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.manager)).start();
                }
                if (this.realm != null && this.realm instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.realm)).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).start();
                }
                Mapper[] mapperArray = this.findMappers();
                for (int i = 0; i < mapperArray.length; ++i) {
                    if (!(mapperArray[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)mapperArray[i])).start();
                }
                Container[] containerArray = this.findChildren();
                for (int i = 0; i < containerArray.length; ++i) {
                    if (!(containerArray[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)containerArray[i])).start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                this.lifecycle.fireLifecycleEvent("start", null);
                if (!this.getConfigured()) {
                    bl = false;
                }
                if ((string = System.getProperty("catalina.useNaming")) != null && string.equals("false")) {
                    this.useNaming = false;
                }
                if (bl && this.isUseNaming()) {
                    try {
                        this.createNamingContext();
                        ContextBindings.bindThread(this, this);
                    }
                    catch (NamingException namingException) {
                        this.log(sm.getString("standardContext.namingInitFailed", this.getName()), namingException);
                        bl = false;
                    }
                }
                if (bl) {
                    this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
                }
                if (bl && !this.listenerStart()) {
                    bl = false;
                }
                if (bl && !this.filterStart()) {
                    bl = false;
                }
                if (bl) {
                    if (this.debug >= 1) {
                        this.log("Posting standard context attributes");
                    }
                    this.postWelcomeFiles();
                }
                if (bl) {
                    this.loadOnStartup(this.findChildren());
                }
            }
            finally {
                this.unbindThread(classLoader);
            }
        }
        if (bl) {
            if (this.debug >= 1) {
                this.log("Starting completed");
            }
            this.setAvailable(true);
        } else {
            this.log(sm.getString("standardContext.startFailed"), 1);
            try {
                this.stop();
            }
            catch (Throwable throwable) {
                this.log(sm.getString("standardContext.startCleanup"), throwable);
            }
            this.setAvailable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        this.setAvailable(false);
        ClassLoader classLoader = this.bindThread();
        try {
            DirContext dirContext;
            this.filterStop();
            this.setCharsetMapper(null);
            if (this.isUseNaming()) {
                ContextBindings.unbindClassLoader(this, this);
                ContextAccessController.unsetSecurityToken(this.getNamingContextName(), this);
                ContextBindings.unbindContext(this);
            }
            if (this.debug >= 1) {
                this.log("Processing standard container shutdown");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            Container[] containerArray = this.findChildren();
            for (int i = 0; i < containerArray.length; ++i) {
                if (!(containerArray[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)containerArray[i])).stop();
            }
            Mapper[] mapperArray = this.findMappers();
            for (int i = 0; i < mapperArray.length; ++i) {
                if (!(mapperArray[mapperArray.length - 1 - i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)mapperArray[mapperArray.length - 1 - i])).stop();
            }
            if (this.resources != null && this.resources instanceof Lifecycle) {
                ((Lifecycle)((Object)this.resources)).stop();
            }
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).stop();
            }
            if (this.manager != null && this.manager instanceof Lifecycle) {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            this.listenerStop();
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)((Object)this.logger)).stop();
            }
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
            if ((dirContext = this.getResources()) != null && dirContext instanceof ProxyDirContext) {
                dirContext = ((ProxyDirContext)dirContext).getDirContext();
            }
            if (dirContext != null) {
                if (this.debug >= 1) {
                    this.log("Releasing document base " + this.docBase);
                }
                if (dirContext instanceof BaseDirContext) {
                    ((BaseDirContext)dirContext).release();
                } else {
                    this.log("Cannot release " + this.resources);
                }
            }
        }
        finally {
            this.unbindThread(classLoader);
        }
        if (this.debug >= 1) {
            this.log("Stopping complete");
        }
    }

    public boolean getReuseSessionID() {
        return this.reuseSessionID;
    }

    public void setReuseSessionID(boolean bl) {
        this.reuseSessionID = bl;
    }

    public boolean getAllowRelativeRedirect() {
        return this.allowRelativeRedirect;
    }

    public void setAllowRelativeRedirect(boolean bl) {
        this.allowRelativeRedirect = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getParent() != null) {
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append(".");
        }
        stringBuffer.append("StandardContext[");
        stringBuffer.append(this.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void addDefaultMapper(String string) {
        super.addDefaultMapper(this.mapperClass);
    }

    protected String adjustURLPattern(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("/") || string.startsWith("*.")) {
            return string;
        }
        if (!this.isServlet22()) {
            return string;
        }
        this.log(sm.getString("standardContext.urlPattern.patternWarning", string));
        return "/" + string;
    }

    protected boolean isServlet22() {
        if (this.publicId == null) {
            return false;
        }
        return this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        return new File(System.getProperty("catalina.base"));
    }

    private ClassLoader bindThread() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.getResources() == null) {
            return classLoader;
        }
        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        DirContextURLStreamHandler.bind(this.getResources());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread(this, this);
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.namingInitFailed", this.getName()), namingException);
            }
        }
        return classLoader;
    }

    private void unbindThread(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
        classLoader = null;
        if (this.isUseNaming()) {
            ContextBindings.unbindThread(this, this);
        }
        DirContextURLStreamHandler.unbind();
    }

    private String getBasePath() {
        Container container;
        String string = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container == null) {
            string = new File(this.engineBase(), this.getDocBase()).getPath();
        } else {
            File file = new File(this.getDocBase());
            if (!file.isAbsolute()) {
                String string2 = ((Host)container).getAppBase();
                file = new File(string2);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), string2);
                }
                string = new File(file, this.getDocBase()).getPath();
            } else {
                string = file.getPath();
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createNamingContext() throws NamingException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Hashtable hashtable = new Hashtable();
        NamingContext namingContext = new NamingContext(hashtable, this.getNamingContextName());
        ContextAccessController.setSecurityToken(this.getNamingContextName(), this);
        ContextBindings.bindContext(this, namingContext, this);
        ContextBindings.bindThread(this, this);
        ContextAccessController.setWritable(this.getNamingContextName(), this);
        javax.naming.Context context = namingContext.createSubcontext("comp");
        javax.naming.Context context2 = context.createSubcontext("env");
        Iterator iterator = this.envs.values().iterator();
        while (iterator.hasNext()) {
            object4 = (ContextEnvironment)iterator.next();
            object3 = null;
            object2 = ((ContextEnvironment)object4).getType();
            try {
                if (((String)object2).equals("java.lang.String")) {
                    object3 = ((ContextEnvironment)object4).getValue();
                } else if (((String)object2).equals("java.lang.Byte")) {
                    object3 = Byte.decode(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Short")) {
                    object3 = Short.decode(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Integer")) {
                    object3 = Integer.decode(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Long")) {
                    object3 = Long.decode(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Boolean")) {
                    object3 = Boolean.valueOf(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Double")) {
                    object3 = Double.valueOf(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Float")) {
                    object3 = Float.valueOf(((ContextEnvironment)object4).getValue());
                } else if (((String)object2).equals("java.lang.Character")) {
                    if (((ContextEnvironment)object4).getValue().length() != 1) throw new IllegalArgumentException();
                    object3 = new Character(((ContextEnvironment)object4).getValue().charAt(0));
                } else {
                    this.log(sm.getString("standardContext.invalidEnvEntryType", ((ContextEnvironment)object4).getName()), 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("standardContext.invalidEnvEntryValue", ((ContextEnvironment)object4).getName()), 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log(sm.getString("standardContext.invalidEnvEntryValue", ((ContextEnvironment)object4).getName()), 1);
            }
            if (object3 == null) continue;
            try {
                this.createSubcontexts(context2, ((ContextEnvironment)object4).getName());
                context2.bind(((ContextEnvironment)object4).getName(), object3);
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.invalidEnvEntryValue", namingException), namingException);
            }
        }
        object4 = this.ejbs.values().iterator();
        while (object4.hasNext()) {
            object3 = (ContextEjb)object4.next();
            object2 = new EjbRef(((ContextEjb)object3).getType(), ((ContextEjb)object3).getHome(), ((ContextEjb)object3).getRemote(), ((ContextEjb)object3).getLink());
            this.addAdditionalParameters((Reference)object2, ((ContextEjb)object3).getName());
            try {
                this.createSubcontexts(context2, ((ContextEjb)object3).getName());
                context2.bind(((ContextEjb)object3).getName(), object2);
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.bindFailed", namingException), namingException);
            }
        }
        object3 = this.resources.values().iterator();
        while (object3.hasNext()) {
            object2 = (ContextResource)object3.next();
            object = new ResourceRef(((ContextResource)object2).getType(), ((ContextResource)object2).getDescription(), ((ContextResource)object2).getScope(), ((ContextResource)object2).getAuth());
            this.addAdditionalParameters((Reference)object, ((ContextResource)object2).getName());
            try {
                this.createSubcontexts(context2, ((ContextResource)object2).getName());
                context2.bind(((ContextResource)object2).getName(), object);
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.bindFailed", namingException), namingException);
            }
        }
        object2 = this.resourceEnvRefs.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            String string = (String)this.resourceEnvRefs.get(object);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef(string);
            this.addAdditionalParameters(resourceEnvRef, (String)object);
            try {
                this.createSubcontexts(context2, (String)object);
                context2.bind((String)object, (Object)resourceEnvRef);
            }
            catch (NamingException namingException) {
                this.log(sm.getString("standardContext.bindFailed", namingException), namingException);
            }
        }
        try {
            object = new TransactionRef();
            context.bind("UserTransaction", object);
            this.addAdditionalParameters((Reference)object, "UserTransaction");
        }
        catch (NamingException namingException) {
            this.log(sm.getString("standardContext.bindFailed", namingException), namingException);
        }
        try {
            context.bind("Resources", (Object)this.getResources());
        }
        catch (NamingException namingException) {
            this.log(sm.getString("standardContext.bindFailed", namingException), namingException);
        }
        ContextAccessController.setReadOnly(this.getNamingContextName());
        ContextBindings.unbindThread(this, this);
        ContextBindings.bindClassLoader(this, this, this.getLoader().getClassLoader());
    }

    protected String getNamingContextName() {
        if (this.namingContextName == null) {
            Container container = this.getParent();
            if (container == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stack = new Stack<String>();
                StringBuffer stringBuffer = new StringBuffer();
                while (container != null) {
                    stack.push(container.getName());
                    container = container.getParent();
                }
                while (!stack.empty()) {
                    stringBuffer.append("/" + stack.pop());
                }
                stringBuffer.append(this.getName());
                this.namingContextName = stringBuffer.toString();
            }
            this.namingContextName = this.namingContextName + instanceIDCounter++;
        }
        return this.namingContextName;
    }

    private void createSubcontexts(javax.naming.Context context, String string) throws NamingException {
        javax.naming.Context context2 = context;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("") || !stringTokenizer.hasMoreTokens()) continue;
            try {
                context2 = context2.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                context2 = (javax.naming.Context)context2.lookup(string2);
            }
        }
    }

    private void addAdditionalParameters(Reference reference, String string) {
        ResourceParams resourceParams = (ResourceParams)this.resourceParams.get(string);
        if (resourceParams == null) {
            return;
        }
        Hashtable hashtable = resourceParams.getParameters();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            StringRefAddr stringRefAddr = new StringRefAddr(string2, string3);
            reference.add(stringRefAddr);
        }
    }

    private boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
    }

    private void postWelcomeFiles() {
        this.getServletContext().setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
    }

    private void postWorkDirectory() {
        String string;
        Object object;
        Object object2;
        String string2 = this.getWorkDir();
        if (string2 == null) {
            Object object3;
            object2 = null;
            object = null;
            string = null;
            Container container = this.getParent();
            if (container != null) {
                object2 = container.getName();
                if (container instanceof StandardHost) {
                    string = ((StandardHost)container).getWorkDir();
                }
                if ((object3 = container.getParent()) != null) {
                    object = object3.getName();
                }
            }
            if (object2 == null || ((String)object2).length() < 1) {
                object2 = "_";
            }
            if (object == null || ((String)object).length() < 1) {
                object = "_";
            }
            if (((String)(object3 = this.getPath())).startsWith("/")) {
                object3 = ((String)object3).substring(1);
            }
            object3 = ((String)object3).replace('/', '_');
            if (((String)(object3 = ((String)object3).replace('\\', '_'))).length() < 1) {
                object3 = "_";
            }
            string2 = string != null ? string + File.separator + (String)object3 : "work" + File.separator + (String)object + File.separator + (String)object2 + File.separator + (String)object3;
            this.setWorkDir(string2);
        }
        if (!((File)(object2 = new File(string2))).isAbsolute()) {
            object = new File(System.getProperty("catalina.base"));
            string = null;
            try {
                string = ((File)object).getCanonicalPath();
                object2 = new File(string, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ((File)object2).mkdirs();
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", object2);
        if (this.getServletContext() instanceof ApplicationContext) {
            ((ApplicationContext)this.getServletContext()).setAttributeReadOnly("javax.servlet.context.tempdir");
        }
    }

    private void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean validateURLPattern(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("*.")) {
            return string.indexOf(47) < 0;
        }
        return string.startsWith("/");
    }
}

