/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.SetAuthConstraint;
import org.apache.catalina.startup.SetDistributableAction;
import org.apache.catalina.startup.SetPublicIdAction;
import org.apache.catalina.startup.WrapperCreate;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.xml.XmlMapper;
import org.xml.sax.SAXParseException;

public final class ContextConfig
implements LifecycleListener {
    private static ResourceBundle authenticators = null;
    private Context context = null;
    private int debug = 0;
    private boolean ok = false;
    private String defaultWebXml = "conf/web.xml";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String string) {
        this.defaultWebXml = string;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            int n;
            this.context = (Context)((Object)lifecycleEvent.getLifecycle());
            if (this.context instanceof StandardContext && (n = ((StandardContext)this.context).getDebug()) > this.debug) {
                this.debug = n;
            }
        }
        catch (ClassCastException classCastException) {
            this.log(sm.getString("contextConfig.cce", lifecycleEvent.getLifecycle()), classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void applicationConfig(XmlMapper xmlMapper) {
        block19: {
            InputStream inputStream = null;
            ServletContext servletContext = this.context.getServletContext();
            if (servletContext != null) {
                String string = null;
                string = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
                if (string != null) {
                    try {
                        inputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log(sm.getString("contextConfig.altDDNotFound", string), 1);
                    }
                } else {
                    inputStream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                }
            }
            if (inputStream == null) {
                this.log(sm.getString("contextConfig.applicationMissing"));
                return;
            }
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setReplaceWelcomeFiles(true);
            }
            xmlMapper.readXml(inputStream, (Object)this.context);
            Object var7_9 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.log(sm.getString("contextConfig.applicationClose"), iOException);
            }
            break block19;
            {
                catch (InvocationTargetException invocationTargetException) {
                    this.log(sm.getString("contextConfig.applicationConfig"), invocationTargetException.getTargetException());
                    this.ok = false;
                    Object var7_10 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.applicationClose"), iOException);
                    }
                    break block19;
                }
                catch (SAXParseException sAXParseException) {
                    this.log(sm.getString("contextConfig.applicationParse"), sAXParseException);
                    this.log(sm.getString("contextConfig.applicationPosition", "" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()), 1);
                    this.ok = false;
                    Object var7_11 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.applicationClose"), iOException);
                    }
                    break block19;
                }
                catch (Exception exception) {
                    this.log(sm.getString("contextConfig.applicationParse"), exception);
                    this.ok = false;
                    Object var7_12 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.applicationClose"), iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.log(sm.getString("contextConfig.applicationClose"), iOException);
                }
                throw throwable;
            }
        }
    }

    private synchronized void authenticatorConfig() {
        Object object;
        SecurityConstraint[] securityConstraintArray;
        Object object2;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            object2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (object2 != null) {
                securityConstraintArray = object2.getBasic();
                if (securityConstraintArray != null && securityConstraintArray instanceof Authenticator) {
                    return;
                }
                object = object2.getValves();
                for (int i = 0; i < ((Valve[])object).length; ++i) {
                    if (!(object[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        object2 = this.context.getRealm();
        if (object2 == null) {
            this.log(sm.getString("contextConfig.missingRealm"), 1);
            this.ok = false;
            return;
        }
        object2.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        securityConstraintArray = this.context.findConstraints();
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            return;
        }
        if (authenticators == null) {
            try {
                authenticators = ResourceBundle.getBundle("org.apache.catalina.startup.Authenticators");
            }
            catch (MissingResourceException missingResourceException) {
                this.log(sm.getString("contextConfig.authenticatorResources"), missingResourceException);
                this.ok = false;
                return;
            }
        }
        object = null;
        String string = loginConfig.getAuthMethod();
        if (string == null) {
            string = "NONE";
        }
        try {
            object = authenticators.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            object = null;
        }
        if (object == null) {
            this.log(sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()), 1);
            this.ok = false;
            return;
        }
        Valve valve = null;
        try {
            Pipeline pipeline;
            Class<?> clazz = Class.forName((String)object);
            valve = (Valve)clazz.newInstance();
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                pipeline.addValve(valve);
                this.log(sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
        catch (Throwable throwable) {
            this.log(sm.getString("contextConfig.authenticatorInstantiate", object), throwable);
            this.ok = false;
        }
    }

    private void certificatesConfig() {
        Object object;
        Object object2;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("javax.net.ssl.SSLSocket");
            if (clazz == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
        boolean bl = false;
        if (this.context instanceof Context && (object2 = this.context.getLoginConfig()) != null && "CLIENT-CERT".equalsIgnoreCase((String)(object = ((LoginConfig)object2).getAuthMethod()))) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        object2 = null;
        try {
            object = Class.forName("com.iplanet.ias.web.connector.nsapi.NSAPICertificatesValve");
            object2 = (Valve)((Class)object).newInstance();
        }
        catch (Throwable throwable) {
            return;
        }
        try {
            if (this.context instanceof ContainerBase && (object = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                object.addValve((Valve)object2);
                this.log(sm.getString("contextConfig.certificatesConfig.added"));
            }
        }
        catch (Throwable throwable) {
            this.log(sm.getString("contextConfig.certificatesConfig.error"), throwable);
            this.ok = false;
        }
    }

    private XmlMapper createTldMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setValidating(true);
        xmlMapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
        xmlMapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
        xmlMapper.addRule("taglib/listener/listener-class", xmlMapper.methodSetter("addApplicationListener", 0));
        return xmlMapper;
    }

    private XmlMapper createWebMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setValidating(true);
        xmlMapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/javax/servlet/resources/web-app_2_2.dtd");
        xmlMapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/javax/servlet/resources/web-app_2_3.dtd");
        xmlMapper.addRule("web-app", new SetPublicIdAction("setPublicId"));
        xmlMapper.addRule("web-app/context-param", xmlMapper.methodSetter("addParameter", 2));
        xmlMapper.addRule("web-app/context-param/param-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/context-param/param-value", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/display-name", xmlMapper.methodSetter("setDisplayName", 0));
        xmlMapper.addRule("web-app/distributable", new SetDistributableAction());
        xmlMapper.addRule("web-app/ejb-local-ref", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextLocalEjb"));
        xmlMapper.addRule("web-app/ejb-local-ref", xmlMapper.addChild("addLocalEjb", "org.apache.catalina.deploy.ContextLocalEjb"));
        xmlMapper.addRule("web-app/ejb-local-ref/description", xmlMapper.methodSetter("setDescription", 0));
        xmlMapper.addRule("web-app/ejb-local-ref/ejb-ref-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/ejb-local-ref/ejb-ref-type", xmlMapper.methodSetter("setType", 0));
        xmlMapper.addRule("web-app/ejb-local-ref/local-home", xmlMapper.methodSetter("setHome", 0));
        xmlMapper.addRule("web-app/ejb-local-ref/local", xmlMapper.methodSetter("setLocal", 0));
        xmlMapper.addRule("web-app/ejb-local-ref/ejb-link", xmlMapper.methodSetter("setLink", 0));
        xmlMapper.addRule("web-app/ejb-ref", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextEjb"));
        xmlMapper.addRule("web-app/ejb-ref", xmlMapper.addChild("addEjb", "org.apache.catalina.deploy.ContextEjb"));
        xmlMapper.addRule("web-app/ejb-ref/description", xmlMapper.methodSetter("setDescription", 0));
        xmlMapper.addRule("web-app/ejb-ref/ejb-ref-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/ejb-ref/ejb-ref-type", xmlMapper.methodSetter("setType", 0));
        xmlMapper.addRule("web-app/ejb-ref/home", xmlMapper.methodSetter("setHome", 0));
        xmlMapper.addRule("web-app/ejb-ref/remote", xmlMapper.methodSetter("setRemote", 0));
        xmlMapper.addRule("web-app/ejb-ref/ejb-link", xmlMapper.methodSetter("setLink", 0));
        xmlMapper.addRule("web-app/env-entry", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextEnvironment"));
        xmlMapper.addRule("web-app/env-entry", xmlMapper.addChild("addEnvironment", "org.apache.catalina.deploy.ContextEnvironment"));
        xmlMapper.addRule("web-app/env-entry/env-entry-description", xmlMapper.methodSetter("setDescription", 0));
        xmlMapper.addRule("web-app/env-entry/env-entry-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/env-entry/env-entry-type", xmlMapper.methodSetter("setType", 0));
        xmlMapper.addRule("web-app/env-entry/env-entry-value", xmlMapper.methodSetter("setValue", 0));
        xmlMapper.addRule("web-app/error-page", xmlMapper.objectCreate("org.apache.catalina.deploy.ErrorPage"));
        xmlMapper.addRule("web-app/error-page", xmlMapper.addChild("addErrorPage", "org.apache.catalina.deploy.ErrorPage"));
        xmlMapper.addRule("web-app/error-page/error-code", xmlMapper.methodSetter("setErrorCode", 0));
        xmlMapper.addRule("web-app/error-page/exception-type", xmlMapper.methodSetter("setExceptionType", 0));
        xmlMapper.addRule("web-app/error-page/location", xmlMapper.methodSetter("setLocation", 0));
        xmlMapper.addRule("web-app/filter", xmlMapper.objectCreate("org.apache.catalina.deploy.FilterDef"));
        xmlMapper.addRule("web-app/filter", xmlMapper.addChild("addFilterDef", "org.apache.catalina.deploy.FilterDef"));
        xmlMapper.addRule("web-app/filter/description", xmlMapper.methodSetter("setDescription", 0));
        xmlMapper.addRule("web-app/filter/display-name", xmlMapper.methodSetter("setDisplayName", 0));
        xmlMapper.addRule("web-app/filter/filter-class", xmlMapper.methodSetter("setFilterClass", 0));
        xmlMapper.addRule("web-app/filter/filter-name", xmlMapper.methodSetter("setFilterName", 0));
        xmlMapper.addRule("web-app/filter/icon/large-icon", xmlMapper.methodSetter("setLargeIcon", 0));
        xmlMapper.addRule("web-app/filter/icon/small-icon", xmlMapper.methodSetter("setSmallIcon", 0));
        xmlMapper.addRule("web-app/filter/init-param", xmlMapper.methodSetter("addInitParameter", 2));
        xmlMapper.addRule("web-app/filter/init-param/param-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/filter/init-param/param-value", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/filter-mapping", xmlMapper.objectCreate("org.apache.catalina.deploy.FilterMap"));
        xmlMapper.addRule("web-app/filter-mapping", xmlMapper.addChild("addFilterMap", "org.apache.catalina.deploy.FilterMap"));
        xmlMapper.addRule("web-app/filter-mapping/filter-name", xmlMapper.methodSetter("setFilterName", 0));
        xmlMapper.addRule("web-app/filter-mapping/servlet-name", xmlMapper.methodSetter("setServletName", 0));
        xmlMapper.addRule("web-app/filter-mapping/url-pattern", xmlMapper.methodSetter("setURLPattern", 0));
        xmlMapper.addRule("web-app/listener/listener-class", xmlMapper.methodSetter("addApplicationListener", 0));
        xmlMapper.addRule("web-app/login-config", xmlMapper.objectCreate("org.apache.catalina.deploy.LoginConfig"));
        xmlMapper.addRule("web-app/login-config", xmlMapper.addChild("setLoginConfig", "org.apache.catalina.deploy.LoginConfig"));
        xmlMapper.addRule("web-app/login-config/auth-method", xmlMapper.methodSetter("setAuthMethod", 0));
        xmlMapper.addRule("web-app/login-config/realm-name", xmlMapper.methodSetter("setRealmName", 0));
        xmlMapper.addRule("web-app/login-config/form-login-config/form-login-page", xmlMapper.methodSetter("setLoginPage", 0));
        xmlMapper.addRule("web-app/login-config/form-login-config/form-error-page", xmlMapper.methodSetter("setErrorPage", 0));
        xmlMapper.addRule("web-app/mime-mapping", xmlMapper.methodSetter("addMimeMapping", 2));
        xmlMapper.addRule("web-app/mime-mapping/extension", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/mime-mapping/mime-type", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/resource-env-ref", xmlMapper.methodSetter("addResourceEnvRef", 2));
        xmlMapper.addRule("web-app/resource-env-ref/resource-env-ref-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/resource-env-ref/resource-env-ref-type", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/resource-ref", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextResource"));
        xmlMapper.addRule("web-app/resource-ref", xmlMapper.addChild("addResource", "org.apache.catalina.deploy.ContextResource"));
        xmlMapper.addRule("web-app/resource-ref/description", xmlMapper.methodSetter("setDescription", 0));
        xmlMapper.addRule("web-app/resource-ref/res-auth", xmlMapper.methodSetter("setAuth", 0));
        xmlMapper.addRule("web-app/resource-ref/res-ref-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/resource-ref/res-sharing-scope", xmlMapper.methodSetter("setScope", 0));
        xmlMapper.addRule("web-app/resource-ref/res-type", xmlMapper.methodSetter("setType", 0));
        xmlMapper.addRule("web-app/security-constraint", xmlMapper.objectCreate("org.apache.catalina.deploy.SecurityConstraint"));
        xmlMapper.addRule("web-app/security-constraint", xmlMapper.addChild("addConstraint", "org.apache.catalina.deploy.SecurityConstraint"));
        xmlMapper.addRule("web-app/security-constraint/auth-constraint", new SetAuthConstraint());
        xmlMapper.addRule("web-app/security-constraint/auth-constraint/role-name", xmlMapper.methodSetter("addAuthRole", 0));
        xmlMapper.addRule("web-app/security-constraint/display-name", xmlMapper.methodSetter("setDisplayName", 0));
        xmlMapper.addRule("web-app/security-constraint/user-data-constraint/transport-guarantee", xmlMapper.methodSetter("setUserConstraint", 0));
        xmlMapper.addRule("web-app/security-constraint/web-resource-collection", xmlMapper.objectCreate("org.apache.catalina.deploy.SecurityCollection"));
        xmlMapper.addRule("web-app/security-constraint/web-resource-collection", xmlMapper.addChild("addCollection", "org.apache.catalina.deploy.SecurityCollection"));
        xmlMapper.addRule("web-app/security-constraint/web-resource-collection/http-method", xmlMapper.methodSetter("addMethod", 0));
        xmlMapper.addRule("web-app/security-constraint/web-resource-collection/url-pattern", xmlMapper.methodSetter("addPattern", 0));
        xmlMapper.addRule("web-app/security-constraint/web-resource-collection/web-resource-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/security-role", xmlMapper.methodSetter("addSecurityRole", 1));
        xmlMapper.addRule("web-app/security-role/role-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/servlet", new WrapperCreate(this.context));
        xmlMapper.addRule("web-app/servlet", xmlMapper.addChild("addChild", "org.apache.catalina.Container"));
        xmlMapper.addRule("web-app/servlet/init-param", xmlMapper.methodSetter("addInitParameter", 2));
        xmlMapper.addRule("web-app/servlet/init-param/param-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/servlet/init-param/param-value", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/servlet/jsp-file", xmlMapper.methodSetter("setJspFile", 0));
        xmlMapper.addRule("web-app/servlet/load-on-startup", xmlMapper.methodSetter("setLoadOnStartupString", 0));
        xmlMapper.addRule("web-app/servlet/run-as/role-name", xmlMapper.methodSetter("setRunAs", 0));
        xmlMapper.addRule("web-app/servlet/security-role-ref", xmlMapper.methodSetter("addSecurityReference", 2));
        xmlMapper.addRule("web-app/servlet/security-role-ref/role-link", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/servlet/security-role-ref/role-name", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/servlet/servlet-class", xmlMapper.methodSetter("setServletClass", 0));
        xmlMapper.addRule("web-app/servlet/servlet-name", xmlMapper.methodSetter("setName", 0));
        xmlMapper.addRule("web-app/servlet-mapping", xmlMapper.methodSetter("addServletMapping", 2));
        xmlMapper.addRule("web-app/servlet-mapping/servlet-name", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/servlet-mapping/url-pattern", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/session-config", xmlMapper.methodSetter("setSessionTimeout", 1, new String[]{"int"}));
        xmlMapper.addRule("web-app/session-config/session-timeout", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/taglib", xmlMapper.methodSetter("addTaglib", 2));
        xmlMapper.addRule("web-app/taglib/taglib-location", xmlMapper.methodParam(1));
        xmlMapper.addRule("web-app/taglib/taglib-uri", xmlMapper.methodParam(0));
        xmlMapper.addRule("web-app/welcome-file-list/welcome-file", xmlMapper.methodSetter("addWelcomeFile", 0));
        return xmlMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void defaultConfig(XmlMapper xmlMapper) {
        block17: {
            File file = new File(this.defaultWebXml);
            if (!file.isAbsolute()) {
                file = new File(System.getProperty("catalina.base"), this.defaultWebXml);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file.getCanonicalPath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log(sm.getString("contextConfig.defaultMissing"), 1);
                return;
            }
            catch (IOException iOException) {
                this.log(sm.getString("contextConfig.defaultMissing"), iOException);
                return;
            }
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setReplaceWelcomeFiles(true);
            }
            xmlMapper.readXml(fileInputStream, (Object)this.context);
            Object var6_9 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.log(sm.getString("contextConfig.defaultClose"), iOException);
            }
            break block17;
            {
                catch (InvocationTargetException invocationTargetException) {
                    this.log(sm.getString("contextConfig.defaultConfig"), invocationTargetException.getTargetException());
                    this.ok = false;
                    Object var6_10 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.defaultClose"), iOException);
                    }
                    break block17;
                }
                catch (SAXParseException sAXParseException) {
                    this.log(sm.getString("contextConfig.defaultParse"), sAXParseException);
                    this.log(sm.getString("contextConfig.defaultPosition", "" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()), 1);
                    this.ok = false;
                    Object var6_11 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.defaultClose"), iOException);
                    }
                    break block17;
                }
                catch (Exception exception) {
                    this.log(sm.getString("contextConfig.defaultParse"), exception);
                    this.ok = false;
                    Object var6_12 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("contextConfig.defaultClose"), iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.log(sm.getString("contextConfig.defaultClose"), iOException);
                }
                throw throwable;
            }
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + string);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + string);
        }
    }

    private void log(String string, int n) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + string, n);
        } else {
            this.log(string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + string, throwable);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private synchronized void start() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.start"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        XmlMapper xmlMapper = this.createWebMapper();
        this.defaultConfig(xmlMapper);
        this.applicationConfig(xmlMapper);
        if (this.ok) {
            this.tldConfig();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.debug >= 1 && this.context instanceof ContainerBase) {
            this.log("Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valveArray = null;
            if (pipeline != null) {
                valveArray = pipeline.getValves();
            }
            if (valveArray != null) {
                for (int i = 0; i < valveArray.length; ++i) {
                    this.log("  " + valveArray[i].getInfo());
                }
            }
            this.log("======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            this.log(sm.getString("contextConfig.unavailable"), 1);
            this.context.setConfigured(false);
        }
    }

    private synchronized void stop() {
        int n;
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.stop"));
        }
        Container[] containerArray = this.context.findChildren();
        for (n = 0; n < containerArray.length; ++n) {
            this.context.removeChild(containerArray[n]);
        }
        String[] stringArray = this.context.findApplicationListeners();
        for (n = 0; n < stringArray.length; ++n) {
            this.context.removeApplicationListener(stringArray[n]);
        }
        ApplicationParameter[] applicationParameterArray = this.context.findApplicationParameters();
        for (n = 0; n < applicationParameterArray.length; ++n) {
            this.context.removeApplicationParameter(applicationParameterArray[n].getName());
        }
        SecurityConstraint[] securityConstraintArray = this.context.findConstraints();
        for (n = 0; n < securityConstraintArray.length; ++n) {
            this.context.removeConstraint(securityConstraintArray[n]);
        }
        ContextEjb[] contextEjbArray = this.context.findEjbs();
        for (n = 0; n < contextEjbArray.length; ++n) {
            this.context.removeEjb(contextEjbArray[n].getName());
        }
        ContextEnvironment[] contextEnvironmentArray = this.context.findEnvironments();
        for (n = 0; n < contextEnvironmentArray.length; ++n) {
            this.context.removeEnvironment(contextEnvironmentArray[n].getName());
        }
        ErrorPage[] errorPageArray = this.context.findErrorPages();
        for (n = 0; n < errorPageArray.length; ++n) {
            this.context.removeErrorPage(errorPageArray[n]);
        }
        FilterDef[] filterDefArray = this.context.findFilterDefs();
        for (n = 0; n < filterDefArray.length; ++n) {
            this.context.removeFilterDef(filterDefArray[n]);
        }
        FilterMap[] filterMapArray = this.context.findFilterMaps();
        for (n = 0; n < filterMapArray.length; ++n) {
            this.context.removeFilterMap(filterMapArray[n]);
        }
        String[] stringArray2 = this.context.findInstanceListeners();
        for (n = 0; n < stringArray2.length; ++n) {
            this.context.removeInstanceListener(stringArray2[n]);
        }
        ContextLocalEjb[] contextLocalEjbArray = this.context.findLocalEjbs();
        for (n = 0; n < contextLocalEjbArray.length; ++n) {
            this.context.removeLocalEjb(contextLocalEjbArray[n].getName());
        }
        String[] stringArray3 = this.context.findMimeMappings();
        for (n = 0; n < stringArray3.length; ++n) {
            this.context.removeMimeMapping(stringArray3[n]);
        }
        String[] stringArray4 = this.context.findParameters();
        for (n = 0; n < stringArray4.length; ++n) {
            this.context.removeParameter(stringArray4[n]);
        }
        String[] stringArray5 = this.context.findResourceEnvRefs();
        for (n = 0; n < stringArray5.length; ++n) {
            this.context.removeResourceEnvRef(stringArray5[n]);
        }
        ContextResource[] contextResourceArray = this.context.findResources();
        for (n = 0; n < contextResourceArray.length; ++n) {
            this.context.removeResource(contextResourceArray[n].getName());
        }
        String[] stringArray6 = this.context.findSecurityRoles();
        for (n = 0; n < stringArray6.length; ++n) {
            this.context.removeSecurityRole(stringArray6[n]);
        }
        String[] stringArray7 = this.context.findServletMappings();
        for (n = 0; n < stringArray7.length; ++n) {
            this.context.removeServletMapping(stringArray7[n]);
        }
        String[] stringArray8 = this.context.findTaglibs();
        for (n = 0; n < stringArray8.length; ++n) {
            this.context.removeTaglib(stringArray8[n]);
        }
        String[] stringArray9 = this.context.findWelcomeFiles();
        for (n = 0; n < stringArray9.length; ++n) {
            this.context.removeWelcomeFile(stringArray9[n]);
        }
        String[] stringArray10 = this.context.findWrapperLifecycles();
        for (n = 0; n < stringArray10.length; ++n) {
            this.context.removeWrapperLifecycle(stringArray10[n]);
        }
        String[] stringArray11 = this.context.findWrapperListeners();
        for (n = 0; n < stringArray11.length; ++n) {
            this.context.removeWrapperListener(stringArray11[n]);
        }
        this.ok = true;
    }

    private void tldConfig() {
        String string;
        XmlMapper xmlMapper = this.createTldMapper();
        if (this.debug >= 1) {
            this.log("Scanning web.xml tag libraries");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.context.findTaglibs();
        for (int i = 0; i < stringArray.length; ++i) {
            string = this.context.findTaglib(stringArray[i]);
            if (!string.startsWith("/")) {
                string = "/WEB-INF/web.xml/../" + string;
            }
            if (this.debug >= 2) {
                this.log("  URI='" + stringArray[i] + "', ResourcePath='" + string + "'");
            }
            if (arrayList.contains(string)) {
                if (this.debug < 2) continue;
                this.log("    Already processed");
                continue;
            }
            arrayList.add(string);
            if (this.tldConfigJar(string, xmlMapper)) continue;
            this.tldConfigTld(string, xmlMapper);
        }
        DirContext dirContext = this.context.getResources();
        if (this.debug >= 1) {
            this.log("Scanning library JAR files");
        }
        string = "/WEB-INF/lib";
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list(string);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string2 = string + "/" + nameClassPair.getName();
                if (!string2.endsWith(".jar")) continue;
                this.tldConfigJar(string2, xmlMapper);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean tldConfigJar(String string, XmlMapper xmlMapper) {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            URL uRL = this.context.getServletContext().getResource(string);
            if (uRL == null) {
                return false;
            }
            uRL = new URL("jar:" + uRL.toString() + "!/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            zipFile = jarURLConnection.getJarFile();
            boolean bl = false;
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.startsWith("META-INF/") || !string2.endsWith(".tld")) continue;
                if (this.debug >= 2) {
                    this.log("    tldConfigJar(" + string + "): Processing entry '" + string2 + "'");
                }
                inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                xmlMapper.readXml(inputStream, (Object)this.context);
                inputStream.close();
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            if (this.debug >= 2) {
                this.log("    tldConfigJar(" + string + "): " + exception);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private boolean tldConfigTld(String string, XmlMapper xmlMapper) {
        InputStream inputStream = null;
        try {
            inputStream = this.context.getServletContext().getResourceAsStream(string);
            if (inputStream == null) {
                return false;
            }
            xmlMapper.readXml(inputStream, (Object)this.context);
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            if (this.debug >= 2) {
                this.log("    tldConfigTld(" + string + "): " + exception);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

