/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class Embedded
implements Lifecycle {
    protected int debug = 0;
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        boolean bl2 = this.useNaming;
        this.useNaming = bl;
        this.support.firePropertyChange("useNaming", new Boolean(bl2), new Boolean(this.useNaming));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger logger2 = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", logger2, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm realm2 = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    public synchronized void addEngine(Engine engine) {
        if (this.debug >= 1) {
            this.logger.log("Adding engine (" + engine.getInfo() + ")");
        }
        Engine[] engineArray = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            engineArray[i] = this.engines[i];
        }
        engineArray[this.engines.length] = engine;
        this.engines = engineArray;
        if (this.started && engine instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.start", lifecycleException);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public Context createContext(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating context '" + string + "' with docBase '" + string2 + "'");
        }
        StandardContext standardContext = new StandardContext();
        standardContext.setDebug(this.debug);
        standardContext.setDocBase(string2);
        standardContext.setPath(string);
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setDebug(this.debug);
        standardContext.addLifecycleListener(contextConfig);
        return standardContext;
    }

    public Engine createEngine() {
        if (this.debug >= 1) {
            this.logger.log("Creating engine");
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setDebug(this.debug);
        standardEngine.setLogger(this.logger);
        standardEngine.setRealm(this.realm);
        return standardEngine;
    }

    public Host createHost(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating host '" + string + "' with appBase '" + string2 + "'");
        }
        StandardHost standardHost = new StandardHost();
        standardHost.setAppBase(string2);
        standardHost.setDebug(this.debug);
        standardHost.setName(string);
        return standardHost;
    }

    public Loader createLoader(ClassLoader classLoader) {
        if (this.debug >= 1) {
            this.logger.log("Creating Loader with parent class loader '" + classLoader + "'");
        }
        WebappLoader webappLoader = new WebappLoader(classLoader);
        return webappLoader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeContext(Context context) {
        if (this.debug >= 1) {
            this.logger.log("Removing context[" + context.getPath() + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                Container[] containerArray2 = containerArray[j].findChildren();
                for (int k = 0; k < containerArray2.length; ++k) {
                    if (context != (Context)containerArray2[k]) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        int n;
        if (this.debug >= 1) {
            this.logger.log("Removing engine (" + engine.getInfo() + ")");
        }
        int n2 = -1;
        for (n = 0; n < this.engines.length; ++n) {
            if (engine != this.engines[n]) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return;
        }
        if (engine instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.stop", lifecycleException);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Engine");
        }
        n = 0;
        Engine[] engineArray = new Engine[this.engines.length - 1];
        for (int i = 0; i < this.engines.length; ++i) {
            if (i == n2) continue;
            engineArray[n++] = this.engines[i];
        }
        this.engines = engineArray;
    }

    public synchronized void removeHost(Host host) {
        if (this.debug >= 1) {
            this.logger.log("Removing host[" + host.getName() + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                if (host != (Host)containerArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        String string;
        if (this.debug >= 1) {
            this.logger.log("Starting embedded server");
        }
        if (System.getProperty("catalina.home") == null) {
            string = System.getProperty("com.sun.enterprise.home");
            if (string != null) {
                System.setProperty("catalina.home", System.getProperty("com.sun.enterprise.home"));
            } else {
                throw new LifecycleException("Must set 'catalina.home' system property");
            }
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("embedded.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (!this.useNaming) {
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                string = string2 + ":" + string;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            string = System.getProperty("java.naming.factory.initial");
            if (string == null || string.length() < 1) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
            if (this.debug > 0) {
                this.logger.log("Naming prefixes property is set to: " + System.getProperty("java.naming.factory.url.pkgs"));
                this.logger.log("Naming initial context factory property is set to: " + System.getProperty("java.naming.factory.initial"));
            }
        }
        for (int i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).start();
        }
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.logger.log("Stopping embedded server");
        }
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).stop();
        }
    }

    private static void customize(Context context) {
        String string = context.getPath();
        string = string.length() < 1 ? "ROOT" : string.substring(1);
    }
}

