/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.lang.reflect.Method;
import java.util.Stack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.XmlAction;

class MethodSetter
extends XmlAction {
    String mName;
    int paramC;
    String[] paramTypes;
    static final Class STRING_CLASS = "String".getClass();

    public MethodSetter(String string, int n) {
        this.mName = string;
        this.paramC = n;
    }

    public MethodSetter(String string, int n, String[] stringArray) {
        this.mName = string;
        this.paramC = n;
        this.paramTypes = stringArray;
    }

    public void start(SaxContext saxContext) {
        Stack stack = saxContext.getObjectStack();
        if (this.paramC == 0) {
            return;
        }
        String[] stringArray = new String[this.paramC];
        stack.push(stringArray);
    }

    public void end(SaxContext saxContext) throws Exception {
        Stack stack = saxContext.getObjectStack();
        String[] stringArray = null;
        if (this.paramC > 0) {
            stringArray = (String[])stack.pop();
        }
        Object e = stack.peek();
        if (this.paramC == 0) {
            stringArray = new String[]{saxContext.getBody().trim()};
            if (saxContext.getDebug() > 0) {
                saxContext.log("" + e.getClass().getName() + "." + this.mName + "( " + stringArray[0] + ")");
            }
        }
        Class[] classArray = new Class[stringArray.length];
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.paramTypes == null) {
                objectArray[i] = stringArray[i];
                classArray[i] = STRING_CLASS;
                continue;
            }
            if ("int".equals(this.paramTypes[i])) {
                objectArray[i] = new Integer(stringArray[i]);
                classArray[i] = Integer.TYPE;
                continue;
            }
            objectArray[i] = stringArray[i];
            classArray[i] = STRING_CLASS;
        }
        Method method = null;
        try {
            method = e.getClass().getMethod(this.mName, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            saxContext.log("Can't find method " + this.mName + " in " + e + " CLASS " + e.getClass());
            return;
        }
        method.invoke(e, objectArray);
        if (saxContext.getDebug() > 0 && this.paramC > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("" + e.getClass().getName() + "." + this.mName + "( ");
            for (int i = 0; i < this.paramC; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(")");
            saxContext.log(stringBuffer.toString());
        }
    }
}

