/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.MyErrorHandler;
import org.apache.jasper.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_XML = "%=";
    private static final String CLOSE_EXPR_XML = "%";
    private static ErrorHandler errorHandler = new MyErrorHandler();
    private static EntityResolver entityResolver = new MyEntityResolver();

    public static char[] removeQuotes(char[] cArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%' && cArray[i + 1] == '\\' && cArray[i + 2] == '>') {
                charArrayWriter.write(37);
                charArrayWriter.write(62);
                i += 2;
                continue;
            }
            charArrayWriter.write(cArray[i]);
        }
        return charArrayWriter.toCharArray();
    }

    public static char[] escapeQuotes(char[] cArray) {
        int n;
        String string = new String(cArray);
        while ((n = string.indexOf("%\\>")) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append(CLOSE_EXPR);
            stringBuffer.append(string.substring(n + 3));
            string = stringBuffer.toString();
        }
        cArray = string.toCharArray();
        return cArray;
    }

    public static boolean isExpression(String string, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = OPEN_EXPR_XML;
            string2 = CLOSE_EXPR_XML;
        } else {
            string3 = OPEN_EXPR;
            string2 = CLOSE_EXPR;
        }
        return string.startsWith(string3) && string.endsWith(string2);
    }

    public static String getExpr(String string, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = OPEN_EXPR_XML;
            string2 = CLOSE_EXPR_XML;
        } else {
            string3 = OPEN_EXPR;
            string2 = CLOSE_EXPR;
        }
        int n = string.length();
        String string4 = string.startsWith(string3) && string.endsWith(string2) ? string.substring(string3.length(), n - string2.length()) : "";
        return string4;
    }

    public static String getExprInXml(String string) {
        int n = string.length();
        String string2 = string.startsWith(OPEN_EXPR) && string.endsWith(CLOSE_EXPR) ? string.substring(1, n - 1) : string;
        return JspUtil.escapeXml(string2);
    }

    public static Document parseXMLDoc(String string, InputStream inputStream) throws JasperException {
        return JspUtil.parseXMLDocJaxp(string, inputStream);
    }

    public static Document parseXMLDocJaxp(String string, InputStream inputStream) throws JasperException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(entityResolver);
            documentBuilder.setErrorHandler(errorHandler);
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, parserConfigurationException.getMessage()}));
        }
        catch (SAXParseException sAXParseException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml.line", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()}));
        }
        catch (SAXException sAXException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, iOException.toString()}));
        }
    }

    public static void checkAttributes(String string, Attributes attributes, ValidAttribute[] validAttributeArray, Mark mark) throws JasperException {
        int n;
        boolean bl = true;
        int n2 = attributes.getLength();
        Vector<String> vector = new Vector<String>(n2, 1);
        for (int i = 0; i < n2; ++i) {
            vector.addElement(attributes.getQName(i));
        }
        String string2 = null;
        for (n = 0; n < validAttributeArray.length; ++n) {
            if (!validAttributeArray[n].mandatory) continue;
            int n3 = vector.indexOf(validAttributeArray[n].name);
            if (n3 != -1) {
                vector.remove(n3);
                bl = true;
                continue;
            }
            bl = false;
            string2 = validAttributeArray[n].name;
            break;
        }
        if (!bl) {
            throw new ParseException(mark, Constants.getString("jsp.error.mandatory.attribute", new Object[]{string, string2}));
        }
        n = vector.size();
        if (n == 0) {
            return;
        }
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            bl = false;
            string3 = (String)vector.elementAt(i);
            for (int j = 0; j < validAttributeArray.length; ++j) {
                if (!string3.equals(validAttributeArray[j].name)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new ParseException(mark, Constants.getString("jsp.error.invalid.attribute", new Object[]{string, string3}));
        }
    }

    public static String escapeQueryString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = "\\\"";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string3.indexOf(c) != -1) {
                string2 = string2 + "\\";
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Hashtable attrsToHashtable(Attributes attributes) {
        int n = attributes.getLength();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        for (int i = 0; i < n; ++i) {
            hashtable.put(attributes.getQName(i), attributes.getValue(i));
        }
        return hashtable;
    }

    public static String getElementChildTextData(Element element) {
        String string = null;
        Text text = (Text)element.getFirstChild();
        if (text != null && (string = text.getData()) != null) {
            string = string.trim();
        }
        return string;
    }

    public static boolean booleanValue(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("yes") ? true : Boolean.valueOf(string);
        }
        return bl;
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String string, boolean bl) {
            this.name = string;
            this.mandatory = bl;
        }

        public ValidAttribute(String string) {
            this(string, false);
        }
    }
}

