/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TreeNode {
    protected HashMap attributes = null;
    protected String body = null;
    protected ArrayList children = null;
    protected String name = null;
    protected TreeNode parent = null;

    public TreeNode(String string) {
        this(string, null);
    }

    public TreeNode(String string, TreeNode treeNode) {
        this.name = string;
        this.parent = treeNode;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public void addAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
    }

    public void addChild(TreeNode treeNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeNode);
    }

    public String findAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    public Iterator findAttributes() {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public TreeNode findChild(String string) {
        if (this.children == null) {
            return null;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (!string.equals(treeNode.getName())) continue;
            return treeNode;
        }
        return null;
    }

    public Iterator findChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.children.iterator();
    }

    public Iterator findChildren(String string) {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (!string.equals(treeNode.getName())) continue;
            arrayList.add(treeNode);
        }
        return arrayList.iterator();
    }

    public String getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public void removeAttribute(String string) {
        if (this.attributes != null) {
            this.attributes.remove(string);
        }
    }

    public void removeNode(TreeNode treeNode) {
        if (this.children != null) {
            this.children.remove(treeNode);
        }
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, 0, this);
        return stringBuffer.toString();
    }

    protected void toString(StringBuffer stringBuffer, int n, TreeNode treeNode) {
        String string;
        int n2 = n + 2;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('<');
        stringBuffer.append(treeNode.getName());
        Iterator iterator = treeNode.findAttributes();
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append("=\"");
            String string2 = treeNode.findAttribute(string);
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">\n");
        string = treeNode.getBody();
        if (string != null && string.length() > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        Iterator iterator2 = treeNode.findChildren();
        while (iterator2.hasNext()) {
            TreeNode treeNode2 = (TreeNode)iterator2.next();
            this.toString(stringBuffer, n2, treeNode2);
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("</");
        stringBuffer.append(treeNode.getName());
        stringBuffer.append(">\n");
    }
}

