/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import com.sun.appserv.server.util.PreprocessorUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    private String className = null;
    private ClassLoader parent = null;
    private SecurityManager securityManager = null;
    private PrivilegedLoadClass privLoadClass = null;

    public JasperLoader(URL[] uRLArray, String string, ClassLoader classLoader, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(uRLArray, classLoader);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.className = string;
        this.parent = classLoader;
        this.privLoadClass = new PrivilegedLoadClass();
        this.securityManager = System.getSecurityManager();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        int n = string.lastIndexOf(46);
        if (System.getSecurityManager() != null && n >= 0) {
            try {
                this.securityManager.checkPackageAccess(string.substring(0, n));
            }
            catch (SecurityException securityException) {
                String string2 = "Security Violation, attempt to use Restricted Class: " + string;
                throw new ClassNotFoundException(string2);
            }
        }
        if (!string.startsWith("_jsps")) {
            ClassLoader classLoader = null;
            classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(this.privLoadClass) : Thread.currentThread().getContextClassLoader();
            clazz = classLoader.loadClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (string.startsWith(this.className)) {
            String string3 = string.replace('.', '/') + ".class";
            byte[] byArray = this.loadClassDataFromFile(string3);
            if (byArray == null) {
                throw new ClassNotFoundException(string);
            }
            if (System.getSecurityManager() != null) {
                ProtectionDomain protectionDomain = new ProtectionDomain(this.codeSource, this.permissionCollection);
                clazz = this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
            } else {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }

    protected byte[] loadClassDataFromFile(String string) {
        byte[] byArray = null;
        try {
            InputStream inputStream = this.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            if (PreprocessorUtil.isPreprocessorEnabled()) {
                byArray = PreprocessorUtil.processClass(string, byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return byArray;
    }

    protected class PrivilegedLoadClass
    implements PrivilegedAction {
        PrivilegedLoadClass() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

