/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FastDateFormat
extends DateFormat {
    DateFormat df;
    long lastSec = -1L;
    StringBuffer sb = new StringBuffer();
    FieldPosition fp = new FieldPosition(8);

    public FastDateFormat(DateFormat dateFormat) {
        this.df = dateFormat;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return this.df.parse(string, parsePosition);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        long l = date.getTime();
        long l2 = l / 1000L;
        if (l2 != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = l2;
        } else {
            int n = (int)(l % 1000L);
            int n2 = this.fp.getEndIndex();
            int n3 = this.fp.getBeginIndex();
            if (n2 > 0) {
                if (n2 > n3) {
                    this.sb.setCharAt(--n2, Character.forDigit(n % 10, 10));
                }
                n /= 10;
                if (n2 > n3) {
                    this.sb.setCharAt(--n2, Character.forDigit(n % 10, 10));
                }
                n /= 10;
                if (n2 > n3) {
                    this.sb.setCharAt(--n2, Character.forDigit(n % 10, 10));
                }
            }
        }
        stringBuffer.append(this.sb.toString());
        return stringBuffer;
    }

    public static void main(String[] stringArray) {
        String string = "yyyy-MM-dd HH:mm:ss.SSS";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        FastDateFormat fastDateFormat = new FastDateFormat(simpleDateFormat);
        Date date = new Date();
        date.setTime(1L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(20L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(500L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(543L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(999L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(1050L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(2543L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(12345L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        date.setTime(12340L);
        System.out.println(fastDateFormat.format(date) + "\t" + simpleDateFormat.format(date));
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            date.setTime(System.currentTimeMillis());
            fastDateFormat.format(date);
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("fast: " + l2 + " elapsed");
        System.out.println(fastDateFormat.format(date));
        l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            date.setTime(System.currentTimeMillis());
            simpleDateFormat.format(date);
        }
        long l3 = System.currentTimeMillis() - l;
        System.out.println("slow: " + l3 + " elapsed");
        System.out.println(simpleDateFormat.format(date));
    }
}

