/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.servlets;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.servlets.AdminServlet;
import com.sun.web.admin.servlets.Auth;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CladdServlet
extends AdminServlet {
    private String webAppXmlFile;
    private String rHost;
    private int port;
    private String[] slaveInstance;
    private String masterHost;
    private String masterInstance = "";
    private int masterPort;
    private String protocol;
    private String userName;
    private String passwd;
    private static String instanceList = "--NewConfigFile:servers-instance.lst";
    private static String configBoundary = "--Config_File_Boundary--";
    String serverRoot;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void getExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.postExecute(httpSession, httpServletRequest, httpServletResponse);
    }

    protected void postExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        this.out = httpServletResponse.getWriter();
        try {
            String string;
            if (httpServletRequest.getParameter("requestType").equals("MODIFY") && (string = httpServletRequest.getParameter("slaveId")) == null) {
                this.returnError(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet5"), "clmod.jsp");
                return;
            }
            this.populate(httpServletRequest);
            string = this.process(httpServletRequest.getParameter("requestType"), httpServletRequest);
            this.writeToXmlFile((XmlNode)string, this.webAppXmlFile);
        }
        catch (Exception exception) {
            if (httpServletRequest.getParameter("requestType").equals("ADD")) {
                this.returnError(exception.getMessage(), "../bin/cladd60");
            } else if (httpServletRequest.getParameter("requestType").equals("MODIFY")) {
                this.returnError(exception.getMessage(), "clmod.jsp");
            } else if (httpServletRequest.getParameter("requestType").equals("REMOVE")) {
                this.returnError(exception.getMessage(), "clrem.jsp");
            }
            return;
        }
        if (httpServletRequest.getParameter("requestType").equals("ADD")) {
            this.returnSuccess(AdminConfig.getMessage((String)this.sRoot, (String)"SuccessCladdServlet1"), "../bin/cladd60", false);
        } else if (httpServletRequest.getParameter("requestType").equals("MODIFY")) {
            this.returnSuccess(AdminConfig.getMessage((String)this.sRoot, (String)"SuccessCladdServlet2"), "clmod.jsp", false);
        } else if (httpServletRequest.getParameter("requestType").equals("REMOVE")) {
            this.returnSuccess(AdminConfig.getMessage((String)this.sRoot, (String)"SuccessCladdServlet3"), "clrem.jsp", false);
        }
    }

    private void checkForNull(String string, String string2) throws ServletException {
        if (string == null || string.trim().equals("")) {
            throw new ServletException(string2);
        }
    }

    private XmlNode process(String string, HttpServletRequest httpServletRequest) throws Exception {
        File file = new File(this.webAppXmlFile);
        if (!file.isFile() && string.equals("ADD")) {
            String[] stringArray = this.getInstanceList(httpServletRequest.getParameter("instanceList"));
            String string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + "  ";
            }
            this.masterInstance = string2.trim();
            XmlNode xmlNode = this.formFreshNode();
            return xmlNode;
        }
        XmlConfig xmlConfig = new XmlConfig(this.webAppXmlFile);
        xmlConfig.setValidation(false);
        XmlNode xmlNode = xmlConfig.parseConfig();
        XmlNode xmlNode2 = xmlNode.findConfig("CLUSTER");
        Iterator iterator = xmlNode2.iterate("MASTER");
        XmlNode xmlNode3 = new XmlNode();
        while (iterator.hasNext()) {
            xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getString("hostname", "null").trim().equals(this.masterHost.trim()) || Integer.parseInt(xmlNode3.getString("adminport", "null").trim()) != this.masterPort) continue;
            this.masterInstance = xmlNode3.getString("instance", "null").trim();
            Iterator iterator2 = xmlNode3.iterate("SLAVE");
            XmlNode xmlNode4 = null;
            if (string.equals("ADD")) {
                xmlNode4 = this.populateNewNode(xmlNode3);
            }
            int n = 0;
            if (string.trim().equals("REMOVE")) {
                this.removeProcessing(xmlNode3, httpServletRequest, iterator2);
            } else {
                while (iterator2.hasNext()) {
                    ++n;
                    XmlNode xmlNode5 = (XmlNode)iterator2.next();
                    if (string.equals("ADD")) {
                        this.addProcessing(xmlNode5);
                        continue;
                    }
                    if (!string.equals("MODIFY")) continue;
                    this.modifyProcessing(xmlNode5, xmlNode3, httpServletRequest);
                }
            }
            if (!string.trim().equals("ADD")) continue;
            xmlNode4.addChild("id", "slave" + new Date().getTime(), "", 0);
            xmlNode3.addChild(xmlNode4);
        }
        return xmlNode2;
    }

    private void addProcessing(XmlNode xmlNode) throws ServletException {
        if (xmlNode.getString("hostname", "null").trim().equals(this.rHost)) {
            throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet1"));
        }
    }

    private String[] tokenizeArr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void modifyProcessing(XmlNode xmlNode, XmlNode xmlNode2, HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("slaveId");
        String string2 = httpServletRequest.getParameter("serverName");
        if (!string.equals(xmlNode.getString("id", "null").trim())) {
            return;
        }
        String string3 = xmlNode.getString("instance", "null").trim();
        this.slaveInstance = this.tokenizeArr(string3);
        int n = Integer.parseInt(httpServletRequest.getParameter("CL_NSERVER").trim());
        XmlNode xmlNode3 = this.populateNewNode(xmlNode2);
        if (this.rHost == null || this.rHost.trim().equals("")) {
            xmlNode3.addChild("hostname", xmlNode.getString("hostname", "null").trim(), "", 0);
        }
        if (this.port == 0) {
            xmlNode3.addChild("adminport", xmlNode.getString("adminport", "null").trim(), "", 0);
        }
        xmlNode3.addChild("transfer", xmlNode.getString("transfer", "null").trim(), "", 0);
        xmlNode3.addChild("substitute", xmlNode.getString("substitute", "null").trim(), "", 0);
        xmlNode3.addChild("id", xmlNode.getString("id", "null").trim(), "", 0);
        xmlNode2.removeChild(xmlNode);
        xmlNode2.addChild(xmlNode3);
    }

    private void removeProcessing(XmlNode xmlNode, HttpServletRequest httpServletRequest, Iterator iterator) {
        XmlNode xmlNode2;
        Vector<XmlNode> vector = new Vector<XmlNode>();
        while (iterator.hasNext()) {
            xmlNode2 = (XmlNode)iterator.next();
            int n = Integer.parseInt(httpServletRequest.getParameter("CL_NSERVER").trim());
            String string = httpServletRequest.getParameter(xmlNode2.getString("id", "null").trim());
            if (string == null) continue;
            vector.add(xmlNode2);
        }
        xmlNode2 = vector.elements();
        while (xmlNode2.hasMoreElements()) {
            xmlNode.removeChild((XmlNode)xmlNode2.nextElement());
        }
    }

    private XmlNode formFreshNode() {
        XmlNode xmlNode = new XmlNode(null, "CLUSTER", null, this.webAppXmlFile, 0);
        xmlNode.addChild("id", "CLUSTER0", "", 0);
        XmlNode xmlNode2 = new XmlNode(xmlNode, "MASTER", "", "", 0);
        xmlNode2.addChild("id", "master0", "", 0);
        xmlNode2.addChild("hostname", this.masterHost, "", 0);
        xmlNode2.addChild("adminport", "" + this.masterPort, "", 0);
        if (!this.masterInstance.trim().equals("")) {
            xmlNode2.addChild("instance", this.masterInstance, "", 0);
        }
        XmlNode xmlNode3 = new XmlNode(xmlNode2, "SLAVE", "", "", 0);
        xmlNode3.addChild("id", "slave0", "", 0);
        xmlNode3.addChild("hostname", this.rHost, "", 0);
        xmlNode3.addChild("adminport", "" + this.port, "", 0);
        xmlNode3.addChild("protocol", this.protocol, "", 0);
        String string = "";
        for (int i = 0; i < this.slaveInstance.length; ++i) {
            string = string + this.slaveInstance[i] + "  ";
        }
        if (!string.trim().equals("")) {
            xmlNode3.addChild("instance", string, "", 0);
        }
        xmlNode2.addChild(xmlNode3);
        xmlNode.addChild(xmlNode2);
        return xmlNode;
    }

    private XmlNode populateNewNode(XmlNode xmlNode) {
        XmlNode xmlNode2 = new XmlNode(xmlNode, "SLAVE", "", "", 0);
        if (this.rHost != null && !this.rHost.trim().equals("")) {
            xmlNode2.addChild("hostname", this.rHost, "", 0);
        }
        if (this.port != 0) {
            xmlNode2.addChild("adminport", "" + this.port, "", 0);
        }
        xmlNode2.addChild("protocol", this.protocol, "", 0);
        String string = "";
        for (int i = 0; i < this.slaveInstance.length; ++i) {
            string = string + this.slaveInstance[i] + "   ";
        }
        if (!string.trim().equals("")) {
            xmlNode2.addChild("instance", string, "", 0);
        }
        return xmlNode2;
    }

    private void populate(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        block9: {
            string = httpServletRequest.getParameter("INSTANCE_NAME");
            this.masterPort = httpServletRequest.getServerPort();
            this.masterHost = httpServletRequest.getServerName();
            try {
                this.userName = httpServletRequest.getParameter("userName").toString().trim();
                this.passwd = httpServletRequest.getParameter("passwd").toString().trim();
            }
            catch (Exception exception) {
                if (!httpServletRequest.getParameter("requestType").trim().equals("ADD")) break block9;
                throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet2"));
            }
        }
        this.webAppXmlFile = this.sRoot + "//" + string + "//config//cluster.xml";
        if (httpServletRequest.getParameter("requestType").trim().equals("REMOVE")) {
            return;
        }
        this.rHost = httpServletRequest.getParameter("rhost");
        this.protocol = httpServletRequest.getParameter("protocol");
        try {
            this.port = Integer.parseInt(httpServletRequest.getParameter("port").trim());
        }
        catch (Exception exception) {
            if (!httpServletRequest.getParameter("requestType").equals("ADD")) {
                this.port = 0;
            }
            throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet3"));
        }
        if (httpServletRequest.getParameter("requestType").equals("ADD")) {
            this.checkForNull(this.rHost, "rHost is not given");
            try {
                this.port = Integer.parseInt(httpServletRequest.getParameter("port").trim());
            }
            catch (Exception exception) {
                throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet3"));
            }
            this.slaveInstance = this.getInstanceList(httpServletRequest.getParameter("instanceList"));
        }
    }

    private String[] connect(String string, int n) throws ServletException {
        String[] stringArray = null;
        boolean bl = false;
        try {
            URL uRL = new URL("http://" + string + ":" + n + "//https-admserv//bin//clxfer?servers.lst");
            Authenticator.setDefault(new Auth(this.userName, this.passwd));
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Proxy-Connection", "keep-alive");
            ((HttpURLConnection)uRLConnection).setRequestMethod("GET");
            uRLConnection.setDoInput(true);
            uRLConnection.setAllowUserInteraction(false);
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.equals(instanceList)) continue;
                Vector<String> vector = new Vector<String>();
                string2 = bufferedReader.readLine();
                while (string2 != null && !string2.equals(configBoundary)) {
                    vector.add(string2);
                    string2 = bufferedReader.readLine();
                }
                stringArray = this.getStringArrayFromVector(vector);
                break;
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorCladdServlet4") + this.rHost + ":" + this.port);
        }
        return stringArray;
    }

    public final void writeToXmlFile(XmlNode xmlNode, String string) throws IOException {
        try {
            XmlNode xmlNode2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println();
            printWriter.print("<" + xmlNode.getName() + " ");
            XmlNode xmlNode3 = xmlNode.getFirstChild();
            printWriter.print(xmlNode3.getName() + "=\"" + xmlNode3.getValue() + "\" >");
            printWriter.println();
            Iterator iterator = xmlNode.iterate();
            while (iterator.hasNext()) {
                xmlNode2 = (XmlNode)iterator.next();
                if (!xmlNode2.getName().equals("MASTER")) continue;
                xmlNode2.save(printWriter);
            }
            iterator = xmlNode.iterate();
            while (iterator.hasNext()) {
                xmlNode2 = (XmlNode)iterator.next();
                if (!xmlNode2.getName().equals("SLAVE")) continue;
                xmlNode2.save(printWriter);
            }
            printWriter.println("</" + xmlNode.getName() + ">");
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            IOException iOException = new IOException(throwable.toString());
            throw iOException;
        }
    }

    private String[] getStringArrayFromVector(Vector vector) {
        Object[] objectArray = vector.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    private String[] getInstanceList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

