/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.servlets;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.servlets.AdminServlet;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class VarsServlet
extends AdminServlet {
    private String[] nameOfVars;
    private String[] valueOfVars;
    private String[] options;
    private Hashtable optionHash = new Hashtable();
    private Hashtable valueHash = new Hashtable();
    private int masterPort;
    private String masterHost;
    private String webAppXmlFile;
    private String slaveId;
    private static String ADD_OPTION = "add";
    private static String EDIT_OPTION = "edit";
    private static String DELETE_OPTION = "delete";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void getExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.postExecute(httpSession, httpServletRequest, httpServletResponse);
    }

    protected void postExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        this.out = httpServletResponse.getWriter();
        this.options = httpServletRequest.getParameterValues("Option");
        this.nameOfVars = httpServletRequest.getParameterValues("varname");
        this.valueOfVars = httpServletRequest.getParameterValues("value");
        this.slaveId = httpServletRequest.getParameter("slaveId");
        this.valueHash = this.getHashtable(this.nameOfVars, this.valueOfVars);
        this.optionHash = this.getHashtable(this.nameOfVars, this.options);
        this.populate(httpServletRequest);
        try {
            XmlNode xmlNode = this.process();
            this.writeToXmlFile(xmlNode, this.webAppXmlFile);
        }
        catch (Exception exception) {
            this.returnError(exception.getMessage(), "vars.jsp");
            return;
        }
        this.returnSuccess("The cluster file modified ", "vars.jsp?slaveId=" + this.slaveId);
    }

    private void checkForNull(String string, String string2) throws ServletException {
        if (string == null || string.trim().equals("")) {
            throw new ServletException(string2);
        }
    }

    private XmlNode process() throws Exception {
        XmlConfig xmlConfig = new XmlConfig(this.webAppXmlFile);
        xmlConfig.setValidation(false);
        XmlNode xmlNode = xmlConfig.parseConfig();
        XmlNode xmlNode2 = xmlNode.findConfig("CLUSTER");
        Iterator iterator = xmlNode2.iterate("MASTER");
        XmlNode xmlNode3 = new XmlNode();
        block0: while (iterator.hasNext()) {
            xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getString("hostname", "null").trim().equals(this.masterHost.trim()) || Integer.parseInt(xmlNode3.getString("adminport", "null").trim()) != this.masterPort) continue;
            Iterator iterator2 = xmlNode3.iterate("SLAVE");
            while (iterator2.hasNext()) {
                XmlNode xmlNode4 = (XmlNode)iterator2.next();
                if (!xmlNode4.getString("id", "null").trim().equals(this.slaveId)) continue;
                Iterator iterator3 = xmlNode4.iterate("VARS");
                XmlNode xmlNode5 = new XmlNode(xmlNode4, "VARS", "", "", 0);
                if (iterator3.hasNext()) {
                    XmlNode xmlNode6 = (XmlNode)iterator3.next();
                    Iterator iterator4 = xmlNode6.iterate();
                    while (iterator4.hasNext()) {
                        XmlNode xmlNode7 = (XmlNode)iterator4.next();
                        Object v = this.optionHash.get(xmlNode7.getName());
                        if (v == null) {
                            throw new Exception(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorAdminServlet1"));
                        }
                        if (v.equals(EDIT_OPTION)) {
                            this.modifyProcessing(xmlNode5, xmlNode7.getName(), this.valueHash.get(xmlNode7.getName()).toString());
                            continue;
                        }
                        if (!this.optionHash.get(xmlNode7.getName()).equals(ADD_OPTION)) continue;
                        this.addProcessing(xmlNode6, xmlNode5, xmlNode7.getName(), this.valueHash.get(xmlNode7.getName()).toString());
                    }
                    this.addProcessing(xmlNode6, xmlNode5, this.nameOfVars[this.nameOfVars.length - 1], this.valueOfVars[this.valueOfVars.length - 1]);
                    xmlNode4.removeChild(xmlNode6);
                    xmlNode4.addChild(xmlNode5);
                    break block0;
                }
                this.addProcessing(null, xmlNode5, this.nameOfVars[this.nameOfVars.length - 1], this.valueOfVars[this.valueOfVars.length - 1]);
                xmlNode4.addChild(xmlNode5);
                break block0;
            }
            break block0;
        }
        return xmlNode2;
    }

    private void addProcessing(XmlNode xmlNode, XmlNode xmlNode2, String string, String string2) throws ServletException {
        if (xmlNode != null) {
            if (string == null || string.trim().equals("")) {
                return;
            }
            XmlNode xmlNode3 = xmlNode.findChildNode(string);
            if (xmlNode3 != null) {
                throw new ServletException(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorVarsServlet1"));
            }
        }
        xmlNode2.addChild(string, string2, "", 0);
    }

    private void modifyProcessing(XmlNode xmlNode, String string, String string2) {
        xmlNode.addChild(string, string2, "", 0);
    }

    private void populate(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter("INSTANCE_NAME");
        this.masterPort = httpServletRequest.getServerPort();
        this.masterHost = httpServletRequest.getServerName();
        this.webAppXmlFile = this.sRoot + "//" + string + "//config//cluster.xml";
    }

    public final void writeToXmlFile(XmlNode xmlNode, String string) throws IOException {
        try {
            XmlNode xmlNode2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println();
            printWriter.print("<" + xmlNode.getName() + " ");
            XmlNode xmlNode3 = xmlNode.getFirstChild();
            printWriter.print(xmlNode3.getName() + "=\"" + xmlNode3.getValue() + "\" >");
            printWriter.println();
            Iterator iterator = xmlNode.iterate();
            while (iterator.hasNext()) {
                xmlNode2 = (XmlNode)iterator.next();
                if (!xmlNode2.getName().equals("MASTER")) continue;
                xmlNode2.save(printWriter);
            }
            iterator = xmlNode.iterate();
            while (iterator.hasNext()) {
                xmlNode2 = (XmlNode)iterator.next();
                if (!xmlNode2.getName().equals("SLAVE")) continue;
                xmlNode2.save(printWriter);
            }
            printWriter.println("</" + xmlNode.getName() + ">");
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            IOException iOException = new IOException(throwable.toString());
            throw iOException;
        }
    }

    private Hashtable getHashtable(String[] stringArray, String[] stringArray2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null && stringArray[i].trim().equals("")) continue;
            if (stringArray2[i] != null) {
                hashtable.put(stringArray[i], stringArray2[i]);
                continue;
            }
            hashtable.put(stringArray[i], "");
        }
        return hashtable;
    }

    public String returnErrorString() {
        return "vars.jsp";
    }
}

